#' 
#' @title Example data from CarboCATLite
#' 
#' @description
#' Data exported from CarboCATLite model run
#' 
#' @format A list with the following fields:
#'  * _time_myr_ : time points in Myr from the model run
#'  * _height_2_km_offshore_m_ : sediment thickness accumulated 2 km from shore  
#'  * _height_4_km_offshore_m_ :  sediment thickness accumulated 4 km from shore   
#'  * _height_6_km_offshore_m_ :  sediment thickness accumulated 6 km from shore 
#'  * _height_8_km_offshore_m_ :  sediment thickness accumulated 8 km from shore 
#'  * _height_10_km_offshore_m_ :  sediment thickness accumulated 10 km from shore 
#'  * _height_12_km_offshore_m_ :  sediment thickness accumulated 12 km from shore 
#'  * _eustatic_SL_m_ : eustatic sea level used for the model run.
#' 
#' @source Elapsed model time, sea level, and accumulated sediment thickness taken from
#' the [scenario A model run here](https://github.com/MindTheGap-ERC/CarboCATLite/tree/scenarioA)
#' 
#' @references
  #' * Burgess, Peter. "CarboCAT: A cellular automata model of heterogeneous carbonate strata." Computers & geosciences 53 (2013): 129-140. \doi{10.1016/j.cageo.2011.08.026}
  #' * Burgess, Peter. (2023). CarboCATLite (v1.0.1). Zenodo. \doi{10.5281/zenodo.8402578}


"CarboCATLite_data"