% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_to_strat.list.R
\name{time_to_strat.list}
\alias{time_to_strat.list}
\title{transform list from time to height domain}
\usage{
\method{time_to_strat}{list}(obj, x, ...)
}
\arguments{
\item{obj}{a list with one element named "t", which will be interpreted as time}

\item{x}{an \emph{adm} object}

\item{...}{options passed to \emph{get_height}}
}
\value{
a \code{stratlist} (inherits from \code{list}): A list with one named element "h" instead of the element "t", containing the stratigraphic positions corresponding to the times inf "t"
}
\description{
Lists are useful to keep data closely associated. This function transforms a list that contains observations
associated with a time (recorded in the element with name "t") into a list where
the observations are associated with stratigraphic position.
}
\examples{
# see vignette("admtools") for an example

}
\seealso{
\code{\link[=strat_to_time.list]{strat_to_time.list()}} for the transformation from height to time domain, \code{\link[=time_to_strat.phylo]{time_to_strat.phylo()}} and \code{\link[=time_to_strat.numeric]{time_to_strat.numeric()}} for transformations of phylogenetic trees and vectors. See \code{\link[=get_height]{get_height()}} for the underlying procedure.
}
