% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adoptr.R
\docType{package}
\name{adoptr}
\alias{adoptr}
\alias{adoptr-package}
\title{Adaptive Optimal Two-Stage Designs}
\description{
The \pkg{adoptr} package provides functionality to explore custom optimal
two-stage designs for one- or two-arm superiority tests.
Currently, only (asymptotically) normal test statistics are supported.
\pkg{adoptr} makes heavy use of the S4 class system.
A good place to start learning about it can be found
\href{http://adv-r.had.co.nz/OO-essentials.html}{here}.
}
\section{Quickstart}{


For a sample workflow and a quick demo of the capabilities, see
\href{https://kkmann.github.io/adoptr/articles/adoptr.html}{here}.

A variety of examples is presented in the validation report hosted
\href{https://kkmann.github.io/adoptr-validation-report/}{here}.
}

\section{Designs}{


\pkg{adoptr} currently supports \code{\link{TwoStageDesign}},
\code{\link{GroupSequentialDesign}}, and \code{\link{OneStageDesign}}.
}

\section{Data distributions}{


Currently, the only implemented data distribution is \code{\link{Normal}}
(one or two arms).
}

\section{Priors}{


Both \code{\link{ContinuousPrior}} and \code{\link{PointMassPrior}} are
supported for the single parameter of a \code{\link{DataDistribution}}.
}

\section{Scores}{


See \code{\link{Scores}} for information on the basic system of representing
scores.
Available scores are \code{\link{ConditionalPower}},
\code{\link{ConditionalSampleSize}}, \code{\link{Power}}, and
\code{\link{ExpectedSampleSize}}..
}

