\name{adwave-package}
\alias{adwave-package}
\alias{adwave}
\docType{package}
\title{Wavelet Analysis of Genomic Data from Admixed Populations}
\description{
Implements wavelet-based approaches for describing population admixture. Principal Components Analysis (PCA) is used to define the population structure and produce a localized admixture signal for each individual. Wavelet summaries of the PCA output describe variation present in the data and can be related to population-level demographic processes. For more details, see Sanderson et al. (2015).
}
\details{
\tabular{ll}{
Package: \tab adwave\cr
Type: \tab Package\cr
Version: \tab 1.1\cr
Date: \tab 2015-06-24\cr
License: GPL (>=2)\cr
}

}
\author{
Jean Sanderson

Maintainer: Murray Cox <m.p.cox@massey.ac.nz>

}
\references{Sanderson, J., H. Sudoyo, T.M. Karafet, M.F. Hammer and M.P. Cox. 2015. Reconstructing past admixture processes from local genomic ancestry using wavelet transformation. \emph{Genetics} 200:469-481.}

\keyword{ package }
\seealso{
\code{\link{signal}},  \code{\link{wavesum}},  \code{\link{plotsignal}}  
}
\examples{
# see examples in individual help files
}
