% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{save_govuk}
\alias{save_govuk}
\title{Save a plot at the correct dimensions for publishing on GOVUK}
\usage{
save_govuk(
  filename,
  plot = ggplot2::last_plot(),
  device = c("svg", "png", "jpg"),
  path = NULL,
  ...
)
}
\arguments{
\item{filename}{File name}

\item{plot}{The plot to save}

\item{device}{File type to produce (svg, png or jpg). svg is preferred as
it scales well without pixelating}

\item{path}{Directory to save the plot in}

\item{...}{Other params passed to ggplot::ggsave}
}
\value{
Character vector giving path to saved file
}
\description{
This is a wrapper around \code{\link[ggplot2:ggsave]{ggplot2::ggsave()}} with plot dimensions set for
publishing on GOVUK.
}
\examples{
library(ggplot2)
library(dplyr)
library(gapminder)

# Images on GOVUK are shrunk. We therefore recommend using font size 20 pt
# when exporting charts for GOVUK, which will appear as approximately 12 pt on
# the website.
use_afcharts(base_size = 20)

grouped_bar_data <-
  gapminder |>
  filter(year \%in\% c(1967, 2007) &
           country \%in\% c("United Kingdom", "Ireland", "France", "Belgium"))

bar_chart <- ggplot(grouped_bar_data,
       aes(x = country, y = lifeExp, fill = as.factor(year))) +
  geom_bar(stat = "identity", position = "dodge") +
  scale_y_continuous(expand = c(0, 0)) +
  scale_fill_discrete_af() +
  labs(
    x = "Country",
    y = NULL,
    fill = NULL,
    title = "Living longer",
    subtitle = "Difference in life expectancy, 1967-2007",
    caption = "Source: Gapminder"
  )

 file <- tempfile(fileext = ".svg")
 save_govuk(file, bar_chart, device = "svg")
 unlink(file)

}
