% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_assumption.R
\name{test_levene}
\alias{test_levene}
\alias{test_sphericity}
\title{Assumption Tests for ANOVAs}
\usage{
test_levene(afex_aov, center = mean, ...)

test_sphericity(afex_aov)
}
\arguments{
\item{afex_aov}{\code{afex_aov} object.}

\item{center}{Function to compute the center of each group; \code{mean} (the
default) gives the original Levene's test.}

\item{...}{passed to \code{\link[car]{leveneTest}}}
}
\description{
\code{test_levene} computes Levene's test for homogeneity of variances across
groups via \code{car::leveneTest}. \code{test_sphericity} computes Mauchly
test of sphericity via \code{car::Anova}.
}
\examples{

### Setup ANOVAs
data(obk.long, package = "afex")
between_1 <- aov_car(value ~ treatment + Error(id), data = obk.long)
between_2 <- aov_car(value ~ treatment*gender + Error(id), data = obk.long)
mixed <- aov_car(value ~ treatment * gender + Error(id/(phase*hour)), data = obk.long)
within <- aov_car(value ~ 1 + Error(id/(phase*hour)), data = obk.long)

### Levene Test for Homogeneity of Variances
test_levene(between_1)
test_levene(between_2)
test_levene(mixed)
\dontrun{
test_levene(within) ## fails
}

### Mauchly Test of Sphericity
\dontrun{
## fails for between-subjects only models:
test_sphericity(between_1)
test_sphericity(between_2)
}
test_sphericity(mixed)
test_sphericity(within)

}
\author{
Mattan S. Ben-Shachar and Henrik Singmann
}
