% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workbook.R
\name{generate_workbook}
\alias{generate_workbook}
\title{Generate A Workbook Object From An 'aftable'}
\usage{
generate_workbook(aftable)
}
\arguments{
\item{aftable}{An aftable-class object created using
\code{\link{create_aftable}} (or \code{\link{as_aftable}}), which
contains the data and information needed to create a workbook.}
}
\value{
A Workbook-class object.
}
\description{
Populate an 'openxlsx' Workbook-class object with content from an
aftable-class object. In turn, the output can be passed to
\code{\link[openxlsx]{saveWorkbook}} from 'openxlsx'
}
\examples{
# Convert an aftable to a Workbook-class object
x <- generate_workbook(demo_aftable)
class(x)

# As above, using a compliant data.frame and the base pipe
y <- demo_df |>
  as_aftable() |>
  generate_workbook()

}
