% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aftgee.R
\name{aftgee.control}
\alias{aftgee.control}
\title{Auxiliary for Controlling AFTGEE Fitting}
\usage{
aftgee.control(maxiter = 50, reltol = 0.001, trace = FALSE,
  seIni = FALSE, parallel = FALSE, parCl = parallel::detectCores()/2,
  gp.pwr = -999)
}
\arguments{
\item{maxiter}{max number of iteration.}

\item{reltol}{relative error tolerance.}

\item{trace}{a binary variable, determine whether to display output for each iteration.}

\item{seIni}{a logical value indicating whether a new rank-based initial value is computed
for each resampling sample in variance estimation.}

\item{parallel}{an logical value indicating whether parallel computing is used for resampling and bootstrap.}

\item{parCl}{an integer value indicating the number of CPU cores used when \code{parallel = TRUE}.}

\item{gp.pwr}{an numerical value indicating the GP parameter when \code{rankWeights = GP}.
The default value is half the CPU cores on the current host.}
}
\value{
A list with the arguments as components.
}
\description{
Auxiliary function as user interface for \code{aftgee} and \code{aftsrr} fitting.
}
\details{
When \code{trace} is TRUE, output for each iteration is printed to the screen.
}
\seealso{
\code{\link{aftgee}}
}
