% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wbyscrkm.R
\name{wbyscrkm}
\alias{wbyscrkm}
\title{Bayesian multivariate estimates for competing risk gene expression data using AFT model.}
\usage{
wbyscrkm(m, n, STime, Event, nc, ni, data)
}
\arguments{
\item{m}{Starting column number of covariates of study from high dimensional entered data.}

\item{n}{Ending column number of covariates of study from high dimensional entered data.}

\item{STime}{name of survival time in data.}

\item{Event}{name of event status in data. 0 is for censored and 1 for occurrence of event of interest and 2 for occurrence of event due to other causes.}

\item{nc}{number of markov chain.}

\item{ni}{number of iteration for MCMC.}

\item{data}{High dimensional gene expression data that contains event status with competing risk, survival time and and set of covariates.}
}
\value{
Data frame is containing posterior estimates mean, sd, credible intervals, n.eff and Rhat for beta's, sigma, alpha, tau and deviance (DIC information) of the model for the chosen covariates as columns between m and n. beta's of regression coefficient of the model. beta[1] is for intercept and others are for covariates (which is/are chosen order as columns in data). alpha is shape parameter of the distribution. 'sigma' is the scale parameter of the distribution.
}
\description{
Provides multivariate(maximum 5 covariates of column at a time) posterior estimates of AFT model using MCMC for competing risk high dimensional gene expression data. It also deal with missing values.
}
\details{
Here AFT model has been used with weibull distribution.
This function deals covariates (in data) with missing values. Missing value in any column(covariate) is replaced by mean of that particular covariate.
}
\examples{
##
data(hdata)
wbyscrkm(9,11,STime="os",Event="death2",2,10,hdata)
##
}
\references{
Prabhash et al(2016) <doi:10.21307/stattrans-2016-046>
}
\seealso{
wbysmv, wbyscrku
}
\author{
Atanu Bhattacharjee, Gajendra Kumar Vishwakarma and Pragya Kumari
}
