% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{expand_df}
\alias{expand_df}
\title{Covariate Matrix Expansion}
\usage{
expand_df(X, int_order = 2, poly_order = 4, threshold = 0)
}
\arguments{
\item{X}{Covariate matrix (no intercept).}

\item{int_order}{Order of interactions to be added. Set equal to one if no interactions are desired.}

\item{poly_order}{Order of the polynomials to be added. Set equal to one if no polynomials are desired.}

\item{threshold}{Drop binary variables representing less than \code{threshold}\% of the population. Useful to speed up computation.}
}
\value{
The expanded covariate matrix, as a data frame.
}
\description{
Expands the covariate matrix, adding interactions and polynomials. This is particularly useful for penalized regressions.
}
\details{
\code{expand_df} assumes that categorical variables are coded as \code{factors}. Also, no missing values are allowed.\cr

\code{expand_df} uses \code{\link[stats]{model.matrix}} to expand factors to a set of dummy variables. Then, it identifies continuous covariates as those
not having 0 and 1 as unique values.\cr

\code{expand_df} first introduces all the \code{int_order}-way interactions between the variables (using the expanded set of dummies), and then adds
\code{poly_order}-order polynomials for continuous covariates.
}
\author{
Riccardo Di Francesco
}
