% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hello.R
\name{plot_split_rcbd}
\alias{plot_split_rcbd}
\title{Plot Split Plot Designs with rcbd}
\usage{
plot_split_rcbd(
  design,
  y = "block",
  factor_name_1 = "T1",
  factor_name_2 = "T2",
  subplots = TRUE,
  labels = "plots",
  width = 1,
  height = 1,
  space_width = 0.95,
  space_height = 0.85,
  reverse_y = FALSE,
  reverse_x = FALSE
)
}
\arguments{
\item{design}{outdesign from \code{agricolae} package}

\item{y}{string defines the block}

\item{factor_name_1}{string Which factor should be used for plotting, needs to be a column in outdesign$book}

\item{factor_name_2}{string Which factor should be used for plotting, needs to be a column in outdesign$book}

\item{subplots}{should the plot function return the subplots (default) or main plots?}

\item{labels}{string Describes the column from that the plots are taken to display them}

\item{width}{numeric value, describes the width of a plot in an experiment}

\item{height}{numeric value, describes the height of a plot in an experiment}

\item{space_width}{numeric value, describes the share of the space of the plots. 0=only space, 1=no space between plots in term of width}

\item{space_height}{numeric value, describes the share of the space of the plots. 0=only space, 1=no space between plots in term of height}

\item{reverse_y}{boolean, should the plots of the experiment be changed in reverse order in Row direction? use reverse_y=TRUE to have same sketch as in agricolae. default:reverse_y=FALSE}

\item{reverse_x}{boolean, should the plots of the experiment be changed in reverse order in column direction? default:reverse_x=FALSE}
}
\value{
\code{ggplot} graphic that can be modified, if wished
}
\description{
Plot a design of a split plot experiment with randomized complete blocks design (rcbd) from design.split
}
\examples{
library(agricolaeplotr)
library(agricolae)
T1<-c('a','b','c','d','e')
T2<-c('v','w','x','y','z','zz')
r = 3
outdesign2 <- design.split(trt1=T1, trt2=T2, r=r,serie = 2,
 seed = 0, kinds = 'Super-Duper',randomization=TRUE,
 first=TRUE,design = 'rcbd')
plot_split_rcbd(outdesign2,width = 1,height = 1)
plot_split_rcbd(outdesign2,width = 1,height = 1,reverse_y = TRUE)
plot_split_rcbd(outdesign2,width = 1,height = 1,reverse_x = TRUE,reverse_y = TRUE)
}
