% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hello.R
\name{to_table}
\alias{to_table}
\title{to_table}
\usage{
to_table(object, part = "net_plot", unit = "m", digits = 3, ...)
}
\arguments{
\item{object}{an object, created by DOE_obj with a FieldLayout class}

\item{part}{which part of the summary are you interested?
Choose one of the following: "net_plot","gross_plot","field","experiment"}

\item{unit}{a string that corresponds to measure unit (default is m)}

\item{digits}{integer indicating the number of decimal places (round)
or significant digits (signif) to be used. Negative values are allowed}

\item{...}{further arguments passed to or from other methods}
}
\value{
dataframe with corresponding information about the experiment
}
\description{
Write field experiment information to a dataframe.
}
\examples{
library(agricolaeplotr)
library(agricolae)
varieties<-c('perricholi','yungay','maria bonita','tomasa')
outdesign <-design.youden(varieties,r=2,serie=2,seed=23)
p <- plot_youden(outdesign, labels = 'varieties', width=4, height=3)
stats <- DOE_obj(p)
r <- to_table(stats,part = "net_plot", digits = 2)
r
r <- to_table(stats,part = "gross_plot", digits = 2)
r
r <- to_table(stats,part = "field", digits = 2)
r
r <- to_table(stats,part = "experiment", digits = 2)
r
r <- to_table(stats,part = "all", digits = 2)
r
}
