% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parametersGG.R
\name{parameters_gg}
\alias{parameters_gg}
\title{Genetic Gain Parameters}
\usage{
parameters_gg(model, trait = "trait")
}
\arguments{
\item{model}{Linear regression model (\code{lm} object)}

\item{trait}{A character string indicating the column in data that contains
trials.}
}
\value{
A data.frame with some parameters from the linear regression (Slope,
se_Slope, Intercept, r2, Pr(>F)) and the percentage of Genetic Gain.
}
\description{
Genetic Gain Parameters
}
\examples{
\donttest{
library(ggplot2)
library(agridat)
library(magrittr)
library(agriutilities)

data(baker.barley.uniformity)
dat <- baker.barley.uniformity
head(dat)

model <- lm(yield ~ year, dat)

dat \%>\%
  na.omit() \%>\%
  ggplot(
    aes(x = year, y = yield)
  ) +
  geom_point() +
  geom_smooth(method = "lm") +
  theme_bw()

parameters_gg(model = model, trait = "yield")
}
}
