% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{autoplot.workflow}
\alias{autoplot.workflow}
\alias{autoplot.H2OAutoML}
\title{Plot rankings and metrics of H2O AutoML results}
\usage{
\method{autoplot}{workflow}(object, ...)

\method{autoplot}{H2OAutoML}(
  object,
  type = c("rank", "metric"),
  metric = NULL,
  std_errs = qnorm(0.95),
  ...
)
}
\arguments{
\item{object}{A fitted \code{auto_ml()} model.}

\item{...}{Other options to pass to \code{autoplot()}.}

\item{type}{A character value for whether to plot average ranking ("rank")
or metrics ("metric").}

\item{metric}{A character vector or NULL for which metric to plot.
By default, all metrics will be shown via facets.}

\item{std_errs}{The number of standard errors to plot.}
}
\value{
A ggplot object.
}
\description{
The \code{autoplot()} method plots cross validation performances of candidate
models in H2O AutoML output via facets on each metric.
}
\examples{
\dontshow{if (agua:::should_run_examples()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
if (h2o_running()) {
  auto_fit <- auto_ml() \%>\%
    set_engine("h2o", max_runtime_secs = 5) \%>\%
    set_mode("regression") \%>\%
    fit(mpg ~ ., data = mtcars)

  autoplot(auto_fit)
}
\dontshow{\}) # examplesIf}
}
