% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_power.R
\name{PlotPower}
\alias{PlotPower}
\title{Illustrate statistical power plot of observed sequential analysis.}
\usage{
PlotPower(
  object = NULL,
  txtTtl = NULL,
  lgcPwrO = FALSE,
  lgcLblStdy = FALSE,
  szFntTtl = 1.8,
  szFntTtlX = 1.2,
  szFntTtlY = 1.2,
  szFntAxsX = 0.8,
  szFntAxsY = 0.8,
  szFntLgnd = 0.8,
  szFntStdy = 0.6,
  szPntPwrO = 0.8,
  szPntPwrS = 0.8,
  szLnPwrCtf = 1,
  szLnPwrO = 1.2,
  szLnPwrP = 1.2,
  szLnPwrS = 1.2,
  typPntPwrO = 2,
  typPntPwrS = 2,
  typLnPwrCtf = 2,
  typLnPwrO = 1,
  typLnPwrP = 2,
  typLnPwrS = 1,
  clrTtl = "black",
  clrTtlX = "black",
  clrTtlY = "black",
  clrAxsX = "black",
  clrAxsY = "black",
  clrLgnd = "gray25",
  clrLblStdy = "gray25",
  clrPntPwrO = "gray75",
  clrPntPwrS = "green4",
  clrLnPwrCtf = "gray75",
  clrLnPwrO = "gray75",
  clrLnPwrP = c("firebrick", "blue4"),
  clrLnPwrS = "green4",
  anglStdy = 90
)
}
\arguments{
\item{object}{OBJECT in \strong{DoOSA} class that is an output of observed
sequential analysis using function \code{DoOSA()}.}

\item{txtTtl}{CHARACTER for user-defined main title on the power plot of
observed sequential analysis.}

\item{lgcPwrO}{LOGIC value for indicating whether to show original observed
power without sequential adjustment.}

\item{lgcLblStdy}{LOGIC value for indicating whether to label each data source.}

\item{szFntTtl}{NUMERIC value for indicating font size of main title.}

\item{szFntTtlX}{NUMERIC value for indicating font size of title on axis X.}

\item{szFntTtlY}{NUMERIC value for indicating font size of title on axis Y.}

\item{szFntAxsX}{NUMERIC value for indicating font size of scale on axis X.}

\item{szFntAxsY}{NUMERIC value for indicating font size of scale on axis Y.}

\item{szFntLgnd}{NUMERIC value for indicating font size of legend.}

\item{szFntStdy}{NUMERIC value(s) for indicating font size(s) of the label(s)
of each data source.}

\item{szPntPwrO}{NUMERIC value for indicating size of observed point(s) of
statistical power without sequential adjustment.}

\item{szPntPwrS}{NUMERIC value for indicating size of observed point(s) of
statistical power after sequential adjustment.}

\item{szLnPwrCtf}{NUMERIC value for indicating width of line for assumed power.}

\item{szLnPwrO}{NUMERIC value for indicating width of line for observed
power without sequential adjustment.}

\item{szLnPwrP}{NUMERIC value for indicating width of line for predicted or
expected power after sequential adjustment.}

\item{szLnPwrS}{NUMERIC value for indicating width of line for observed
power after sequential adjustment.}

\item{typPntPwrO}{NUMERIC value(s) between 1 to 5 for indicating type(s) of
observed point(s) without sequential adjustment. Symbols in
the current version includes circle, square, diamond, triangle
point-up, and triangle point down.}

\item{typPntPwrS}{NUMERIC value between 1 to 5 for indicating type of point(s)
after sequential adjustment. Symbols in the current version
includes circle, square, diamond, triangle point-up, and
triangle point down.}

\item{typLnPwrCtf}{NUMERIC value for indicating type of assumed power.}

\item{typLnPwrO}{NUMERIC value for indicating type of line for observed
power without sequential adjustment.}

\item{typLnPwrP}{NUMERIC value for indicating type of line for predicted or
expected power after sequential adjustment.}

\item{typLnPwrS}{NUMERIC value for indicating type of line for observed
power after sequential adjustment.}

\item{clrTtl}{CHARACTER of a color name for main title.}

\item{clrTtlX}{CHARACTER of a color name for title on axis X.}

\item{clrTtlY}{CHARACTER of a color name for title on axis Y.}

\item{clrAxsX}{CHARACTER of a color name for scale on axis X.}

\item{clrAxsY}{CHARACTER of a color name for scale on axis Y.}

\item{clrLgnd}{CHARACTER of a color name for legend.}

\item{clrLblStdy}{CHARACTER of color name(s) for the label(s) of each data source.}

\item{clrPntPwrO}{CHARACTER of color name(s) for observed point(s) of power
without sequential adjustment..}

\item{clrPntPwrS}{CHARACTER of a color name for observed point(s) of power
after sequential adjustment.}

\item{clrLnPwrCtf}{CHARACTER of a color name for assumed power.}

\item{clrLnPwrO}{CHARACTER of a color name for line of observed power without
sequential adjustment.}

\item{clrLnPwrP}{CHARACTER of a color name for line of predicted or expected
power after sequential adjustment.}

\item{clrLnPwrS}{CHARACTER of a color name for line of observed power after
sequential adjustment.}

\item{anglStdy}{NUMERIC value between 0 and 360 for indicating angle of data
source.}
}
\value{
\strong{PlotPower()} returns a plot of statistical power of observed sequential analysis.
}
\description{
\strong{PlotPower()} is a function for plotting power of observed sequential analysis.
}
\examples{
## Not run:
# 1. Import a dataset of study by Fleiss (1993)
library(meta)
data("Fleiss1993bin")

# 2. Perform observed sequential analysis
 output <- DoOSA(Fleiss1993bin, study, year,
                 r1 = d.asp, n1 = n.asp,
                 r2 = d.plac, n2 = n.plac,
                 measure = "RR",
                 group = c("Aspirin", "Control"),
                 plot = TRUE)

# 3. Illustrate statistical power plot of observed sequential analysis
 PlotPower(output)

## End(Not run)

}
\references{
Harrer, M., Cuijpers, P., Furukawa, T.A., & Ebert, D.D. (2021). \emph{Doing}
\emph{Meta-Analysis with R: A Hands-On Guide}. Boca Raton, FL and London: Chapman
& Hall/CRC Press. ISBN 978-0-367-61007-4.

Jennison, C., & Turnbull, B. W. (2005). Meta-analyses and adaptive group
sequential designs in the clinical development process.
\strong{Journal of biopharmaceutical statistics}, \emph{15(4)}, 537–558.
https://doi.org/10.1081/BIP-200062273.

Wetterslev, J., Jakobsen, J. C., & Gluud, C. (2017). Trial sequential analysis
in systematic reviews with meta-analysis. \strong{BMC medical research methodology},
\emph{17(1)}, 1-18.
}
\seealso{
\code{\link{DoSA}}, \code{\link{DoOSA}}, \code{\link{PlotOSA}}
}
\author{
Enoch Kang
}
