% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset.R
\name{aif_dataset}
\alias{aif_dataset}
\title{AIF360 dataset}
\usage{
aif_dataset(data_path,  favor_label, unfavor_label,
                     unprivileged_protected_attribute,
                     privileged_protected_attribute,
                     target_column, protected_attribute)
}
\arguments{
\item{data_path}{Path to the input CSV file or a R dataframe.}

\item{favor_label}{Label value which is considered favorable (i.e. “positive”).}

\item{unfavor_label}{Label value which is considered unfavorable (i.e. “negative”).}

\item{unprivileged_protected_attribute}{A unprotected attribute value which is considered privileged from a fairness perspective.}

\item{privileged_protected_attribute}{A protected attribute value which is considered privileged from a fairness perspective.}

\item{target_column}{Name describing the label.}

\item{protected_attribute}{A feature for which fairness is desired.}
}
\description{
Function to create AIF compatible dataset.
}
\examples{
\donttest{
load_aif360_lib()
# Input dataset
data <- data.frame("feat" = c(0,0,1,1,1,1,0,1,1,0), "label" = c(1,0,0,1,0,0,1,0,1,1))
# Create aif compatible input dataset
act <- aif360::aif_dataset(data_path = data,  favor_label=0, unfavor_label=1,
                            unprivileged_protected_attribute=0,
                            privileged_protected_attribute=1,
                            target_column="label", protected_attribute="feat")
}
}
\seealso{
\href{https://aif360.readthedocs.io/en/latest/modules/datasets.html#binary-label-dataset}{More about AIF binary dataset.}
}
