% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformer_bert.R
\name{create_bert_model}
\alias{create_bert_model}
\title{Function for creating a new transformer based on BERT}
\usage{
create_bert_model(
  ml_framework = aifeducation_config$get_framework(),
  model_dir,
  vocab_raw_texts = NULL,
  vocab_size = 30522,
  vocab_do_lower_case = FALSE,
  max_position_embeddings = 512,
  hidden_size = 768,
  num_hidden_layer = 12,
  num_attention_heads = 12,
  intermediate_size = 3072,
  hidden_act = "gelu",
  hidden_dropout_prob = 0.1,
  attention_probs_dropout_prob = 0.1,
  sustain_track = TRUE,
  sustain_iso_code = NULL,
  sustain_region = NULL,
  sustain_interval = 15,
  trace = TRUE,
  pytorch_safetensors = TRUE
)
}
\arguments{
\item{ml_framework}{\code{string} Framework to use for training and inference.
\code{ml_framework="tensorflow"} for 'tensorflow' and \code{ml_framework="pytorch"}
for 'pytorch'.}

\item{model_dir}{\code{string} Path to the directory where the model should be saved.}

\item{vocab_raw_texts}{\code{vector} containing the raw texts for creating the
vocabulary.}

\item{vocab_size}{\code{int} Size of the vocabulary.}

\item{vocab_do_lower_case}{\code{bool} \code{TRUE} if all words/tokens should be lower case.}

\item{max_position_embeddings}{\code{int} Number of maximal position embeddings. This parameter
also determines the maximum length of a sequence which can be processed with the model.}

\item{hidden_size}{\code{int} Number of neurons in each layer. This parameter determines the
dimensionality of the resulting text embedding.}

\item{num_hidden_layer}{\code{int} Number of hidden layers.}

\item{num_attention_heads}{\code{int} Number of attention heads.}

\item{intermediate_size}{\code{int} Number of neurons in the intermediate layer of
the attention mechanism.}

\item{hidden_act}{\code{string} name of the activation function.}

\item{hidden_dropout_prob}{\code{double} Ratio of dropout.}

\item{attention_probs_dropout_prob}{\code{double} Ratio of dropout for attention
probabilities.}

\item{sustain_track}{\code{bool} If \code{TRUE} energy consumption is tracked
during training via the python library codecarbon.}

\item{sustain_iso_code}{\code{string} ISO code (Alpha-3-Code) for the country. This variable
must be set if sustainability should be tracked. A list can be found on
Wikipedia: \url{https://en.wikipedia.org/wiki/List_of_ISO_3166_country_codes}.}

\item{sustain_region}{Region within a country. Only available for USA and
Canada See the documentation of codecarbon for more information.
\url{https://mlco2.github.io/codecarbon/parameters.html}}

\item{sustain_interval}{\code{integer} Interval in seconds for measuring power
usage.}

\item{trace}{\code{bool} \code{TRUE} if information about the progress should be
printed to the console.}

\item{pytorch_safetensors}{\code{bool} If \code{TRUE} a 'pytorch' model
is saved in safetensors format. If \code{FALSE} or 'safetensors' not available
it is saved in the standard pytorch format (.bin). Only relevant for pytorch models.}
}
\value{
This function does not return an object. Instead the configuration
and the vocabulary of the new model are saved on disk.
}
\description{
This function creates a transformer configuration based on the BERT base architecture
and a vocabulary based on WordPiece by using
the python libraries 'transformers' and 'tokenizers'.
}
\note{
To train the model, pass the directory of the model to the function
\link{train_tune_bert_model}.

This models uses a WordPiece Tokenizer like BERT and can be trained with
whole word masking. Transformer library may show a warning which can be ignored.
}
\references{
Devlin, J., Chang, M.‑W., Lee, K., & Toutanova, K. (2019). BERT:
Pre-training of Deep Bidirectional Transformers for Language
Understanding. In J. Burstein, C. Doran, & T. Solorio (Eds.),
Proceedings of the 2019 Conference of the North (pp. 4171--4186).
Association for Computational Linguistics.
\doi{10.18653/v1/N19-1423}

Hugging Face documentation
\url{https://huggingface.co/docs/transformers/model_doc/bert#transformers.TFBertForMaskedLM}
}
\seealso{
Other Transformer: 
\code{\link{create_deberta_v2_model}()},
\code{\link{create_funnel_model}()},
\code{\link{create_longformer_model}()},
\code{\link{create_roberta_model}()},
\code{\link{train_tune_bert_model}()},
\code{\link{train_tune_deberta_v2_model}()},
\code{\link{train_tune_funnel_model}()},
\code{\link{train_tune_longformer_model}()},
\code{\link{train_tune_roberta_model}()}
}
\concept{Transformer}
