% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/algo_effectiveness.R
\name{algo_effectiveness}
\alias{algo_effectiveness}
\title{Computes the actual and predicted effectiveness of a given algorithm.}
\usage{
algo_effectiveness(mod, num = 1)
}
\arguments{
\item{mod}{A fitted \code{mirt} model using the function \code{irtmodel} or \code{R} package \code{mirt}.}

\item{num}{The algorithm number, for which the goodness of the IRT model is computed.}
}
\value{
A list with the following components:
\item{\code{effective}}{The \code{x,y} coodinates for the actual and predicted effectiveness curves for algorithm \code{num}. }
\item{\code{predictedEff}}{The area under the predicted effectiveness curve. }
\item{\code{actualEff}}{The area under the actual effectiveness curve. }

#'@examples
set.seed(1)
x1 <- sample(1:5, 100, replace = TRUE)
x2 <- sample(1:5, 100, replace = TRUE)
x3 <- sample(1:5, 100, replace = TRUE)
X <- cbind.data.frame(x1, x2, x3)
mod <- irtmodel(X)
out <- algo_effectiveness(mod$model, num=1)
out
}
\description{
This function computes the actual and predicted effectiveness of a given algorithm for different tolerance values.
}
