% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_goodness.R
\name{model_goodness_for_algo}
\alias{model_goodness_for_algo}
\title{Computes the goodness of IRT model for a given algorithm.}
\usage{
model_goodness_for_algo(mod, num = 1)
}
\arguments{
\item{mod}{A fitted \code{mirt} model using the function \code{irtmodel} or \code{R} package \code{mirt}.}

\item{num}{The algorithm number, for which the goodness of the IRT model is computed.}
}
\value{
A list with the following components:
\item{\code{xy}}{The \code{x} values denote the goodness tolerances. The \code{y} values denote the model goodness. }
\item{\code{auc}}{The area under the model goodness curve. }
}
\description{
This function computes the goodness of the IRT model for a given algorithm for different goodness tolerances.
}
\examples{
set.seed(1)
x1 <- sample(1:5, 100, replace = TRUE)
x2 <- sample(1:5, 100, replace = TRUE)
x3 <- sample(1:5, 100, replace = TRUE)
X <- cbind.data.frame(x1, x2, x3)
mod <- irtmodel(X)
out <- model_goodness_for_algo(mod$model, num=1)
out

}
