% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Core.R
\name{readChangeoDb}
\alias{readChangeoDb}
\title{Read a Change-O tab-delimited database file}
\usage{
readChangeoDb(file, select = NULL, drop = NULL, seq_upper = TRUE)
}
\arguments{
\item{file}{tab-delimited database file output by a Change-O tool.}

\item{select}{columns to select from database file.}

\item{drop}{columns to drop from database file.}

\item{seq_upper}{if \code{TRUE} convert sequence columns to upper case;
if \code{FALSE} do not alter sequence columns. See Value 
for a list of which columns are effected.}
}
\value{
A data.frame of the database file. Columns will be imported as is, except for 
          the following columns which will be explicitly converted into character 
          values:
          \itemize{
            \item  SEQUENCE_ID
            \item  CLONE
            \item  SAMPLE
          }
          And the following sequence columns which will converted to upper case if
          \code{seq_upper=TRUE} (default).
          \itemize{
            \item  SEQUENCE_INPUT
            \item  SEQUENCE_VDJ
            \item  SEQUENCE_IMGT
            \item  JUNCTION
            \item  GERMLINE_IMGT
            \item  GERMLINE_IMGT_D_MASK
          }
}
\description{
\code{readChangeoDb} reads a tab-delimited database file created by a Change-O tool 
into a data.frame.
}
\examples{
# Load example data
file <- system.file("extdata", "ExampleDb.gz", package="alakazam")

# Subset columns and convert sequence fields to upper case
df <- readChangeoDb(file, select=c("SEQUENCE_ID", "SEQUENCE_IMGT"), seq_upper=TRUE)

# Drop columns and do not alter sequence field case
df <- readChangeoDb(file, drop=c("D_CALL", "DUPCOUNT"), seq_upper=FALSE)

}
\seealso{
Wraps \code{\link{read.table}}.

Other file input and output functions: \code{\link{makeTempDir}},
  \code{\link{writeChangeoDb}}
}

