% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Topology.R
\name{plotSubtrees}
\alias{plotSubtrees}
\title{Plots subtree statistics for multiple trees}
\usage{
plotSubtrees(graphs, field, stat, root = "Germline", exclude = c("Germline",
  NA), colors = NULL, main_title = "Subtrees",
  legend_title = "Annotation", style = c("box", "violin"), silent = FALSE,
  ...)
}
\arguments{
\item{graphs}{list of igraph objects containing annotated lineage trees.}

\item{field}{string defining the annotation field.}

\item{stat}{string defining the subtree statistic to plot. One of:
\itemize{
  \item  \code{outdegree}:   distribution of normalized node 
                             outdegrees.
  \item  \code{size}:        distribution of normalized subtree sizes.
  \item  \code{depth}:       distribution of subtree depths.
  \item  \code{pathlength}:  distribution of maximum pathlength 
                             beneath nodes.
}}

\item{root}{name of the root (germline) node.}

\item{exclude}{vector of strings defining \code{field} values to exclude from
plotting.}

\item{colors}{named vector of colors for values in \code{field}, with 
names defining annotation names \code{field} column and values
being colors. Also controls the order in which values appear on the
plot. If \code{NULL} alphabetical ordering and a default color palette 
will be used.}

\item{main_title}{string specifying the plot title.}

\item{legend_title}{string specifying the legend title.}

\item{style}{string specifying the style of plot to draw. One of:
\itemize{
  \item \code{"histogram"}:  histogram of the annotation count 
                             distribution with a red dotted line
                             denoting the observed value.
  \item \code{"cdf"}:        cumulative distribution function 
                             of annotation counts with a red 
                             dotted line denoting the observed 
                             value and a blue dotted line 
                             indicating the p-value.
}}

\item{silent}{if \code{TRUE} do not draw the plot and just return the ggplot2 
object; if \code{FALSE} draw the plot.}

\item{...}{additional arguments to pass to ggplot2::theme.}
}
\value{
A \code{ggplot} object defining the plot.
}
\description{
\code{plotSubtree} plots distributions of normalized subtree statistics for a 
set of lineage trees, broken down by annotation value.
}
\examples{
# Define example tree set
graphs <- ExampleTrees[1-10]

# Plot violins of outdegree by sample
plotSubtrees(graphs, "SAMPLE", "out", main_title="Node outdegree", 
             style="v")

# Plot violins of subtree by sample
plotSubtrees(graphs, "SAMPLE", "size", style="v")

# Plot boxplot of pathlength by isotype
plotSubtrees(graphs, "ISOTYPE", "path", colors=IG_COLORS, 
             legend_title="Isotype", style="b")

# Plot boxplot of depth by isotype
plotSubtrees(graphs,  "ISOTYPE", "depth", style="b")

}
\seealso{
Subtree statistics are calculated with \link{summarizeSubtrees}.
}
