% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gene.R
\name{groupGenes}
\alias{groupGenes}
\title{Group sequences by gene assignment}
\usage{
groupGenes(
  data,
  v_call = "v_call",
  j_call = "j_call",
  junc_len = NULL,
  cell_id = NULL,
  locus = "locus",
  only_heavy = TRUE,
  first = FALSE
)
}
\arguments{
\item{data}{data.frame containing sequence data.}

\item{v_call}{name of the column containing the heavy/long chain 
V-segment allele calls.}

\item{j_call}{name of the column containing the heavy/long chain 
J-segment allele calls.}

\item{junc_len}{name of column containing the junction length.
If \code{NULL} then 1-stage partitioning is perform
considering only the V and J genes is performed. 
See Details for further clarification.}

\item{cell_id}{name of the column containing cell identifiers or barcodes. 
If specified, grouping will be performed in single-cell mode
with the behavior governed by the \code{locus} and 
\code{only_heavy} arguments. If set to \code{NULL} then the 
bulk sequencing data is assumed.}

\item{locus}{name of the column containing locus information. 
Only applicable to single-cell data.
Ignored if \code{cell_id=NULL}.}

\item{only_heavy}{use only the IGH (BCR or TRB/TRD (TCR) sequences 
for grouping. Only applicable to single-cell data.
Ignored if \code{cell_id=NULL}.}

\item{first}{if \code{TRUE} only the first call of the gene assignments 
is used. if \code{FALSE} the union of ambiguous gene 
assignments is used to group all sequences with any 
overlapping gene calls.}
}
\value{
Returns a modified data.frame with disjoint union indices 
          in a new \code{vj_group} column. 
          
          If \code{junc_len} is supplied, the grouping this \code{vj_group} 
          will have been based on V, J, and junction length simultaneously. However, 
          the output column name will remain \code{vj_group}.
          
          The output \code{v_call}, \code{j_call}, \code{cell_id}, and \code{locus}
          columns will be converted to type \code{character} if they were of type 
          \code{factor} in the input \code{data}.
}
\description{
\code{groupGenes} will group rows by shared V and J gene assignments, 
and optionally also by junction lengths. IGH:IGK/IGL, TRB:TRA, and TRD:TRG 
paired single-cell BCR/TCR sequencing and unpaired bulk sequencing 
(IGH, TRB, TRD chain only) are supported. In the case of ambiguous (multiple) 
gene assignments, the grouping may be specified to be a union across all 
ambiguous V and J gene pairs, analogous to single-linkage clustering 
(i.e., allowing for chaining).
}
\details{
To invoke single-cell mode the \code{cell_id} argument must be specified and the \code{locus} 
column must be correct. Otherwise, \code{groupGenes} will be run with bulk sequencing assumptions, 
using all input sequences regardless of the values in the \code{locus} column.

Values in the \code{locus} column must be one of \code{c("IGH", "IGI", "IGK", "IGL")} for BCR 
or \code{c("TRA", "TRB", "TRD", "TRG")} for TCR sequences. Otherwise, the function returns an 
error message and stops.

Under single-cell mode with paired chained sequences, there is a choice of whether 
grouping should be done by (a) using IGH (BCR) or TRB/TRD (TCR) sequences only or
(b) using IGH plus IGK/IGL (BCR) or TRB/TRD plus TRA/TRG (TCR). 
This is governed by the \code{only_heavy} argument.

Specifying \code{junc_len} will force \code{groupGenes} to perform a 1-stage partitioning of the 
sequences/cells based on V gene, J gene, and junction length simultaneously. 
If \code{junc_len=NULL} (no column specified), then \code{groupGenes} performs only the first 
stage of a 2-stage partitioning in which sequences/cells are partitioned in the first stage 
based on V gene and J gene, and then in the second stage further splits the groups based on 
junction length (the second stage must be performed independently, as this only returns the
first stage results).

In the input \code{data}, the \code{v_call}, \code{j_call}, \code{cell_id}, and \code{locus} 
columns, if present, must be of type \code{character} (as opposed to \code{factor}). 

It is assumed that ambiguous gene assignments are separated by commas.

All rows containing \code{NA} values in any of the \code{v_call}, \code{j_call}, and \code{junc_len} 
(if \code{junc_len != NULL}) columns will be removed. A warning will be issued when a row 
containing an \code{NA} is removed.
}
\section{Expectations for single-cell data}{


Single-cell paired chain data assumptions:
  \itemize{
     \item every row represents a sequence (chain).
     \item heavy/long and light/short chains of the same cell are linked by \code{cell_id}.
     \item the value in \code{locus} column indicates whether the chain is the heavy/long or light/short chain.
     \item each cell possibly contains multiple heavy/long and/or light/short chains.
     \item every chain has its own V(D)J annotation, in which ambiguous V(D)J 
           annotations, if any, are separated by a comma.
  }
  
Single-cell example:
  \itemize{
     \item A cell has 1 heavy chain and 2 light chains.
     \item There should be 3 rows corresponding to this cell.
     \item One of the light chains may have an ambiguous V annotation which looks like \code{"Homsap IGKV1-39*01 F,Homsap IGKV1D-39*01 F"}.
  }
}

\examples{
# Group by genes
db <- groupGenes(ExampleDb)
head(db$vj_group)
 
}
