% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ALEPlots.R
\name{ALEPlots}
\alias{ALEPlots}
\title{ALE plots with print and plot methods}
\usage{
ALEPlots(
  obj,
  ...,
  ale_centre = "median",
  y_1d_refs = c("25\%", "75\%"),
  rug_sample_size = obj@params$sample_size,
  min_rug_per_interval = 1,
  y_nonsig_band = 0.05,
  seed = 0,
  silent = FALSE
)
}
\arguments{
\item{obj}{\code{ALE} or \code{ModelBoot} object. The object containing ALE data to be plotted.}

\item{...}{not used. Inserted to require explicit naming of subsequent arguments.}

\item{ale_centre}{character(1) in c('median', 'mean', 'zero'). The ALE y values in the plots will be centred relative to this value. 'median' is the default. 'zero' will maintain the actual ALE values, which are centred on zero.}

\item{y_1d_refs}{character or numeric vector. For 1D ALE plots, the y outcome values for which a reference line should be drawn. If a character vector, \code{y_1d_refs} values are names from \code{obj@params$y_summary} (usually quantile names). If a numeric vector, \code{y_1d_refs} values must be values within the range of y, that is, between \code{obj@params$y_summary$min} and \code{obj@params$y_summary$max} inclusive.}

\item{rug_sample_size, min_rug_per_interval}{non-negative integer(1). Rug plots are down-sampled to \code{rug_sample_size} rows, otherwise they can be very slow for large datasets. By default, their size is the value of \code{obj@params$sample_size}. They maintain representativeness of the data by guaranteeing that each of the ALE bins will retain at least \code{min_rug_per_interval} elements; usually set to just 1 (default) or 2. To prevent this down-sampling, set \code{rug_sample_size} to \code{Inf} (but then the \code{ALEPlots} object would store the entire dataset, so could become very large).}

\item{y_nonsig_band}{numeric(1) from 0 to 1. If there are no p-values, some plots (notably the 1D effects plot) will shade grey the inner \code{y_nonsig_band} quantile below and above the \code{ale_centre} average (the median, by default) to indicate nonsignificant effects.}

\item{seed}{See documentation for \code{\link[=ALE]{ALE()}}}

\item{silent}{See documentation for \code{\link[=ALE]{ALE()}}}
}
\value{
An object of class \code{ALEPlots} with properties \code{plots} and \code{params}.
}
\description{
An \code{ALEPlots} S7 object contains the ALE plots from \code{ALE} or \code{ModelBoot} objects stored as \code{ggplot} objects. The \code{ALEPlots} constructor creates all possible plots from the \code{ALE} or \code{ModelBoot} passed to it---not only individual 1D and 2D ALE plots, but also special plots like the ALE effects plot. So, an \code{ALEPlots} object is a collection of plots, almost never a single plot. To retrieve specific plots, use the \code{\link[=get.ALEPlots]{get.ALEPlots()}} method. See the examples with the \code{\link[=ALE]{ALE()}} and \code{\link[=ModelBoot]{ModelBoot()}} objects for how to manipulate \code{ALEPlots} objects.
}
\section{Properties}{

\describe{
\item{plots}{Stores the ALE plots. Use \code{\link[=get.ALEPlots]{get.ALEPlots()}} to access them.}
\item{params}{The parameters used to calculate the ALE plots. These include most of the arguments used to construct the \code{ALEPlots} object. These are either the values provided by the user or used by default if the user did not change them but also includes several objects that are created within the constructor. These extra objects are described here, as well as those parameters that are stored differently from the form in the arguments:

\if{html}{\out{<div class="sourceCode">}}\preformatted{* `y_col`, `y_cats`: See documentation for [ALE()]
* `max_d`: See documentation for [ALE()]
* `requested_x_cols`: See documentation for [ALE()]. Note, however, that `ALEPlots` does not store `ordered_x_cols`.
}\if{html}{\out{</div>}}

}
}
}

\examples{
# See examples with ALE() and ModelBoot() objects.

}
