% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Algorithm.r
\docType{class}
\name{AlgorithmiaAlgorithm-class}
\alias{AlgorithmiaAlgorithm-class}
\alias{AlgorithmiaAlgorithm}
\title{Algorithm object which enables you to call Algorithmia algorithms.
To create one, call: `client$algo("algoUrl")`}
\description{
Algorithm object which enables you to call Algorithmia algorithms.
To create one, call: `client$algo("algoUrl")`
}
\section{Fields}{

\describe{
\item{\code{client}}{Reference to the AlgorithmiaClient object that has the credentials
necessary to make API calls.}

\item{\code{algoUrl}}{The unique identifier for an algorithm. Follows the pattern:
[Algorithm Author]/[Algorithm Name]/[Optional Version] like: 'demo/Hello/0.1.1'.}

\item{\code{queryParameters}}{Mutable list of parameters to use while making
algorithm calls. These can be changed by calling setOptions.}
}}

\section{Methods}{

\describe{
\item{\code{pipe(input)}}{Calls an algorithm with the input provided.}

\item{\code{setOptions(timeout = 300, stdout = FALSE, output = "default",
  parameters = list())}}{Allows you to set the timeout duration (in seconds), whether you want the stdout
that was produced while running the algorithm (this only works when the algorithm
author call it), and whether this should run as async (output = 'void') or in
raw mode (output = 'raw').}
}}

