# Bind

    Code
      signal_bind(XRD, XRD1)[, 1:20]
    Output
           [,1] [,2] [,3] [,4] [,5] [,6] [,7] [,8] [,9] [,10] [,11] [,12] [,13] [,14]
      XRD  6780 6786 6773 6961 6958 6796 6920 6910 6785  6879  6731  6836  6929  6837
      XRD1 8280 8286 8273 8461 8458 8296 8420 8410 8285  8379  8231  8336  8429  8337
           [,15] [,16] [,17] [,18] [,19] [,20]
      XRD   6938  6797  6823  6677  6801  6688
      XRD1  8438  8297  8323  8177  8301  8188

# Mean

    Code
      signal_mean(XRD, XRD1)
    Output
      $x
         [1] 10.00616 10.02618 10.04620 10.06621 10.08623 10.10625 10.12627 10.14628
         [9] 10.16630 10.18632 10.20634 10.22635 10.24637 10.26639 10.28641 10.30642
        [17] 10.32644 10.34646 10.36648 10.38649 10.40651 10.42653 10.44655 10.46656
        [25] 10.48658 10.50660 10.52662 10.54664 10.56665 10.58667 10.60669 10.62671
        [33] 10.64672 10.66674 10.68676 10.70678 10.72679 10.74681 10.76683 10.78685
        [41] 10.80686 10.82688 10.84690 10.86692 10.88693 10.90695 10.92697 10.94699
        [49] 10.96700 10.98702 11.00704 11.02706 11.04708 11.06709 11.08711 11.10713
        [57] 11.12715 11.14716 11.16718 11.18720 11.20722 11.22723 11.24725 11.26727
        [65] 11.28729 11.30730 11.32732 11.34734 11.36736 11.38737 11.40739 11.42741
        [73] 11.44743 11.46744 11.48746 11.50748 11.52750 11.54752 11.56753 11.58755
        [81] 11.60757 11.62759 11.64760 11.66762 11.68764 11.70766 11.72767 11.74769
        [89] 11.76771 11.78773 11.80774 11.82776 11.84778 11.86780 11.88781 11.90783
        [97] 11.92785 11.94787 11.96788 11.98790 12.00792 12.02794 12.04796 12.06797
       [105] 12.08799 12.10801 12.12803 12.14804 12.16806 12.18808 12.20810 12.22811
       [113] 12.24813 12.26815 12.28817 12.30818 12.32820 12.34822 12.36824 12.38825
       [121] 12.40827 12.42829 12.44831 12.46832 12.48834 12.50836 12.52838 12.54840
       [129] 12.56841 12.58843 12.60845 12.62847 12.64848 12.66850 12.68852 12.70854
       [137] 12.72855 12.74857 12.76859 12.78861 12.80862 12.82864 12.84866 12.86868
       [145] 12.88869 12.90871 12.92873 12.94875 12.96876 12.98878 13.00880 13.02882
       [153] 13.04884 13.06885 13.08887 13.10889 13.12891 13.14892 13.16894 13.18896
       [161] 13.20898 13.22899 13.24901 13.26903 13.28905 13.30906 13.32908 13.34910
       [169] 13.36912 13.38913 13.40915 13.42917 13.44919 13.46920 13.48922 13.50924
       [177] 13.52926 13.54928 13.56929 13.58931 13.60933 13.62935 13.64936 13.66938
       [185] 13.68940 13.70942 13.72943 13.74945 13.76947 13.78949 13.80950 13.82952
       [193] 13.84954 13.86956 13.88957 13.90959 13.92961 13.94963 13.96964 13.98966
       [201] 14.00968 14.02970 14.04972 14.06973 14.08975 14.10977 14.12979 14.14980
       [209] 14.16982 14.18984 14.20986 14.22987 14.24989 14.26991 14.28993 14.30994
       [217] 14.32996 14.34998 14.37000 14.39001 14.41003 14.43005 14.45007 14.47008
       [225] 14.49010 14.51012 14.53014 14.55016 14.57017 14.59019 14.61021 14.63023
       [233] 14.65024 14.67026 14.69028 14.71030 14.73031 14.75033 14.77035 14.79037
       [241] 14.81038 14.83040 14.85042 14.87044 14.89045 14.91047 14.93049 14.95051
       [249] 14.97052 14.99054 15.01056 15.03058 15.05060 15.07061 15.09063 15.11065
       [257] 15.13067 15.15068 15.17070 15.19072 15.21074 15.23075 15.25077 15.27079
       [265] 15.29081 15.31082 15.33084 15.35086 15.37088 15.39089 15.41091 15.43093
       [273] 15.45095 15.47096 15.49098 15.51100 15.53102 15.55104 15.57105 15.59107
       [281] 15.61109 15.63111 15.65112 15.67114 15.69116 15.71118 15.73119 15.75121
       [289] 15.77123 15.79125 15.81126 15.83128 15.85130 15.87132 15.89133 15.91135
       [297] 15.93137 15.95139 15.97140 15.99142 16.01144 16.03146 16.05148 16.07149
       [305] 16.09151 16.11153 16.13155 16.15156 16.17158 16.19160 16.21162 16.23163
       [313] 16.25165 16.27167 16.29169 16.31170 16.33172 16.35174 16.37176 16.39177
       [321] 16.41179 16.43181 16.45183 16.47184 16.49186 16.51188 16.53190 16.55192
       [329] 16.57193 16.59195 16.61197 16.63199 16.65200 16.67202 16.69204 16.71206
       [337] 16.73207 16.75209 16.77211 16.79213 16.81214 16.83216 16.85218 16.87220
       [345] 16.89221 16.91223 16.93225 16.95227 16.97228 16.99230 17.01232 17.03234
       [353] 17.05236 17.07237 17.09239 17.11241 17.13243 17.15244 17.17246 17.19248
       [361] 17.21250 17.23251 17.25253 17.27255 17.29257 17.31258 17.33260 17.35262
       [369] 17.37264 17.39265 17.41267 17.43269 17.45271 17.47272 17.49274 17.51276
       [377] 17.53278 17.55280 17.57281 17.59283 17.61285 17.63287 17.65288 17.67290
       [385] 17.69292 17.71294 17.73295 17.75297 17.77299 17.79301 17.81302 17.83304
       [393] 17.85306 17.87308 17.89309 17.91311 17.93313 17.95315 17.97316 17.99318
       [401] 18.01320 18.03322 18.05324 18.07325 18.09327 18.11329 18.13331 18.15332
       [409] 18.17334 18.19336 18.21338 18.23339 18.25341 18.27343 18.29345 18.31346
       [417] 18.33348 18.35350 18.37352 18.39353 18.41355 18.43357 18.45359 18.47360
       [425] 18.49362 18.51364 18.53366 18.55368 18.57369 18.59371 18.61373 18.63375
       [433] 18.65376 18.67378 18.69380 18.71382 18.73383 18.75385 18.77387 18.79389
       [441] 18.81390 18.83392 18.85394 18.87396 18.89397 18.91399 18.93401 18.95403
       [449] 18.97404 18.99406 19.01408 19.03410 19.05412 19.07413 19.09415 19.11417
       [457] 19.13419 19.15420 19.17422 19.19424 19.21426 19.23427 19.25429 19.27431
       [465] 19.29433 19.31434 19.33436 19.35438 19.37440 19.39441 19.41443 19.43445
       [473] 19.45447 19.47448 19.49450 19.51452 19.53454 19.55456 19.57457 19.59459
       [481] 19.61461 19.63463 19.65464 19.67466 19.69468 19.71470 19.73471 19.75473
       [489] 19.77475 19.79477 19.81478 19.83480 19.85482 19.87484 19.89485 19.91487
       [497] 19.93489 19.95491 19.97492 19.99494 20.01496 20.03498 20.05500 20.07501
       [505] 20.09503 20.11505 20.13507 20.15508 20.17510 20.19512 20.21514 20.23515
       [513] 20.25517 20.27519 20.29521 20.31522 20.33524 20.35526 20.37528 20.39529
       [521] 20.41531 20.43533 20.45535 20.47536 20.49538 20.51540 20.53542 20.55544
       [529] 20.57545 20.59547 20.61549 20.63551 20.65552 20.67554 20.69556 20.71558
       [537] 20.73559 20.75561 20.77563 20.79565 20.81566 20.83568 20.85570 20.87572
       [545] 20.89573 20.91575 20.93577 20.95579 20.97580 20.99582 21.01584 21.03586
       [553] 21.05588 21.07589 21.09591 21.11593 21.13595 21.15596 21.17598 21.19600
       [561] 21.21602 21.23603 21.25605 21.27607 21.29609 21.31610 21.33612 21.35614
       [569] 21.37616 21.39617 21.41619 21.43621 21.45623 21.47624 21.49626 21.51628
       [577] 21.53630 21.55632 21.57633 21.59635 21.61637 21.63639 21.65640 21.67642
       [585] 21.69644 21.71646 21.73647 21.75649 21.77651 21.79653 21.81654 21.83656
       [593] 21.85658 21.87660 21.89661 21.91663 21.93665 21.95667 21.97668 21.99670
       [601] 22.01672 22.03674 22.05676 22.07677 22.09679 22.11681 22.13683 22.15684
       [609] 22.17686 22.19688 22.21690 22.23691 22.25693 22.27695 22.29697 22.31698
       [617] 22.33700 22.35702 22.37704 22.39705 22.41707 22.43709 22.45711 22.47712
       [625] 22.49714 22.51716 22.53718 22.55720 22.57721 22.59723 22.61725 22.63727
       [633] 22.65728 22.67730 22.69732 22.71734 22.73735 22.75737 22.77739 22.79741
       [641] 22.81742 22.83744 22.85746 22.87748 22.89749 22.91751 22.93753 22.95755
       [649] 22.97756 22.99758 23.01760 23.03762 23.05764 23.07765 23.09767 23.11769
       [657] 23.13771 23.15772 23.17774 23.19776 23.21778 23.23779 23.25781 23.27783
       [665] 23.29785 23.31786 23.33788 23.35790 23.37792 23.39793 23.41795 23.43797
       [673] 23.45799 23.47800 23.49802 23.51804 23.53806 23.55808 23.57809 23.59811
       [681] 23.61813 23.63815 23.65816 23.67818 23.69820 23.71822 23.73823 23.75825
       [689] 23.77827 23.79829 23.81830 23.83832 23.85834 23.87836 23.89837 23.91839
       [697] 23.93841 23.95843 23.97844 23.99846 24.01848 24.03850 24.05852 24.07853
       [705] 24.09855 24.11857 24.13859 24.15860 24.17862 24.19864 24.21866 24.23867
       [713] 24.25869 24.27871 24.29873 24.31874 24.33876 24.35878 24.37880 24.39881
       [721] 24.41883 24.43885 24.45887 24.47888 24.49890 24.51892 24.53894 24.55896
       [729] 24.57897 24.59899 24.61901 24.63903 24.65904 24.67906 24.69908 24.71910
       [737] 24.73911 24.75913 24.77915 24.79917 24.81918 24.83920 24.85922 24.87924
       [745] 24.89925 24.91927 24.93929 24.95931 24.97932 24.99934 25.01936 25.03938
       [753] 25.05940 25.07941 25.09943 25.11945 25.13947 25.15948 25.17950 25.19952
       [761] 25.21954 25.23955 25.25957 25.27959 25.29961 25.31962 25.33964 25.35966
       [769] 25.37968 25.39969 25.41971 25.43973 25.45975 25.47976 25.49978 25.51980
       [777] 25.53982 25.55984 25.57985 25.59987 25.61989 25.63991 25.65992 25.67994
       [785] 25.69996 25.71998 25.73999 25.76001 25.78003 25.80005 25.82006 25.84008
       [793] 25.86010 25.88012 25.90013 25.92015 25.94017 25.96019 25.98020 26.00022
       [801] 26.02024 26.04026 26.06028 26.08029 26.10031 26.12033 26.14035 26.16036
       [809] 26.18038 26.20040 26.22042 26.24043 26.26045 26.28047 26.30049 26.32050
       [817] 26.34052 26.36054 26.38056 26.40057 26.42059 26.44061 26.46063 26.48064
       [825] 26.50066 26.52068 26.54070 26.56072 26.58073 26.60075 26.62077 26.64079
       [833] 26.66080 26.68082 26.70084 26.72086 26.74087 26.76089 26.78091 26.80093
       [841] 26.82094 26.84096 26.86098 26.88100 26.90101 26.92103 26.94105 26.96107
       [849] 26.98108 27.00110 27.02112 27.04114 27.06116 27.08117 27.10119 27.12121
       [857] 27.14123 27.16124 27.18126 27.20128 27.22130 27.24131 27.26133 27.28135
       [865] 27.30137 27.32138 27.34140 27.36142 27.38144 27.40145 27.42147 27.44149
       [873] 27.46151 27.48152 27.50154 27.52156 27.54158 27.56160 27.58161 27.60163
       [881] 27.62165 27.64167 27.66168 27.68170 27.70172 27.72174 27.74175 27.76177
       [889] 27.78179 27.80181 27.82182 27.84184 27.86186 27.88188 27.90189 27.92191
       [897] 27.94193 27.96195 27.98196 28.00198 28.02200 28.04202 28.06204 28.08205
       [905] 28.10207 28.12209 28.14211 28.16212 28.18214 28.20216 28.22218 28.24219
       [913] 28.26221 28.28223 28.30225 28.32226 28.34228 28.36230 28.38232 28.40233
       [921] 28.42235 28.44237 28.46239 28.48240 28.50242 28.52244 28.54246 28.56248
       [929] 28.58249 28.60251 28.62253 28.64255 28.66256 28.68258 28.70260 28.72262
       [937] 28.74263 28.76265 28.78267 28.80269 28.82270 28.84272 28.86274 28.88276
       [945] 28.90277 28.92279 28.94281 28.96283 28.98284 29.00286 29.02288 29.04290
       [953] 29.06292 29.08293 29.10295 29.12297 29.14299 29.16300 29.18302 29.20304
       [961] 29.22306 29.24307 29.26309 29.28311 29.30313 29.32314 29.34316 29.36318
       [969] 29.38320 29.40321 29.42323 29.44325 29.46327 29.48328 29.50330 29.52332
       [977] 29.54334 29.56336 29.58337 29.60339 29.62341 29.64343 29.66344 29.68346
       [985] 29.70348 29.72350 29.74351 29.76353 29.78355 29.80357 29.82358 29.84360
       [993] 29.86362 29.88364 29.90365 29.92367 29.94369 29.96371 29.98372 30.00374
      [1001] 30.02376 30.04378 30.06380 30.08381 30.10383 30.12385 30.14387 30.16388
      [1009] 30.18390 30.20392 30.22394 30.24395 30.26397 30.28399 30.30401 30.32402
      [1017] 30.34404 30.36406 30.38408 30.40409 30.42411 30.44413 30.46415 30.48416
      [1025] 30.50418 30.52420 30.54422 30.56424 30.58425 30.60427 30.62429 30.64431
      [1033] 30.66432 30.68434 30.70436 30.72438 30.74439 30.76441 30.78443 30.80445
      [1041] 30.82446 30.84448 30.86450 30.88452 30.90453 30.92455 30.94457 30.96459
      [1049] 30.98460 31.00462 31.02464 31.04466 31.06468 31.08469 31.10471 31.12473
      [1057] 31.14475 31.16476 31.18478 31.20480 31.22482 31.24483 31.26485 31.28487
      [1065] 31.30489 31.32490 31.34492 31.36494 31.38496 31.40497 31.42499 31.44501
      [1073] 31.46503 31.48504 31.50506 31.52508 31.54510 31.56512 31.58513 31.60515
      [1081] 31.62517 31.64519 31.66520 31.68522 31.70524 31.72526 31.74527 31.76529
      [1089] 31.78531 31.80533 31.82534 31.84536 31.86538 31.88540 31.90541 31.92543
      [1097] 31.94545 31.96547 31.98548 32.00550 32.02552 32.04554 32.06556 32.08557
      [1105] 32.10559 32.12561 32.14563 32.16564 32.18566 32.20568 32.22570 32.24571
      [1113] 32.26573 32.28575 32.30577 32.32578 32.34580 32.36582 32.38584 32.40585
      [1121] 32.42587 32.44589 32.46591 32.48592 32.50594 32.52596 32.54598 32.56600
      [1129] 32.58601 32.60603 32.62605 32.64607 32.66608 32.68610 32.70612 32.72614
      [1137] 32.74615 32.76617 32.78619 32.80621 32.82622 32.84624 32.86626 32.88628
      [1145] 32.90629 32.92631 32.94633 32.96635 32.98636 33.00638 33.02640 33.04642
      [1153] 33.06644 33.08645 33.10647 33.12649 33.14651 33.16652 33.18654 33.20656
      [1161] 33.22658 33.24659 33.26661 33.28663 33.30665 33.32666 33.34668 33.36670
      [1169] 33.38672 33.40673 33.42675 33.44677 33.46679 33.48680 33.50682 33.52684
      [1177] 33.54686 33.56688 33.58689 33.60691 33.62693 33.64695 33.66696 33.68698
      [1185] 33.70700 33.72702 33.74703 33.76705 33.78707 33.80709 33.82710 33.84712
      [1193] 33.86714 33.88716 33.90717 33.92719 33.94721 33.96723 33.98724 34.00726
      [1201] 34.02728 34.04730 34.06732 34.08733 34.10735 34.12737 34.14739 34.16740
      [1209] 34.18742 34.20744 34.22746 34.24747 34.26749 34.28751 34.30753 34.32754
      [1217] 34.34756 34.36758 34.38760 34.40761 34.42763 34.44765 34.46767 34.48768
      [1225] 34.50770 34.52772 34.54774 34.56776 34.58777 34.60779 34.62781 34.64783
      [1233] 34.66784 34.68786 34.70788 34.72790 34.74791 34.76793 34.78795 34.80797
      [1241] 34.82798 34.84800 34.86802 34.88804 34.90805 34.92807 34.94809 34.96811
      [1249] 34.98812 35.00814 35.02816 35.04818 35.06820 35.08821 35.10823 35.12825
      [1257] 35.14827 35.16828 35.18830 35.20832 35.22834 35.24835 35.26837 35.28839
      [1265] 35.30841 35.32842 35.34844 35.36846 35.38848 35.40849 35.42851 35.44853
      [1273] 35.46855 35.48856 35.50858 35.52860 35.54862 35.56864 35.58865 35.60867
      [1281] 35.62869 35.64871 35.66872 35.68874 35.70876 35.72878 35.74879 35.76881
      [1289] 35.78883 35.80885 35.82886 35.84888 35.86890 35.88892 35.90893 35.92895
      [1297] 35.94897 35.96899 35.98900 36.00902 36.02904 36.04906 36.06908 36.08909
      [1305] 36.10911 36.12913 36.14915 36.16916 36.18918 36.20920 36.22922 36.24923
      [1313] 36.26925 36.28927 36.30929 36.32930 36.34932 36.36934 36.38936 36.40937
      [1321] 36.42939 36.44941 36.46943 36.48944 36.50946 36.52948 36.54950 36.56952
      [1329] 36.58953 36.60955 36.62957 36.64959 36.66960 36.68962 36.70964 36.72966
      [1337] 36.74967 36.76969 36.78971 36.80973 36.82974 36.84976 36.86978 36.88980
      [1345] 36.90981 36.92983 36.94985 36.96987 36.98988 37.00990 37.02992 37.04994
      [1353] 37.06996 37.08997 37.10999 37.13001 37.15003 37.17004 37.19006 37.21008
      [1361] 37.23010 37.25011 37.27013 37.29015 37.31017 37.33018 37.35020 37.37022
      [1369] 37.39024 37.41025 37.43027 37.45029 37.47031 37.49032 37.51034 37.53036
      [1377] 37.55038 37.57040 37.59041 37.61043 37.63045 37.65047 37.67048 37.69050
      [1385] 37.71052 37.73054 37.75055 37.77057 37.79059 37.81061 37.83062 37.85064
      [1393] 37.87066 37.89068 37.91069 37.93071 37.95073 37.97075 37.99076 38.01078
      [1401] 38.03080 38.05082 38.07084 38.09085 38.11087 38.13089 38.15091 38.17092
      [1409] 38.19094 38.21096 38.23098 38.25099 38.27101 38.29103 38.31105 38.33106
      [1417] 38.35108 38.37110 38.39112 38.41113 38.43115 38.45117 38.47119 38.49120
      [1425] 38.51122 38.53124 38.55126 38.57128 38.59129 38.61131 38.63133 38.65135
      [1433] 38.67136 38.69138 38.71140 38.73142 38.75143 38.77145 38.79147 38.81149
      [1441] 38.83150 38.85152 38.87154 38.89156 38.91157 38.93159 38.95161 38.97163
      [1449] 38.99164 39.01166 39.03168 39.05170 39.07172 39.09173 39.11175 39.13177
      [1457] 39.15179 39.17180 39.19182 39.21184 39.23186 39.25187 39.27189 39.29191
      [1465] 39.31193 39.33194 39.35196 39.37198 39.39200 39.41201 39.43203 39.45205
      [1473] 39.47207 39.49208 39.51210 39.53212 39.55214 39.57216 39.59217 39.61219
      [1481] 39.63221 39.65223 39.67224 39.69226 39.71228 39.73230 39.75231 39.77233
      [1489] 39.79235 39.81237 39.83238 39.85240 39.87242 39.89244 39.91245 39.93247
      [1497] 39.95249 39.97251 39.99252 40.01254 40.03256 40.05258 40.07260 40.09261
      [1505] 40.11263 40.13265 40.15267 40.17268 40.19270 40.21272 40.23274 40.25275
      [1513] 40.27277 40.29279 40.31281 40.33282 40.35284 40.37286 40.39288 40.41289
      [1521] 40.43291 40.45293 40.47295 40.49296 40.51298 40.53300 40.55302 40.57304
      [1529] 40.59305 40.61307 40.63309 40.65311 40.67312 40.69314 40.71316 40.73318
      [1537] 40.75319 40.77321 40.79323 40.81325 40.83326 40.85328 40.87330 40.89332
      [1545] 40.91333 40.93335 40.95337 40.97339 40.99340 41.01342 41.03344 41.05346
      [1553] 41.07348 41.09349 41.11351 41.13353 41.15355 41.17356 41.19358 41.21360
      [1561] 41.23362 41.25363 41.27365 41.29367 41.31369 41.33370 41.35372 41.37374
      [1569] 41.39376 41.41377 41.43379 41.45381 41.47383 41.49384 41.51386 41.53388
      [1577] 41.55390 41.57392 41.59393 41.61395 41.63397 41.65399 41.67400 41.69402
      [1585] 41.71404 41.73406 41.75407 41.77409 41.79411 41.81413 41.83414 41.85416
      [1593] 41.87418 41.89420 41.91421 41.93423 41.95425 41.97427 41.99428 42.01430
      [1601] 42.03432 42.05434 42.07436 42.09437 42.11439 42.13441 42.15443 42.17444
      [1609] 42.19446 42.21448 42.23450 42.25451 42.27453 42.29455 42.31457 42.33458
      [1617] 42.35460 42.37462 42.39464 42.41465 42.43467 42.45469 42.47471 42.49472
      [1625] 42.51474 42.53476 42.55478 42.57480 42.59481 42.61483 42.63485 42.65487
      [1633] 42.67488 42.69490 42.71492 42.73494 42.75495 42.77497 42.79499 42.81501
      [1641] 42.83502 42.85504 42.87506 42.89508 42.91509 42.93511 42.95513 42.97515
      [1649] 42.99516 43.01518 43.03520 43.05522 43.07524 43.09525 43.11527 43.13529
      [1657] 43.15531 43.17532 43.19534 43.21536 43.23538 43.25539 43.27541 43.29543
      [1665] 43.31545 43.33546 43.35548 43.37550 43.39552 43.41553 43.43555 43.45557
      [1673] 43.47559 43.49560 43.51562 43.53564 43.55566 43.57568 43.59569 43.61571
      [1681] 43.63573 43.65575 43.67576 43.69578 43.71580 43.73582 43.75583 43.77585
      [1689] 43.79587 43.81589 43.83590 43.85592 43.87594 43.89596 43.91597 43.93599
      [1697] 43.95601 43.97603 43.99604 44.01606 44.03608 44.05610 44.07612 44.09613
      [1705] 44.11615 44.13617 44.15619 44.17620 44.19622 44.21624 44.23626 44.25627
      [1713] 44.27629 44.29631 44.31633 44.33634 44.35636 44.37638 44.39640 44.41641
      [1721] 44.43643 44.45645 44.47647 44.49648 44.51650 44.53652 44.55654 44.57656
      [1729] 44.59657 44.61659 44.63661 44.65663 44.67664 44.69666 44.71668 44.73670
      [1737] 44.75671 44.77673 44.79675 44.81677 44.83678 44.85680 44.87682 44.89684
      [1745] 44.91685 44.93687 44.95689 44.97691 44.99692 45.01694 45.03696 45.05698
      [1753] 45.07700 45.09701 45.11703 45.13705 45.15707 45.17708 45.19710 45.21712
      [1761] 45.23714 45.25715 45.27717 45.29719 45.31721 45.33722 45.35724 45.37726
      [1769] 45.39728 45.41729 45.43731 45.45733 45.47735 45.49736 45.51738 45.53740
      [1777] 45.55742 45.57744 45.59745 45.61747 45.63749 45.65751 45.67752 45.69754
      [1785] 45.71756 45.73758 45.75759 45.77761 45.79763 45.81765 45.83766 45.85768
      [1793] 45.87770 45.89772 45.91773 45.93775 45.95777 45.97779 45.99780 46.01782
      [1801] 46.03784 46.05786 46.07788 46.09789 46.11791 46.13793 46.15795 46.17796
      [1809] 46.19798 46.21800 46.23802 46.25803 46.27805 46.29807 46.31809 46.33810
      [1817] 46.35812 46.37814 46.39816 46.41817 46.43819 46.45821 46.47823 46.49824
      [1825] 46.51826 46.53828 46.55830 46.57832 46.59833 46.61835 46.63837 46.65839
      [1833] 46.67840 46.69842 46.71844 46.73846 46.75847 46.77849 46.79851 46.81853
      [1841] 46.83854 46.85856 46.87858 46.89860 46.91861 46.93863 46.95865 46.97867
      [1849] 46.99868 47.01870 47.03872 47.05874 47.07876 47.09877 47.11879 47.13881
      [1857] 47.15883 47.17884 47.19886 47.21888 47.23890 47.25891 47.27893 47.29895
      [1865] 47.31897 47.33898 47.35900 47.37902 47.39904 47.41905 47.43907 47.45909
      [1873] 47.47911 47.49912 47.51914 47.53916 47.55918 47.57920 47.59921 47.61923
      [1881] 47.63925 47.65927 47.67928 47.69930 47.71932 47.73934 47.75935 47.77937
      [1889] 47.79939 47.81941 47.83942 47.85944 47.87946 47.89948 47.91949 47.93951
      [1897] 47.95953 47.97955 47.99956 48.01958 48.03960 48.05962 48.07964 48.09965
      [1905] 48.11967 48.13969 48.15971 48.17972 48.19974 48.21976 48.23978 48.25979
      [1913] 48.27981 48.29983 48.31985 48.33986 48.35988 48.37990 48.39992 48.41993
      [1921] 48.43995 48.45997 48.47999 48.50000 48.52002 48.54004 48.56006 48.58008
      [1929] 48.60009 48.62011 48.64013 48.66015 48.68016 48.70018 48.72020 48.74022
      [1937] 48.76023 48.78025 48.80027 48.82029 48.84030 48.86032 48.88034 48.90036
      [1945] 48.92037 48.94039 48.96041 48.98043 49.00044 49.02046 49.04048 49.06050
      [1953] 49.08052 49.10053 49.12055 49.14057 49.16059 49.18060 49.20062 49.22064
      [1961] 49.24066 49.26067 49.28069 49.30071 49.32073 49.34074 49.36076 49.38078
      [1969] 49.40080 49.42081 49.44083 49.46085 49.48087 49.50088 49.52090 49.54092
      [1977] 49.56094 49.58096 49.60097 49.62099 49.64101 49.66103 49.68104 49.70106
      [1985] 49.72108 49.74110 49.76111 49.78113 49.80115 49.82117 49.84118 49.86120
      [1993] 49.88122 49.90124 49.92125 49.94127 49.96129 49.98131 50.00132 50.02134
      [2001] 50.04136 50.06138 50.08140 50.10141 50.12143 50.14145 50.16147 50.18148
      [2009] 50.20150 50.22152 50.24154 50.26155 50.28157 50.30159 50.32161 50.34162
      [2017] 50.36164 50.38166 50.40168 50.42169 50.44171 50.46173 50.48175 50.50176
      [2025] 50.52178 50.54180 50.56182 50.58184 50.60185 50.62187 50.64189 50.66191
      [2033] 50.68192 50.70194 50.72196 50.74198 50.76199 50.78201 50.80203 50.82205
      [2041] 50.84206 50.86208 50.88210 50.90212 50.92213 50.94215 50.96217 50.98219
      [2049] 51.00220 51.02222 51.04224 51.06226 51.08228 51.10229 51.12231 51.14233
      [2057] 51.16235 51.18236 51.20238 51.22240 51.24242 51.26243 51.28245 51.30247
      [2065] 51.32249 51.34250 51.36252 51.38254 51.40256 51.42257 51.44259 51.46261
      [2073] 51.48263 51.50264 51.52266 51.54268 51.56270 51.58272 51.60273 51.62275
      [2081] 51.64277 51.66279 51.68280 51.70282 51.72284 51.74286 51.76287 51.78289
      [2089] 51.80291 51.82293 51.84294 51.86296 51.88298 51.90300 51.92301 51.94303
      [2097] 51.96305 51.98307 52.00308 52.02310 52.04312 52.06314 52.08316 52.10317
      [2105] 52.12319 52.14321 52.16323 52.18324 52.20326 52.22328 52.24330 52.26331
      [2113] 52.28333 52.30335 52.32337 52.34338 52.36340 52.38342 52.40344 52.42345
      [2121] 52.44347 52.46349 52.48351 52.50352 52.52354 52.54356 52.56358 52.58360
      [2129] 52.60361 52.62363 52.64365 52.66367 52.68368 52.70370 52.72372 52.74374
      [2137] 52.76375 52.78377 52.80379 52.82381 52.84382 52.86384 52.88386 52.90388
      [2145] 52.92389 52.94391 52.96393 52.98395 53.00396 53.02398 53.04400 53.06402
      [2153] 53.08404 53.10405 53.12407 53.14409 53.16411 53.18412 53.20414 53.22416
      [2161] 53.24418 53.26419 53.28421 53.30423 53.32425 53.34426 53.36428 53.38430
      [2169] 53.40432 53.42433 53.44435 53.46437 53.48439 53.50440 53.52442 53.54444
      [2177] 53.56446 53.58448 53.60449 53.62451 53.64453 53.66455 53.68456 53.70458
      [2185] 53.72460 53.74462 53.76463 53.78465 53.80467 53.82469 53.84470 53.86472
      [2193] 53.88474 53.90476 53.92477 53.94479 53.96481 53.98483 54.00484 54.02486
      [2201] 54.04488 54.06490 54.08492 54.10493 54.12495 54.14497 54.16499 54.18500
      [2209] 54.20502 54.22504 54.24506 54.26507 54.28509 54.30511 54.32513 54.34514
      [2217] 54.36516 54.38518 54.40520 54.42521 54.44523 54.46525 54.48527 54.50528
      [2225] 54.52530 54.54532 54.56534 54.58536 54.60537 54.62539 54.64541 54.66543
      [2233] 54.68544 54.70546 54.72548 54.74550 54.76551 54.78553 54.80555 54.82557
      [2241] 54.84558 54.86560 54.88562 54.90564 54.92565 54.94567 54.96569 54.98571
      [2249] 55.00572 55.02574 55.04576 55.06578 55.08580 55.10581 55.12583 55.14585
      [2257] 55.16587 55.18588 55.20590 55.22592 55.24594 55.26595 55.28597 55.30599
      [2265] 55.32601 55.34602 55.36604 55.38606 55.40608 55.42609 55.44611 55.46613
      [2273] 55.48615 55.50616 55.52618 55.54620 55.56622 55.58624 55.60625 55.62627
      [2281] 55.64629 55.66631 55.68632 55.70634 55.72636 55.74638 55.76639 55.78641
      [2289] 55.80643 55.82645 55.84646 55.86648 55.88650 55.90652 55.92653 55.94655
      [2297] 55.96657 55.98659 56.00660 56.02662 56.04664 56.06666 56.08668 56.10669
      [2305] 56.12671 56.14673 56.16675 56.18676 56.20678 56.22680 56.24682 56.26683
      [2313] 56.28685 56.30687 56.32689 56.34690 56.36692 56.38694 56.40696 56.42697
      [2321] 56.44699 56.46701 56.48703 56.50704 56.52706 56.54708 56.56710 56.58712
      [2329] 56.60713 56.62715 56.64717 56.66719 56.68720 56.70722 56.72724 56.74726
      [2337] 56.76727 56.78729 56.80731 56.82733 56.84734 56.86736 56.88738 56.90740
      [2345] 56.92741 56.94743 56.96745 56.98747 57.00748 57.02750 57.04752 57.06754
      [2353] 57.08756 57.10757 57.12759 57.14761 57.16763 57.18764 57.20766 57.22768
      [2361] 57.24770 57.26771 57.28773 57.30775 57.32777 57.34778 57.36780 57.38782
      [2369] 57.40784 57.42785 57.44787 57.46789 57.48791 57.50792 57.52794 57.54796
      [2377] 57.56798 57.58800 57.60801 57.62803 57.64805 57.66807 57.68808 57.70810
      [2385] 57.72812 57.74814 57.76815 57.78817 57.80819 57.82821 57.84822 57.86824
      [2393] 57.88826 57.90828 57.92829 57.94831 57.96833 57.98835 58.00836 58.02838
      [2401] 58.04840 58.06842 58.08844 58.10845 58.12847 58.14849 58.16851 58.18852
      [2409] 58.20854 58.22856 58.24858 58.26859 58.28861 58.30863 58.32865 58.34866
      [2417] 58.36868 58.38870 58.40872 58.42873 58.44875 58.46877 58.48879 58.50880
      [2425] 58.52882 58.54884 58.56886 58.58888 58.60889 58.62891 58.64893 58.66895
      [2433] 58.68896 58.70898 58.72900 58.74902 58.76903 58.78905 58.80907 58.82909
      [2441] 58.84910 58.86912 58.88914 58.90916 58.92917 58.94919 58.96921 58.98923
      [2449] 59.00924 59.02926 59.04928 59.06930 59.08932 59.10933 59.12935 59.14937
      [2457] 59.16939 59.18940 59.20942 59.22944 59.24946 59.26947 59.28949 59.30951
      [2465] 59.32953 59.34954 59.36956 59.38958 59.40960 59.42961 59.44963 59.46965
      [2473] 59.48967 59.50968 59.52970 59.54972 59.56974 59.58976 59.60977 59.62979
      [2481] 59.64981 59.66983 59.68984 59.70986 59.72988 59.74990 59.76991 59.78993
      [2489] 59.80995 59.82997 59.84998 59.87000 59.89002 59.91004 59.93005 59.95007
      [2497] 59.97009 59.99011 60.01012 60.03014 60.05016 60.07018 60.09020 60.11021
      [2505] 60.13023 60.15025 60.17027 60.19028 60.21030 60.23032 60.25034 60.27035
      [2513] 60.29037 60.31039 60.33041 60.35042 60.37044 60.39046 60.41048 60.43049
      [2521] 60.45051 60.47053 60.49055 60.51056 60.53058 60.55060 60.57062 60.59064
      [2529] 60.61065 60.63067 60.65069 60.67071 60.69072 60.71074 60.73076 60.75078
      [2537] 60.77079 60.79081 60.81083 60.83085 60.85086 60.87088 60.89090 60.91092
      [2545] 60.93093 60.95095 60.97097 60.99099 61.01100 61.03102 61.05104 61.07106
      [2553] 61.09108 61.11109 61.13111 61.15113 61.17115 61.19116 61.21118 61.23120
      [2561] 61.25122 61.27123 61.29125 61.31127 61.33129 61.35130 61.37132 61.39134
      [2569] 61.41136 61.43137 61.45139 61.47141 61.49143 61.51144 61.53146 61.55148
      [2577] 61.57150 61.59152 61.61153 61.63155 61.65157 61.67159 61.69160 61.71162
      [2585] 61.73164 61.75166 61.77167 61.79169 61.81171 61.83173 61.85174 61.87176
      [2593] 61.89178 61.91180 61.93181 61.95183 61.97185 61.99187 62.01188 62.03190
      [2601] 62.05192 62.07194 62.09196 62.11197 62.13199 62.15201 62.17203 62.19204
      [2609] 62.21206 62.23208 62.25210 62.27211 62.29213 62.31215 62.33217 62.35218
      [2617] 62.37220 62.39222 62.41224 62.43225 62.45227 62.47229 62.49231 62.51232
      [2625] 62.53234 62.55236 62.57238 62.59240 62.61241 62.63243 62.65245 62.67247
      [2633] 62.69248 62.71250 62.73252 62.75254 62.77255 62.79257 62.81259 62.83261
      [2641] 62.85262 62.87264 62.89266 62.91268 62.93269 62.95271 62.97273 62.99275
      [2649] 63.01276 63.03278 63.05280 63.07282 63.09284 63.11285 63.13287 63.15289
      [2657] 63.17291 63.19292 63.21294 63.23296 63.25298 63.27299 63.29301 63.31303
      [2665] 63.33305 63.35306 63.37308 63.39310 63.41312 63.43313 63.45315 63.47317
      [2673] 63.49319 63.51320 63.53322 63.55324 63.57326 63.59328 63.61329 63.63331
      [2681] 63.65333 63.67335 63.69336 63.71338 63.73340 63.75342 63.77343 63.79345
      [2689] 63.81347 63.83349 63.85350 63.87352 63.89354 63.91356 63.93357 63.95359
      [2697] 63.97361 63.99363 64.01364 64.03366 64.05368 64.07370 64.09372 64.11373
      [2705] 64.13375 64.15377 64.17379 64.19380 64.21382 64.23384 64.25386 64.27387
      [2713] 64.29389 64.31391 64.33393 64.35394 64.37396 64.39398 64.41400 64.43401
      [2721] 64.45403 64.47405 64.49407 64.51408 64.53410 64.55412 64.57414 64.59416
      [2729] 64.61417 64.63419 64.65421 64.67423 64.69424 64.71426 64.73428 64.75430
      [2737] 64.77431 64.79433 64.81435 64.83437 64.85438 64.87440 64.89442 64.91444
      [2745] 64.93445 64.95447 64.97449 64.99451 65.01452 65.03454 65.05456 65.07458
      [2753] 65.09460 65.11461 65.13463 65.15465 65.17467 65.19468 65.21470 65.23472
      [2761] 65.25474 65.27475 65.29477 65.31479 65.33481 65.35482 65.37484 65.39486
      [2769] 65.41488 65.43489 65.45491 65.47493 65.49495 65.51496 65.53498 65.55500
      [2777] 65.57502 65.59504 65.61505 65.63507 65.65509 65.67511 65.69512 65.71514
      [2785] 65.73516 65.75518 65.77519 65.79521 65.81523 65.83525 65.85526 65.87528
      [2793] 65.89530 65.91532 65.93533 65.95535 65.97537 65.99539 66.01540 66.03542
      [2801] 66.05544 66.07546 66.09548 66.11549 66.13551 66.15553 66.17555 66.19556
      [2809] 66.21558 66.23560 66.25562 66.27563 66.29565 66.31567 66.33569 66.35570
      [2817] 66.37572 66.39574 66.41576 66.43577 66.45579 66.47581 66.49583 66.51584
      [2825] 66.53586 66.55588 66.57590 66.59592 66.61593 66.63595 66.65597 66.67599
      [2833] 66.69600 66.71602 66.73604 66.75606 66.77607 66.79609 66.81611 66.83613
      [2841] 66.85614 66.87616 66.89618 66.91620 66.93621 66.95623 66.97625 66.99627
      [2849] 67.01628 67.03630 67.05632 67.07634 67.09636 67.11637 67.13639 67.15641
      [2857] 67.17643 67.19644 67.21646 67.23648 67.25650 67.27651 67.29653 67.31655
      [2865] 67.33657 67.35658 67.37660 67.39662 67.41664 67.43665 67.45667 67.47669
      [2873] 67.49671 67.51672 67.53674 67.55676 67.57678 67.59680 67.61681 67.63683
      [2881] 67.65685 67.67687 67.69688 67.71690 67.73692 67.75694 67.77695 67.79697
      [2889] 67.81699 67.83701 67.85702 67.87704 67.89706 67.91708 67.93709 67.95711
      [2897] 67.97713 67.99715 68.01716 68.03718 68.05720 68.07722 68.09724 68.11725
      [2905] 68.13727 68.15729 68.17731 68.19732 68.21734 68.23736 68.25738 68.27739
      [2913] 68.29741 68.31743 68.33745 68.35746 68.37748 68.39750 68.41752 68.43753
      [2921] 68.45755 68.47757 68.49759 68.51760 68.53762 68.55764 68.57766 68.59768
      [2929] 68.61769 68.63771 68.65773 68.67775 68.69776 68.71778 68.73780 68.75782
      [2937] 68.77783 68.79785 68.81787 68.83789 68.85790 68.87792 68.89794 68.91796
      [2945] 68.93797 68.95799 68.97801 68.99803 69.01804 69.03806 69.05808 69.07810
      [2953] 69.09812 69.11813 69.13815 69.15817 69.17819 69.19820 69.21822 69.23824
      [2961] 69.25826 69.27827 69.29829 69.31831 69.33833 69.35834 69.37836 69.39838
      [2969] 69.41840 69.43841 69.45843 69.47845 69.49847 69.51848 69.53850 69.55852
      [2977] 69.57854 69.59856 69.61857 69.63859 69.65861 69.67863 69.69864 69.71866
      [2985] 69.73868 69.75870 69.77871 69.79873 69.81875
      
      $y
         [1]  7530  7536  7523  7711  7708  7546  7670  7660  7535  7629  7481  7586
        [13]  7679  7587  7688  7547  7573  7427  7551  7438  7649  7488  7588  7654
        [25]  7544  7501  7540  7672  7547  7523  7452  7314  7546  7578  7517  7542
        [37]  7476  7526  7450  7475  7470  7386  7392  7508  7316  7417  7396  7452
        [49]  7310  7342  7422  7193  7626  7391  7544  7447  7463  7481  7462  7346
        [61]  7245  7480  7409  7445  7441  7212  7351  7351  7419  7271  7290  7161
        [73]  7428  7207  7392  7426  7290  7339  7417  7341  7342  7408  7266  7381
        [85]  7335  7279  7200  7463  7268  7285  7516  7256  7419  7182  7158  7312
        [97]  7231  7372  7197  7323  7253  7184  7232  7236  7203  7171  7214  7113
       [109]  7112  7331  7340  7199  7160  7237  7236  7281  7201  7348  7137  7161
       [121]  7294  7117  7314  7188  7010  7154  7045  7245  7167  7170  7071  7156
       [133]  7292  7178  7082  7147  6982  7149  7128  7206  7176  7134  7154  7209
       [145]  7176  7213  7089  7120  7037  7060  7214  7138  7220  7198  7156  7206
       [157]  7133  7208  7132  7083  7025  7171  7212  6987  6982  7240  7014  7225
       [169]  7006  7100  7047  7174  7202  7272  7235  7492  7461  7594  7700  7768
       [181]  7691  7780  7567  7694  7451  7427  7519  7482  7485  7373  7432  7232
       [193]  7259  6958  7014  7032  6935  6992  6828  6897  6805  6914  6967  6966
       [205]  6944  6753  6949  7050  6853  6699  6846  6764  6714  6761  6843  6800
       [217]  6846  6786  6874  6811  6786  6779  6833  6750  6613  6781  6818  6627
       [229]  6758  6625  6683  6671  6660  6657  6890  6510  6632  6749  6669  6775
       [241]  6778  6686  6687  6602  6615  6542  6704  6733  6490  6623  6474  6644
       [253]  6606  6684  6676  6609  6665  6671  6730  6562  6586  6516  6499  6553
       [265]  6627  6508  6434  6541  6626  6514  6555  6637  6496  6419  6569  6499
       [277]  6735  6375  6494  6490  6412  6428  6474  6454  6469  6501  6453  6488
       [289]  6289  6482  6365  6431  6453  6436  6473  6321  6424  6452  6585  6311
       [301]  6446  6459  6457  6401  6494  6623  6539  6795  6734  6779  6802  6745
       [313]  6612  6672  6513  6302  6360  6299  6386  6367  6262  6369  6395  6313
       [325]  6270  6238  6220  6415  6276  6183  6143  6307  6291  6301  6218  6124
       [337]  6088  6050  6247  6122  6195  6238  6226  6129  6159  6072  6153  6257
       [349]  6113  6117  6194  6208  6137  6256  6212  6235  6179  6137  6125  6220
       [361]  6216  6158  6075  6202  6129  6168  6161  6224  6274  6033  6185  6178
       [373]  6163  6391  6327  6460  6739  6754  6831  6688  6540  6454  6303  6191
       [385]  6121  6075  6075  6109  6052  6025  5989  5917  5888  5988  6067  5993
       [397]  5959  5940  5991  6014  5963  5928  5824  6091  5936  5943  5911  5932
       [409]  5943  5980  6025  5998  6098  5930  5957  5924  5985  5740  5867  5993
       [421]  5902  5975  5780  6011  5958  5920  6031  5992  5896  6072  5851  6048
       [433]  5907  5987  5944  5982  5884  5978  6070  6194  6041  6216  6386  6498
       [445]  6535  6686  6714  6659  6807  6501  6564  6377  6173  6047  5910  5983
       [457]  5982  5768  5995  5943  5902  5733  5886  5867  5944  5826  5772  5821
       [469]  5714  5884  5852  5899  5860  5845  5855  5749  5700  5752  5763  5989
       [481]  5858  6005  5895  5757  5879  6044  5959  5939  5937  5887  5841  6088
       [493]  6018  5796  5760  5884  5867  5888  5916  5905  5861  5926  5912  5855
       [505]  5861  5781  5783  5868  5764  5794  5686  5781  5714  5598  5695  5784
       [517]  5599  5716  5753  5786  5728  5886  5593  5715  5708  5793  5718  5827
       [529]  5663  5763  5724  5729  5969  5856  6122  6372  6960  7577  8419  9589
       [541] 10832 12403 13019 11775 10037  8878  7611  6495  6393  6465  6268  6218
       [553]  6092  5950  6061  5783  5746  5823  5715  5707  5841  5727  5858  5726
       [565]  5565  5810  5800  5722  5561  5783  5748  5690  5632  5747  5742  5789
       [577]  5869  5815  5873  5860  5783  5897  5923  5887  6171  6217  6190  6348
       [589]  6509  6687  6932  7243  7569  8108  8631  9052  9767 10047 10148  9811
       [601]  9305  8421  7843  7471  6947  6658  6315  6275  6280  5961  6004  6012
       [613]  5956  6083  5800  5833  5850  5870  5967  6016  5894  5878  5874  5780
       [625]  5962  6005  5909  6179  5984  6072  6411  6431  6495  6503  6497  6440
       [637]  6242  6193  6138  5909  5952  5859  5994  5819  5776  5895  5995  5869
       [649]  5794  6009  5927  6057  6183  6067  6089  6031  5952  5979  5775  5898
       [661]  5833  5984  5947  5726  5916  5906  5991  6006  6033  6285  6407  6564
       [673]  6946  6997  7279  7571  7956  8063  8174  8356  8187  7972  7742  7546
       [685]  7214  7307  7126  7058  7017  7105  7342  7395  7436  7419  7561  7980
       [697]  8118  8342  8387  8355  7947  7756  7215  6944  6724  6447  6271  6290
       [709]  6142  6132  6086  6112  6084  5968  6004  6112  6005  6138  6200  6260
       [721]  6363  6456  6561  6635  6638  6740  6716  6648  6513  6439  6222  6070
       [733]  6166  6094  5787  5819  5817  5696  5574  5773  5425  5526  5388  5331
       [745]  5375  5413  5332  5488  5342  5314  5346  5418  5384  5423  5297  5293
       [757]  5395  5371  5374  5457  5428  5498  5417  5523  5674  5504  5517  5745
       [769]  5598  5560  5442  5525  5497  5593  5496  5641  5707  5776  5721  5995
       [781]  6056  6188  6484  6701  7050  6921  7159  7262  7165  7028  6904  6634
       [793]  6669  6269  6370  6220  6217  6134  6244  6172  6019  6103  5850  5950
       [805]  6009  6023  6119  6052  6089  5941  6034  5988  6146  6059  6202  6297
       [817]  6401  6781  6927  7254  7731  8287  9379 10335 11676 13430 16071 19212
       [829] 24123 30793 37088 37207 30594 25188 22243 17229 11731  8676  7376  6902
       [841]  6549  6404  6258  6187  6009  6152  6080  6124  6173  6073  6252  6292
       [853]  6201  6353  6275  6208  6316  6461  6460  6588  6825  7065  7384  7864
       [865]  8246  8619  9033  9419  9550  9451  9982 10309 10462 10404 10228 10356
       [877] 10563 10571 10633 10917 11313 11576 12394 12640 13363 14207 15231 15728
       [889] 16043 16497 16711 17401 17753 18246 18230 18681 18294 17998 16926 16156
       [901] 14674 13354 12024 10720  9567  8921  8107  7617  7153  6822  6665  6613
       [913]  6633  6781  6598  6609  6686  6565  6682  6682  6786  6610  6513  6737
       [925]  6509  6329  6372  6086  5860  5791  5503  5484  5504  5428  5474  5457
       [937]  5254  5272  5427  5463  5399  5462  5538  5525  5653  5865  5829  6024
       [949]  6372  6800  6898  7266  7511  7656  7442  7160  7147  6666  6365  6422
       [961]  6134  6356  6311  6530  7125  7770  8631  9455  9852 10146 10167  9699
       [973]  9133  8619  8002  7377  7100  6857  6760  6655  6760  6913  7148  7204
       [985]  7621  8001  8652  9174  9553 10153 10539 10573 10371 10297  9801  9300
       [997]  8696  8287  7726  7234  6778  6641  6554  6315  6138  6247  6372  6499
      [1009]  6513  6783  7000  7297  7536  7638  7789  8035  7985  7902  7707  7713
      [1021]  7549  7691  7319  7091  7010  6788  6687  6554  6509  6219  6103  6344
      [1033]  6301  6326  6436  6622  6568  6750  7011  7215  7572  7419  7648  7616
      [1045]  7556  7259  7192  7066  6917  6789  6627  6709  6608  6827  6692  6928
      [1057]  7199  7553  8113  8403  9222 10374 11469 12597 13473 13997 13993 13815
      [1069] 12895 11921 10854 10003  8949  7952  7533  6819  6590  6515  6240  5963
      [1081]  5850  5670  5616  5490  5438  5324  5341  5305  5236  5376  5348  5355
      [1093]  5393  5646  5496  5439  5407  5389  5508  5424  5498  5352  5161  5155
      [1105]  5212  5087  5227  5236  4947  4955  4988  5120  4933  5075  4984  5012
      [1117]  5046  5042  4906  4947  4769  4887  4982  4936  4969  4958  4954  5000
      [1129]  5181  5343  5135  5154  5279  5133  5132  5043  5054  5036  5039  4978
      [1141]  4903  4833  4709  5035  4984  4862  4867  4851  4776  4936  5028  4944
      [1153]  5140  5083  5188  5144  5222  5093  5109  4987  5006  4940  4858  4916
      [1165]  4754  4786  4804  4660  4733  4781  4775  4746  4634  4619  4755  4703
      [1177]  4757  4775  4702  4772  4843  5078  4945  5002  5028  5080  5076  4961
      [1189]  5047  4975  4921  4805  4638  4696  4654  4536  4499  4447  4512  4488
      [1201]  4444  4466  4517  4430  4489  4458  4476  4425  4375  4420  4553  4351
      [1213]  4509  4397  4449  4452  4546  4512  4446  4482  4527  4553  4444  4572
      [1225]  4570  4562  4695  4571  4704  4616  4675  4729  4741  4833  4891  4810
      [1237]  4899  5058  5164  5387  5403  5513  5451  5541  5786  5736  5747  6012
      [1249]  5846  5930  6092  6080  6028  6121  6074  6171  6245  6352  6485  6664
      [1261]  6616  6838  7154  7161  7258  7428  7274  7282  7299  7491  7361  7510
      [1273]  7335  7485  7560  7695  7857  8050  8164  8448  8488  8660  8452  8516
      [1285]  8260  8002  7780  7658  7369  7241  6885  6616  6479  6296  6003  5937
      [1297]  5901  5689  5799  5680  5722  5608  5571  5478  5536  5535  5328  5456
      [1309]  5304  5363  5316  5294  5287  5430  5325  5480  5488  5601  5609  5845
      [1321]  5939  6111  6561  6731  7040  7418  7234  7014  6952  7035  6983  6798
      [1333]  6719  6576  6483  6492  6353  6253  6141  6010  6000  5701  5722  5520
      [1345]  5464  5348  5260  5118  5071  5026  4993  4950  4864  4638  4690  4819
      [1357]  4709  4785  4748  4683  4864  4995  4930  4978  5103  5110  5237  5207
      [1369]  5449  5432  5504  5509  5488  5427  5351  5315  5092  4918  4934  4869
      [1381]  4779  4653  4503  4469  4465  4456  4290  4319  4276  4348  4279  4242
      [1393]  4276  4207  4238  4267  4291  4191  4228  4301  4308  4168  4276  4356
      [1405]  4376  4256  4228  4217  4341  4225  4270  4198  4234  4153  4127  4154
      [1417]  4179  4205  4143  4237  4138  4172  4071  4149  4173  4279  4229  4108
      [1429]  4164  4155  4185  4194  4343  4240  4303  4369  4437  4274  4367  4451
      [1441]  4473  4550  4563  4571  4418  4653  4597  4608  4617  4704  4804  4865
      [1453]  4830  4982  5063  5088  5280  5312  5410  5363  5319  5523  5446  5491
      [1465]  5631  5636  5658  5741  6057  6307  6558  6959  7048  6307  5888  5617
      [1477]  5655  5499  5275  4814  4615  4468  4660  4453  4485  4324  4436  4327
      [1489]  4338  4374  4383  4424  4301  4299  4296  4176  4345  4228  4200  4263
      [1501]  4101  4219  4182  4128  4294  4434  4281  4438  4615  4489  4642  4878
      [1513]  5080  5255  4967  4932  4792  4974  4836  4900  4720  4689  4628  4601
      [1525]  4600  4669  4621  4499  4546  4568  4538  4462  4532  4438  4402  4454
      [1537]  4331  4429  4465  4440  4367  4558  4599  4619  4555  4547  4533  4378
      [1549]  4513  4400  4350  4273  4239  4150  4271  4085  4251  4150  4133  4065
      [1561]  4101  4151  4076  4190  4132  4060  4053  4121  4073  4224  4079  4112
      [1573]  4137  4163  4083  4142  4146  4194  4193  4226  4317  4413  4267  4400
      [1585]  4299  4376  4497  4534  4541  4592  4563  4707  4625  4627  4625  4630
      [1597]  4629  4688  4791  4831  4767  4944  4961  4979  5243  5349  5263  5499
      [1609]  5677  5526  5726  5427  5587  5753  5685  5705  5807  5746  5860  6094
      [1621]  6043  5882  5729  5476  5319  5276  5156  5058  4891  4792  4634  4528
      [1633]  4536  4494  4514  4552  4491  4551  4430  4401  4492  4514  4538  4507
      [1645]  4564  4629  4465  4516  4566  4496  4558  4534  4532  4493  4481  4619
      [1657]  4589  4651  4752  4758  4718  4573  4623  4434  4457  4398  4330  4237
      [1669]  4074  4045  4194  3999  4012  3882  3980  3905  3992  3981  3984  3922
      [1681]  3961  3884  3908  4062  3999  4050  3945  4048  3963  3935  3998  3935
      [1693]  3885  3923  3868  3984  4001  3927  3921  4016  3998  4121  4119  4081
      [1705]  4050  4153  4149  4180  4283  4201  4255  4354  4543  4568  4627  4847
      [1717]  4906  5029  5067  5190  5142  5220  5167  5236  5116  5153  5077  5094
      [1729]  4982  5052  5074  5218  4996  5128  5154  5158  5193  5133  5280  5052
      [1741]  5061  5197  4924  5022  4987  4880  4803  4644  4682  4684  4533  4539
      [1753]  4385  4400  4356  4243  4160  4284  4102  4111  4054  4082  3997  4070
      [1765]  3971  4037  4057  3972  3988  3972  4008  3975  4061  4152  4099  4097
      [1777]  4087  4160  4192  4087  4292  4209  4273  4356  4439  4535  4604  4702
      [1789]  4698  4562  4391  4575  4524  4506  4534  4462  4502  4246  4360  4309
      [1801]  4228  4262  4144  4132  4141  4045  4103  4055  3890  3835  3968  3971
      [1813]  3932  3954  4019  3900  3927  3871  4009  3905  3827  3892  3983  3966
      [1825]  3928  3851  3945  3967  3943  3970  3933  4038  4011  4031  4072  4045
      [1837]  4222  4165  4207  4304  4292  4323  4377  4389  4456  4511  4613  4656
      [1849]  4679  4656  4719  4674  4646  4706  4642  4646  4669  4555  4571  4461
      [1861]  4430  4457  4388  4380  4322  4330  4357  4461  4434  4523  4424  4477
      [1873]  4478  4637  4460  4405  4431  4253  4245  4107  4259  4201  4090  4097
      [1885]  4023  4035  3830  3955  3791  3908  3857  3860  3899  3980  3983  3972
      [1897]  4007  3988  4058  4055  3914  4052  4053  4096  4136  4032  4004  4140
      [1909]  4136  4269  4209  4371  4302  4246  4194  4210  4252  4288  4380  4508
      [1921]  4536  4578  4603  4758  4656  4765  4702  4617  4464  4561  4452  4448
      [1933]  4372  4226  4256  4257  4194  4278  4217  4095  4233  4320  4302  4259
      [1945]  4217  4303  4307  4256  4342  4203  4222  4395  4503  4415  4436  4511
      [1957]  4578  4680  4637  4735  4708  4745  4834  4820  4986  4955  4982  5006
      [1969]  5059  5111  5124  5011  5032  5014  4982  4883  4771  4866  4805  4770
      [1981]  4612  4582  4465  4487  4545  4597  4479  4521  4476  4634  4651  4768
      [1993]  4755  4765  4764  5075  5036  5291  5502  5449  5916  6217  6617  7273
      [2005]  7514  7399  6809  6152  5862  5794  5866  5824  5516  5163  4830  4592
      [2017]  4365  4428  4261  4269  4284  4228  4293  4320  4334  4409  4487  4491
      [2029]  4460  4492  4471  4394  4390  4360  4371  4237  4268  4090  4251  4161
      [2041]  4199  4051  4043  4032  4016  4048  3970  4065  4033  4043  4080  4042
      [2053]  4015  3985  4061  4042  4080  4030  4153  4197  4063  4110  4140  4303
      [2065]  4266  4207  4435  4438  4355  4444  4455  4449  4564  4754  4658  4843
      [2077]  4851  5034  5022  5164  5076  5034  5206  5087  5089  4930  4948  5080
      [2089]  5057  4961  5112  4970  5134  5054  5341  5424  5637  5697  5907  5974
      [2101]  5850  6081  5897  5768  5686  5367  5399  5357  5246  5046  4996  4837
      [2113]  4818  4606  4419  4446  4467  4302  4324  4270  4151  4262  4166  4223
      [2125]  4179  4176  4076  4189  4161  4135  4208  4121  4062  4232  4216  4271
      [2137]  4254  4284  4156  4303  4372  4355  4369  4420  4268  4331  4252  4253
      [2149]  4313  4299  4269  4277  4318  4227  4230  4374  4207  4322  4291  4233
      [2161]  4293  4295  4173  4269  4200  4211  4194  4246  4144  4082  4169  4006
      [2173]  4083  4122  4092  4068  3926  4076  4041  3965  3770  3922  3814  3863
      [2185]  3811  3841  3745  3809  3723  3820  3845  3696  3559  3725  3693  3796
      [2197]  3715  3737  3753  3798  3779  3653  3670  3703  3835  3817  3751  3681
      [2209]  3790  3810  3855  3813  3834  3977  3858  3883  3956  3902  3929  3794
      [2221]  3886  4009  3996  4034  3913  4017  3955  4069  4067  4025  4014  4019
      [2233]  4117  4039  4172  4199  4185  4335  4502  4546  4734  4638  4715  4555
      [2245]  4344  4323  4251  4437  4277  4283  4182  4114  4060  3945  3934  3943
      [2257]  4020  3890  3859  3932  3858  3930  4030  4068  4031  4071  3964  3878
      [2269]  3832  3912  3779  3858  3817  3809  3813  3711  3710  3635  3617  3721
      [2281]  3788  3704  3657  3642  3713  3662  3630  3534  3643  3691  3642  3672
      [2293]  3707  3718  3817  3802  3759  3792  3776  3745  3850  3970  3916  3832
      [2305]  3980  4117  4061  4042  4074  4177  4327  4391  4255  4503  4380  4452
      [2317]  4404  4486  4426  4487  4469  4467  4354  4381  4494  4398  4308  4376
      [2329]  4304  4413  4531  4351  4341  4359  4326  4285  4331  4353  4327  4338
      [2341]  4147  4161  4253  4064  4147  4087  4098  4112  4053  4109  4038  4107
      [2353]  4074  3983  4111  4055  3895  4004  3916  3989  4056  4041  4015  4066
      [2365]  3976  3977  4003  4036  3958  3965  3916  4035  4049  4039  3878  3956
      [2377]  3925  3788  3989  3871  3769  3706  3828  3731  3835  3787  3797  3669
      [2389]  3692  3801  3691  3788  3721  3662  3786  3807  3671  3769  3726  3740
      [2401]  3760  3702  3693  3728  3675  3750  3708  3768  3631  3661  3712  3625
      [2413]  3599  3632  3681  3704  3692  3648  3726  3698  3629  3720  3651  3742
      [2425]  3656  3714  3687  3744  3696  3747  3689  3808  3784  3821  3803  3831
      [2437]  3825  3912  3942  3879  3920  3940  3866  4002  3917  3960  4063  4084
      [2449]  4132  4092  4114  4055  4043  4075  4227  4058  4153  4079  4134  4088
      [2461]  4038  3976  3994  4046  3892  4014  3962  4020  3995  3999  3935  3929
      [2473]  3872  3939  4052  3943  4120  3935  3959  3988  3972  4229  4064  4211
      [2485]  4325  4409  4408  4465  4608  4718  4746  4837  5076  5396  5476  5551
      [2497]  5547  5141  4923  4851  4844  4722  4764  4775  4636  4638  4320  4095
      [2509]  4096  4046  3982  4048  3941  4101  4055  4060  3928  3990  4049  3978
      [2521]  4021  4001  3906  3967  4019  4090  3988  3841  4114  3977  4057  4158
      [2533]  4095  4092  4183  4100  4088  4186  4096  4136  4076  4054  4183  4101
      [2545]  4117  4117  4144  4118  4013  4077  4075  4092  4175  4236  4183  4302
      [2557]  4324  4423  4429  4435  4549  4543  4469  4525  4486  4425  4536  4585
      [2569]  4581  4456  4399  4306  4279  4307  4218  4126  4190  4157  4080  4120
      [2581]  4045  4105  4034  3993  3956  3942  3945  3954  3906  3997  3865  3976
      [2593]  3960  3914  3975  3984  4047  4020  4004  4023  4071  4049  4167  4143
      [2605]  4038  4146  4245  4156  4091  4048  4023  4053  4089  4203  4044  4068
      [2617]  4174  4046  4173  4141  4118  4043  4023  4057  4200  3994  4045  4141
      [2629]  4103  4044  4089  4113  4164  4058  4063  4020  4040  4110  4082  4122
      [2641]  4153  4082  4121  4055  4140  4186  4045  4096  4124  4101  4119  4003
      [2653]  4055  3863  3993  3943  3995  3951  3996  3868  3936  4045  3947  3865
      [2665]  3860  3870  3889  3771  3799  3815  3895  3743  3775  3839  3775  3779
      [2677]  3846  3875  3820  3763  3733  3723  3763  3828  3862  3821  3921  3955
      [2689]  3908  3949  3840  3948  4023  3999  3945  4123  4128  4138  4135  4082
      [2701]  4052  4082  4091  3915  4073  3932  4031  4022  3928  3990  3964  3800
      [2713]  3861  3932  3931  3853  3936  3827  3844  3788  3868  3841  3880  3924
      [2725]  3858  3931  3901  3812  3912  3873  3900  3926  4162  4154  4080  4109
      [2737]  4087  4207  4117  4167  4243  4248  4271  4278  4293  4357  4337  4357
      [2749]  4424  4201  4300  4383  4323  4337  4266  4213  4200  4222  4325  4156
      [2761]  4140  4154  4185  4208  4143  4077  4226  4171  4057  4121  4164  4278
      [2773]  4082  4171  4179  4171  4059  4235  4218  4247  4143  4171  4170  4254
      [2785]  4173  4195  4052  4135  4117  4124  4089  4076  4124  3978  4050  3991
      [2797]  3971  4100  3981  3955  4003  3924  4051  3991  4047  3989  4000  3964
      [2809]  4023  4105  4091  4020  4041  4010  3971  4052  3973  3899  3928  3927
      [2821]  3856  3854  3864  3897  3932  3780  3893  3835  3718  3763  3765  3727
      [2833]  3758  3676  3769  3770  3726  3724  3648  3722  3744  3679  3714  3656
      [2845]  3767  3821  3774  3702  3734  3763  3786  3773  3903  3803  3849  3886
      [2857]  3890  3821  3828  3907  3912  3872  3919  3954  4016  4094  4017  4159
      [2869]  4053  4146  4168  4124  4255  4330  4401  4343  4396  4472  4579  4580
      [2881]  4671  4793  4953  4949  5127  5104  4928  4725  4763  4693  4628  4717
      [2893]  4791  4780  4792  4813  4767  4710  4779  4760  4965  4930  5067  5044
      [2905]  5056  5108  5000  4921  4883  4902  4986  5078  5169  4998  5016  4867
      [2917]  4645  4595  4490  4447  4449  4407  4315  4154  4254  4171  4078  4042
      [2929]  4077  3930  4085  4025  4038  3942  4040  3923  3894  3899  3969  4069
      [2941]  4118  3864  4018  4026  3999  3923  3947  4032  3931  3945  3925  3903
      [2953]  3894  3922  3911  3842  3861  3798  3736  3787  3735  3776  3747  3678
      [2965]  3683  3633  3673  3736  3707  3725  3704  3635  3596  3717  3640  3584
      [2977]  3672  3667  3638  3624  3758  3698  3761  3620  3648  3671  3648  3693
      [2989]  3614
      

# Correct

    Code
      rubberband
    Output
      $x
         [1] 10.00616 10.02618 10.04620 10.06621 10.08623 10.10625 10.12627 10.14628
         [9] 10.16630 10.18632 10.20634 10.22635 10.24637 10.26639 10.28641 10.30642
        [17] 10.32644 10.34646 10.36648 10.38649 10.40651 10.42653 10.44655 10.46656
        [25] 10.48658 10.50660 10.52662 10.54664 10.56665 10.58667 10.60669 10.62671
        [33] 10.64672 10.66674 10.68676 10.70678 10.72679 10.74681 10.76683 10.78685
        [41] 10.80686 10.82688 10.84690 10.86692 10.88693 10.90695 10.92697 10.94699
        [49] 10.96700 10.98702 11.00704 11.02706 11.04708 11.06709 11.08711 11.10713
        [57] 11.12715 11.14716 11.16718 11.18720 11.20722 11.22723 11.24725 11.26727
        [65] 11.28729 11.30730 11.32732 11.34734 11.36736 11.38737 11.40739 11.42741
        [73] 11.44743 11.46744 11.48746 11.50748 11.52750 11.54752 11.56753 11.58755
        [81] 11.60757 11.62759 11.64760 11.66762 11.68764 11.70766 11.72767 11.74769
        [89] 11.76771 11.78773 11.80774 11.82776 11.84778 11.86780 11.88781 11.90783
        [97] 11.92785 11.94787 11.96788 11.98790 12.00792 12.02794 12.04796 12.06797
       [105] 12.08799 12.10801 12.12803 12.14804 12.16806 12.18808 12.20810 12.22811
       [113] 12.24813 12.26815 12.28817 12.30818 12.32820 12.34822 12.36824 12.38825
       [121] 12.40827 12.42829 12.44831 12.46832 12.48834 12.50836 12.52838 12.54840
       [129] 12.56841 12.58843 12.60845 12.62847 12.64848 12.66850 12.68852 12.70854
       [137] 12.72855 12.74857 12.76859 12.78861 12.80862 12.82864 12.84866 12.86868
       [145] 12.88869 12.90871 12.92873 12.94875 12.96876 12.98878 13.00880 13.02882
       [153] 13.04884 13.06885 13.08887 13.10889 13.12891 13.14892 13.16894 13.18896
       [161] 13.20898 13.22899 13.24901 13.26903 13.28905 13.30906 13.32908 13.34910
       [169] 13.36912 13.38913 13.40915 13.42917 13.44919 13.46920 13.48922 13.50924
       [177] 13.52926 13.54928 13.56929 13.58931 13.60933 13.62935 13.64936 13.66938
       [185] 13.68940 13.70942 13.72943 13.74945 13.76947 13.78949 13.80950 13.82952
       [193] 13.84954 13.86956 13.88957 13.90959 13.92961 13.94963 13.96964 13.98966
       [201] 14.00968 14.02970 14.04972 14.06973 14.08975 14.10977 14.12979 14.14980
       [209] 14.16982 14.18984 14.20986 14.22987 14.24989 14.26991 14.28993 14.30994
       [217] 14.32996 14.34998 14.37000 14.39001 14.41003 14.43005 14.45007 14.47008
       [225] 14.49010 14.51012 14.53014 14.55016 14.57017 14.59019 14.61021 14.63023
       [233] 14.65024 14.67026 14.69028 14.71030 14.73031 14.75033 14.77035 14.79037
       [241] 14.81038 14.83040 14.85042 14.87044 14.89045 14.91047 14.93049 14.95051
       [249] 14.97052 14.99054 15.01056 15.03058 15.05060 15.07061 15.09063 15.11065
       [257] 15.13067 15.15068 15.17070 15.19072 15.21074 15.23075 15.25077 15.27079
       [265] 15.29081 15.31082 15.33084 15.35086 15.37088 15.39089 15.41091 15.43093
       [273] 15.45095 15.47096 15.49098 15.51100 15.53102 15.55104 15.57105 15.59107
       [281] 15.61109 15.63111 15.65112 15.67114 15.69116 15.71118 15.73119 15.75121
       [289] 15.77123 15.79125 15.81126 15.83128 15.85130 15.87132 15.89133 15.91135
       [297] 15.93137 15.95139 15.97140 15.99142 16.01144 16.03146 16.05148 16.07149
       [305] 16.09151 16.11153 16.13155 16.15156 16.17158 16.19160 16.21162 16.23163
       [313] 16.25165 16.27167 16.29169 16.31170 16.33172 16.35174 16.37176 16.39177
       [321] 16.41179 16.43181 16.45183 16.47184 16.49186 16.51188 16.53190 16.55192
       [329] 16.57193 16.59195 16.61197 16.63199 16.65200 16.67202 16.69204 16.71206
       [337] 16.73207 16.75209 16.77211 16.79213 16.81214 16.83216 16.85218 16.87220
       [345] 16.89221 16.91223 16.93225 16.95227 16.97228 16.99230 17.01232 17.03234
       [353] 17.05236 17.07237 17.09239 17.11241 17.13243 17.15244 17.17246 17.19248
       [361] 17.21250 17.23251 17.25253 17.27255 17.29257 17.31258 17.33260 17.35262
       [369] 17.37264 17.39265 17.41267 17.43269 17.45271 17.47272 17.49274 17.51276
       [377] 17.53278 17.55280 17.57281 17.59283 17.61285 17.63287 17.65288 17.67290
       [385] 17.69292 17.71294 17.73295 17.75297 17.77299 17.79301 17.81302 17.83304
       [393] 17.85306 17.87308 17.89309 17.91311 17.93313 17.95315 17.97316 17.99318
       [401] 18.01320 18.03322 18.05324 18.07325 18.09327 18.11329 18.13331 18.15332
       [409] 18.17334 18.19336 18.21338 18.23339 18.25341 18.27343 18.29345 18.31346
       [417] 18.33348 18.35350 18.37352 18.39353 18.41355 18.43357 18.45359 18.47360
       [425] 18.49362 18.51364 18.53366 18.55368 18.57369 18.59371 18.61373 18.63375
       [433] 18.65376 18.67378 18.69380 18.71382 18.73383 18.75385 18.77387 18.79389
       [441] 18.81390 18.83392 18.85394 18.87396 18.89397 18.91399 18.93401 18.95403
       [449] 18.97404 18.99406 19.01408 19.03410 19.05412 19.07413 19.09415 19.11417
       [457] 19.13419 19.15420 19.17422 19.19424 19.21426 19.23427 19.25429 19.27431
       [465] 19.29433 19.31434 19.33436 19.35438 19.37440 19.39441 19.41443 19.43445
       [473] 19.45447 19.47448 19.49450 19.51452 19.53454 19.55456 19.57457 19.59459
       [481] 19.61461 19.63463 19.65464 19.67466 19.69468 19.71470 19.73471 19.75473
       [489] 19.77475 19.79477 19.81478 19.83480 19.85482 19.87484 19.89485 19.91487
       [497] 19.93489 19.95491 19.97492 19.99494 20.01496 20.03498 20.05500 20.07501
       [505] 20.09503 20.11505 20.13507 20.15508 20.17510 20.19512 20.21514 20.23515
       [513] 20.25517 20.27519 20.29521 20.31522 20.33524 20.35526 20.37528 20.39529
       [521] 20.41531 20.43533 20.45535 20.47536 20.49538 20.51540 20.53542 20.55544
       [529] 20.57545 20.59547 20.61549 20.63551 20.65552 20.67554 20.69556 20.71558
       [537] 20.73559 20.75561 20.77563 20.79565 20.81566 20.83568 20.85570 20.87572
       [545] 20.89573 20.91575 20.93577 20.95579 20.97580 20.99582 21.01584 21.03586
       [553] 21.05588 21.07589 21.09591 21.11593 21.13595 21.15596 21.17598 21.19600
       [561] 21.21602 21.23603 21.25605 21.27607 21.29609 21.31610 21.33612 21.35614
       [569] 21.37616 21.39617 21.41619 21.43621 21.45623 21.47624 21.49626 21.51628
       [577] 21.53630 21.55632 21.57633 21.59635 21.61637 21.63639 21.65640 21.67642
       [585] 21.69644 21.71646 21.73647 21.75649 21.77651 21.79653 21.81654 21.83656
       [593] 21.85658 21.87660 21.89661 21.91663 21.93665 21.95667 21.97668 21.99670
       [601] 22.01672 22.03674 22.05676 22.07677 22.09679 22.11681 22.13683 22.15684
       [609] 22.17686 22.19688 22.21690 22.23691 22.25693 22.27695 22.29697 22.31698
       [617] 22.33700 22.35702 22.37704 22.39705 22.41707 22.43709 22.45711 22.47712
       [625] 22.49714 22.51716 22.53718 22.55720 22.57721 22.59723 22.61725 22.63727
       [633] 22.65728 22.67730 22.69732 22.71734 22.73735 22.75737 22.77739 22.79741
       [641] 22.81742 22.83744 22.85746 22.87748 22.89749 22.91751 22.93753 22.95755
       [649] 22.97756 22.99758 23.01760 23.03762 23.05764 23.07765 23.09767 23.11769
       [657] 23.13771 23.15772 23.17774 23.19776 23.21778 23.23779 23.25781 23.27783
       [665] 23.29785 23.31786 23.33788 23.35790 23.37792 23.39793 23.41795 23.43797
       [673] 23.45799 23.47800 23.49802 23.51804 23.53806 23.55808 23.57809 23.59811
       [681] 23.61813 23.63815 23.65816 23.67818 23.69820 23.71822 23.73823 23.75825
       [689] 23.77827 23.79829 23.81830 23.83832 23.85834 23.87836 23.89837 23.91839
       [697] 23.93841 23.95843 23.97844 23.99846 24.01848 24.03850 24.05852 24.07853
       [705] 24.09855 24.11857 24.13859 24.15860 24.17862 24.19864 24.21866 24.23867
       [713] 24.25869 24.27871 24.29873 24.31874 24.33876 24.35878 24.37880 24.39881
       [721] 24.41883 24.43885 24.45887 24.47888 24.49890 24.51892 24.53894 24.55896
       [729] 24.57897 24.59899 24.61901 24.63903 24.65904 24.67906 24.69908 24.71910
       [737] 24.73911 24.75913 24.77915 24.79917 24.81918 24.83920 24.85922 24.87924
       [745] 24.89925 24.91927 24.93929 24.95931 24.97932 24.99934 25.01936 25.03938
       [753] 25.05940 25.07941 25.09943 25.11945 25.13947 25.15948 25.17950 25.19952
       [761] 25.21954 25.23955 25.25957 25.27959 25.29961 25.31962 25.33964 25.35966
       [769] 25.37968 25.39969 25.41971 25.43973 25.45975 25.47976 25.49978 25.51980
       [777] 25.53982 25.55984 25.57985 25.59987 25.61989 25.63991 25.65992 25.67994
       [785] 25.69996 25.71998 25.73999 25.76001 25.78003 25.80005 25.82006 25.84008
       [793] 25.86010 25.88012 25.90013 25.92015 25.94017 25.96019 25.98020 26.00022
       [801] 26.02024 26.04026 26.06028 26.08029 26.10031 26.12033 26.14035 26.16036
       [809] 26.18038 26.20040 26.22042 26.24043 26.26045 26.28047 26.30049 26.32050
       [817] 26.34052 26.36054 26.38056 26.40057 26.42059 26.44061 26.46063 26.48064
       [825] 26.50066 26.52068 26.54070 26.56072 26.58073 26.60075 26.62077 26.64079
       [833] 26.66080 26.68082 26.70084 26.72086 26.74087 26.76089 26.78091 26.80093
       [841] 26.82094 26.84096 26.86098 26.88100 26.90101 26.92103 26.94105 26.96107
       [849] 26.98108 27.00110 27.02112 27.04114 27.06116 27.08117 27.10119 27.12121
       [857] 27.14123 27.16124 27.18126 27.20128 27.22130 27.24131 27.26133 27.28135
       [865] 27.30137 27.32138 27.34140 27.36142 27.38144 27.40145 27.42147 27.44149
       [873] 27.46151 27.48152 27.50154 27.52156 27.54158 27.56160 27.58161 27.60163
       [881] 27.62165 27.64167 27.66168 27.68170 27.70172 27.72174 27.74175 27.76177
       [889] 27.78179 27.80181 27.82182 27.84184 27.86186 27.88188 27.90189 27.92191
       [897] 27.94193 27.96195 27.98196 28.00198 28.02200 28.04202 28.06204 28.08205
       [905] 28.10207 28.12209 28.14211 28.16212 28.18214 28.20216 28.22218 28.24219
       [913] 28.26221 28.28223 28.30225 28.32226 28.34228 28.36230 28.38232 28.40233
       [921] 28.42235 28.44237 28.46239 28.48240 28.50242 28.52244 28.54246 28.56248
       [929] 28.58249 28.60251 28.62253 28.64255 28.66256 28.68258 28.70260 28.72262
       [937] 28.74263 28.76265 28.78267 28.80269 28.82270 28.84272 28.86274 28.88276
       [945] 28.90277 28.92279 28.94281 28.96283 28.98284 29.00286 29.02288 29.04290
       [953] 29.06292 29.08293 29.10295 29.12297 29.14299 29.16300 29.18302 29.20304
       [961] 29.22306 29.24307 29.26309 29.28311 29.30313 29.32314 29.34316 29.36318
       [969] 29.38320 29.40321 29.42323 29.44325 29.46327 29.48328 29.50330 29.52332
       [977] 29.54334 29.56336 29.58337 29.60339 29.62341 29.64343 29.66344 29.68346
       [985] 29.70348 29.72350 29.74351 29.76353 29.78355 29.80357 29.82358 29.84360
       [993] 29.86362 29.88364 29.90365 29.92367 29.94369 29.96371 29.98372 30.00374
      [1001] 30.02376 30.04378 30.06380 30.08381 30.10383 30.12385 30.14387 30.16388
      [1009] 30.18390 30.20392 30.22394 30.24395 30.26397 30.28399 30.30401 30.32402
      [1017] 30.34404 30.36406 30.38408 30.40409 30.42411 30.44413 30.46415 30.48416
      [1025] 30.50418 30.52420 30.54422 30.56424 30.58425 30.60427 30.62429 30.64431
      [1033] 30.66432 30.68434 30.70436 30.72438 30.74439 30.76441 30.78443 30.80445
      [1041] 30.82446 30.84448 30.86450 30.88452 30.90453 30.92455 30.94457 30.96459
      [1049] 30.98460 31.00462 31.02464 31.04466 31.06468 31.08469 31.10471 31.12473
      [1057] 31.14475 31.16476 31.18478 31.20480 31.22482 31.24483 31.26485 31.28487
      [1065] 31.30489 31.32490 31.34492 31.36494 31.38496 31.40497 31.42499 31.44501
      [1073] 31.46503 31.48504 31.50506 31.52508 31.54510 31.56512 31.58513 31.60515
      [1081] 31.62517 31.64519 31.66520 31.68522 31.70524 31.72526 31.74527 31.76529
      [1089] 31.78531 31.80533 31.82534 31.84536 31.86538 31.88540 31.90541 31.92543
      [1097] 31.94545 31.96547 31.98548 32.00550 32.02552 32.04554 32.06556 32.08557
      [1105] 32.10559 32.12561 32.14563 32.16564 32.18566 32.20568 32.22570 32.24571
      [1113] 32.26573 32.28575 32.30577 32.32578 32.34580 32.36582 32.38584 32.40585
      [1121] 32.42587 32.44589 32.46591 32.48592 32.50594 32.52596 32.54598 32.56600
      [1129] 32.58601 32.60603 32.62605 32.64607 32.66608 32.68610 32.70612 32.72614
      [1137] 32.74615 32.76617 32.78619 32.80621 32.82622 32.84624 32.86626 32.88628
      [1145] 32.90629 32.92631 32.94633 32.96635 32.98636 33.00638 33.02640 33.04642
      [1153] 33.06644 33.08645 33.10647 33.12649 33.14651 33.16652 33.18654 33.20656
      [1161] 33.22658 33.24659 33.26661 33.28663 33.30665 33.32666 33.34668 33.36670
      [1169] 33.38672 33.40673 33.42675 33.44677 33.46679 33.48680 33.50682 33.52684
      [1177] 33.54686 33.56688 33.58689 33.60691 33.62693 33.64695 33.66696 33.68698
      [1185] 33.70700 33.72702 33.74703 33.76705 33.78707 33.80709 33.82710 33.84712
      [1193] 33.86714 33.88716 33.90717 33.92719 33.94721 33.96723 33.98724 34.00726
      [1201] 34.02728 34.04730 34.06732 34.08733 34.10735 34.12737 34.14739 34.16740
      [1209] 34.18742 34.20744 34.22746 34.24747 34.26749 34.28751 34.30753 34.32754
      [1217] 34.34756 34.36758 34.38760 34.40761 34.42763 34.44765 34.46767 34.48768
      [1225] 34.50770 34.52772 34.54774 34.56776 34.58777 34.60779 34.62781 34.64783
      [1233] 34.66784 34.68786 34.70788 34.72790 34.74791 34.76793 34.78795 34.80797
      [1241] 34.82798 34.84800 34.86802 34.88804 34.90805 34.92807 34.94809 34.96811
      [1249] 34.98812 35.00814 35.02816 35.04818 35.06820 35.08821 35.10823 35.12825
      [1257] 35.14827 35.16828 35.18830 35.20832 35.22834 35.24835 35.26837 35.28839
      [1265] 35.30841 35.32842 35.34844 35.36846 35.38848 35.40849 35.42851 35.44853
      [1273] 35.46855 35.48856 35.50858 35.52860 35.54862 35.56864 35.58865 35.60867
      [1281] 35.62869 35.64871 35.66872 35.68874 35.70876 35.72878 35.74879 35.76881
      [1289] 35.78883 35.80885 35.82886 35.84888 35.86890 35.88892 35.90893 35.92895
      [1297] 35.94897 35.96899 35.98900 36.00902 36.02904 36.04906 36.06908 36.08909
      [1305] 36.10911 36.12913 36.14915 36.16916 36.18918 36.20920 36.22922 36.24923
      [1313] 36.26925 36.28927 36.30929 36.32930 36.34932 36.36934 36.38936 36.40937
      [1321] 36.42939 36.44941 36.46943 36.48944 36.50946 36.52948 36.54950 36.56952
      [1329] 36.58953 36.60955 36.62957 36.64959 36.66960 36.68962 36.70964 36.72966
      [1337] 36.74967 36.76969 36.78971 36.80973 36.82974 36.84976 36.86978 36.88980
      [1345] 36.90981 36.92983 36.94985 36.96987 36.98988 37.00990 37.02992 37.04994
      [1353] 37.06996 37.08997 37.10999 37.13001 37.15003 37.17004 37.19006 37.21008
      [1361] 37.23010 37.25011 37.27013 37.29015 37.31017 37.33018 37.35020 37.37022
      [1369] 37.39024 37.41025 37.43027 37.45029 37.47031 37.49032 37.51034 37.53036
      [1377] 37.55038 37.57040 37.59041 37.61043 37.63045 37.65047 37.67048 37.69050
      [1385] 37.71052 37.73054 37.75055 37.77057 37.79059 37.81061 37.83062 37.85064
      [1393] 37.87066 37.89068 37.91069 37.93071 37.95073 37.97075 37.99076 38.01078
      [1401] 38.03080 38.05082 38.07084 38.09085 38.11087 38.13089 38.15091 38.17092
      [1409] 38.19094 38.21096 38.23098 38.25099 38.27101 38.29103 38.31105 38.33106
      [1417] 38.35108 38.37110 38.39112 38.41113 38.43115 38.45117 38.47119 38.49120
      [1425] 38.51122 38.53124 38.55126 38.57128 38.59129 38.61131 38.63133 38.65135
      [1433] 38.67136 38.69138 38.71140 38.73142 38.75143 38.77145 38.79147 38.81149
      [1441] 38.83150 38.85152 38.87154 38.89156 38.91157 38.93159 38.95161 38.97163
      [1449] 38.99164 39.01166 39.03168 39.05170 39.07172 39.09173 39.11175 39.13177
      [1457] 39.15179 39.17180 39.19182 39.21184 39.23186 39.25187 39.27189 39.29191
      [1465] 39.31193 39.33194 39.35196 39.37198 39.39200 39.41201 39.43203 39.45205
      [1473] 39.47207 39.49208 39.51210 39.53212 39.55214 39.57216 39.59217 39.61219
      [1481] 39.63221 39.65223 39.67224 39.69226 39.71228 39.73230 39.75231 39.77233
      [1489] 39.79235 39.81237 39.83238 39.85240 39.87242 39.89244 39.91245 39.93247
      [1497] 39.95249 39.97251 39.99252 40.01254 40.03256 40.05258 40.07260 40.09261
      [1505] 40.11263 40.13265 40.15267 40.17268 40.19270 40.21272 40.23274 40.25275
      [1513] 40.27277 40.29279 40.31281 40.33282 40.35284 40.37286 40.39288 40.41289
      [1521] 40.43291 40.45293 40.47295 40.49296 40.51298 40.53300 40.55302 40.57304
      [1529] 40.59305 40.61307 40.63309 40.65311 40.67312 40.69314 40.71316 40.73318
      [1537] 40.75319 40.77321 40.79323 40.81325 40.83326 40.85328 40.87330 40.89332
      [1545] 40.91333 40.93335 40.95337 40.97339 40.99340 41.01342 41.03344 41.05346
      [1553] 41.07348 41.09349 41.11351 41.13353 41.15355 41.17356 41.19358 41.21360
      [1561] 41.23362 41.25363 41.27365 41.29367 41.31369 41.33370 41.35372 41.37374
      [1569] 41.39376 41.41377 41.43379 41.45381 41.47383 41.49384 41.51386 41.53388
      [1577] 41.55390 41.57392 41.59393 41.61395 41.63397 41.65399 41.67400 41.69402
      [1585] 41.71404 41.73406 41.75407 41.77409 41.79411 41.81413 41.83414 41.85416
      [1593] 41.87418 41.89420 41.91421 41.93423 41.95425 41.97427 41.99428 42.01430
      [1601] 42.03432 42.05434 42.07436 42.09437 42.11439 42.13441 42.15443 42.17444
      [1609] 42.19446 42.21448 42.23450 42.25451 42.27453 42.29455 42.31457 42.33458
      [1617] 42.35460 42.37462 42.39464 42.41465 42.43467 42.45469 42.47471 42.49472
      [1625] 42.51474 42.53476 42.55478 42.57480 42.59481 42.61483 42.63485 42.65487
      [1633] 42.67488 42.69490 42.71492 42.73494 42.75495 42.77497 42.79499 42.81501
      [1641] 42.83502 42.85504 42.87506 42.89508 42.91509 42.93511 42.95513 42.97515
      [1649] 42.99516 43.01518 43.03520 43.05522 43.07524 43.09525 43.11527 43.13529
      [1657] 43.15531 43.17532 43.19534 43.21536 43.23538 43.25539 43.27541 43.29543
      [1665] 43.31545 43.33546 43.35548 43.37550 43.39552 43.41553 43.43555 43.45557
      [1673] 43.47559 43.49560 43.51562 43.53564 43.55566 43.57568 43.59569 43.61571
      [1681] 43.63573 43.65575 43.67576 43.69578 43.71580 43.73582 43.75583 43.77585
      [1689] 43.79587 43.81589 43.83590 43.85592 43.87594 43.89596 43.91597 43.93599
      [1697] 43.95601 43.97603 43.99604 44.01606 44.03608 44.05610 44.07612 44.09613
      [1705] 44.11615 44.13617 44.15619 44.17620 44.19622 44.21624 44.23626 44.25627
      [1713] 44.27629 44.29631 44.31633 44.33634 44.35636 44.37638 44.39640 44.41641
      [1721] 44.43643 44.45645 44.47647 44.49648 44.51650 44.53652 44.55654 44.57656
      [1729] 44.59657 44.61659 44.63661 44.65663 44.67664 44.69666 44.71668 44.73670
      [1737] 44.75671 44.77673 44.79675 44.81677 44.83678 44.85680 44.87682 44.89684
      [1745] 44.91685 44.93687 44.95689 44.97691 44.99692 45.01694 45.03696 45.05698
      [1753] 45.07700 45.09701 45.11703 45.13705 45.15707 45.17708 45.19710 45.21712
      [1761] 45.23714 45.25715 45.27717 45.29719 45.31721 45.33722 45.35724 45.37726
      [1769] 45.39728 45.41729 45.43731 45.45733 45.47735 45.49736 45.51738 45.53740
      [1777] 45.55742 45.57744 45.59745 45.61747 45.63749 45.65751 45.67752 45.69754
      [1785] 45.71756 45.73758 45.75759 45.77761 45.79763 45.81765 45.83766 45.85768
      [1793] 45.87770 45.89772 45.91773 45.93775 45.95777 45.97779 45.99780 46.01782
      [1801] 46.03784 46.05786 46.07788 46.09789 46.11791 46.13793 46.15795 46.17796
      [1809] 46.19798 46.21800 46.23802 46.25803 46.27805 46.29807 46.31809 46.33810
      [1817] 46.35812 46.37814 46.39816 46.41817 46.43819 46.45821 46.47823 46.49824
      [1825] 46.51826 46.53828 46.55830 46.57832 46.59833 46.61835 46.63837 46.65839
      [1833] 46.67840 46.69842 46.71844 46.73846 46.75847 46.77849 46.79851 46.81853
      [1841] 46.83854 46.85856 46.87858 46.89860 46.91861 46.93863 46.95865 46.97867
      [1849] 46.99868 47.01870 47.03872 47.05874 47.07876 47.09877 47.11879 47.13881
      [1857] 47.15883 47.17884 47.19886 47.21888 47.23890 47.25891 47.27893 47.29895
      [1865] 47.31897 47.33898 47.35900 47.37902 47.39904 47.41905 47.43907 47.45909
      [1873] 47.47911 47.49912 47.51914 47.53916 47.55918 47.57920 47.59921 47.61923
      [1881] 47.63925 47.65927 47.67928 47.69930 47.71932 47.73934 47.75935 47.77937
      [1889] 47.79939 47.81941 47.83942 47.85944 47.87946 47.89948 47.91949 47.93951
      [1897] 47.95953 47.97955 47.99956 48.01958 48.03960 48.05962 48.07964 48.09965
      [1905] 48.11967 48.13969 48.15971 48.17972 48.19974 48.21976 48.23978 48.25979
      [1913] 48.27981 48.29983 48.31985 48.33986 48.35988 48.37990 48.39992 48.41993
      [1921] 48.43995 48.45997 48.47999 48.50000 48.52002 48.54004 48.56006 48.58008
      [1929] 48.60009 48.62011 48.64013 48.66015 48.68016 48.70018 48.72020 48.74022
      [1937] 48.76023 48.78025 48.80027 48.82029 48.84030 48.86032 48.88034 48.90036
      [1945] 48.92037 48.94039 48.96041 48.98043 49.00044 49.02046 49.04048 49.06050
      [1953] 49.08052 49.10053 49.12055 49.14057 49.16059 49.18060 49.20062 49.22064
      [1961] 49.24066 49.26067 49.28069 49.30071 49.32073 49.34074 49.36076 49.38078
      [1969] 49.40080 49.42081 49.44083 49.46085 49.48087 49.50088 49.52090 49.54092
      [1977] 49.56094 49.58096 49.60097 49.62099 49.64101 49.66103 49.68104 49.70106
      [1985] 49.72108 49.74110 49.76111 49.78113 49.80115 49.82117 49.84118 49.86120
      [1993] 49.88122 49.90124 49.92125 49.94127 49.96129 49.98131 50.00132 50.02134
      [2001] 50.04136 50.06138 50.08140 50.10141 50.12143 50.14145 50.16147 50.18148
      [2009] 50.20150 50.22152 50.24154 50.26155 50.28157 50.30159 50.32161 50.34162
      [2017] 50.36164 50.38166 50.40168 50.42169 50.44171 50.46173 50.48175 50.50176
      [2025] 50.52178 50.54180 50.56182 50.58184 50.60185 50.62187 50.64189 50.66191
      [2033] 50.68192 50.70194 50.72196 50.74198 50.76199 50.78201 50.80203 50.82205
      [2041] 50.84206 50.86208 50.88210 50.90212 50.92213 50.94215 50.96217 50.98219
      [2049] 51.00220 51.02222 51.04224 51.06226 51.08228 51.10229 51.12231 51.14233
      [2057] 51.16235 51.18236 51.20238 51.22240 51.24242 51.26243 51.28245 51.30247
      [2065] 51.32249 51.34250 51.36252 51.38254 51.40256 51.42257 51.44259 51.46261
      [2073] 51.48263 51.50264 51.52266 51.54268 51.56270 51.58272 51.60273 51.62275
      [2081] 51.64277 51.66279 51.68280 51.70282 51.72284 51.74286 51.76287 51.78289
      [2089] 51.80291 51.82293 51.84294 51.86296 51.88298 51.90300 51.92301 51.94303
      [2097] 51.96305 51.98307 52.00308 52.02310 52.04312 52.06314 52.08316 52.10317
      [2105] 52.12319 52.14321 52.16323 52.18324 52.20326 52.22328 52.24330 52.26331
      [2113] 52.28333 52.30335 52.32337 52.34338 52.36340 52.38342 52.40344 52.42345
      [2121] 52.44347 52.46349 52.48351 52.50352 52.52354 52.54356 52.56358 52.58360
      [2129] 52.60361 52.62363 52.64365 52.66367 52.68368 52.70370 52.72372 52.74374
      [2137] 52.76375 52.78377 52.80379 52.82381 52.84382 52.86384 52.88386 52.90388
      [2145] 52.92389 52.94391 52.96393 52.98395 53.00396 53.02398 53.04400 53.06402
      [2153] 53.08404 53.10405 53.12407 53.14409 53.16411 53.18412 53.20414 53.22416
      [2161] 53.24418 53.26419 53.28421 53.30423 53.32425 53.34426 53.36428 53.38430
      [2169] 53.40432 53.42433 53.44435 53.46437 53.48439 53.50440 53.52442 53.54444
      [2177] 53.56446 53.58448 53.60449 53.62451 53.64453 53.66455 53.68456 53.70458
      [2185] 53.72460 53.74462 53.76463 53.78465 53.80467 53.82469 53.84470 53.86472
      [2193] 53.88474 53.90476 53.92477 53.94479 53.96481 53.98483 54.00484 54.02486
      [2201] 54.04488 54.06490 54.08492 54.10493 54.12495 54.14497 54.16499 54.18500
      [2209] 54.20502 54.22504 54.24506 54.26507 54.28509 54.30511 54.32513 54.34514
      [2217] 54.36516 54.38518 54.40520 54.42521 54.44523 54.46525 54.48527 54.50528
      [2225] 54.52530 54.54532 54.56534 54.58536 54.60537 54.62539 54.64541 54.66543
      [2233] 54.68544 54.70546 54.72548 54.74550 54.76551 54.78553 54.80555 54.82557
      [2241] 54.84558 54.86560 54.88562 54.90564 54.92565 54.94567 54.96569 54.98571
      [2249] 55.00572 55.02574 55.04576 55.06578 55.08580 55.10581 55.12583 55.14585
      [2257] 55.16587 55.18588 55.20590 55.22592 55.24594 55.26595 55.28597 55.30599
      [2265] 55.32601 55.34602 55.36604 55.38606 55.40608 55.42609 55.44611 55.46613
      [2273] 55.48615 55.50616 55.52618 55.54620 55.56622 55.58624 55.60625 55.62627
      [2281] 55.64629 55.66631 55.68632 55.70634 55.72636 55.74638 55.76639 55.78641
      [2289] 55.80643 55.82645 55.84646 55.86648 55.88650 55.90652 55.92653 55.94655
      [2297] 55.96657 55.98659 56.00660 56.02662 56.04664 56.06666 56.08668 56.10669
      [2305] 56.12671 56.14673 56.16675 56.18676 56.20678 56.22680 56.24682 56.26683
      [2313] 56.28685 56.30687 56.32689 56.34690 56.36692 56.38694 56.40696 56.42697
      [2321] 56.44699 56.46701 56.48703 56.50704 56.52706 56.54708 56.56710 56.58712
      [2329] 56.60713 56.62715 56.64717 56.66719 56.68720 56.70722 56.72724 56.74726
      [2337] 56.76727 56.78729 56.80731 56.82733 56.84734 56.86736 56.88738 56.90740
      [2345] 56.92741 56.94743 56.96745 56.98747 57.00748 57.02750 57.04752 57.06754
      [2353] 57.08756 57.10757 57.12759 57.14761 57.16763 57.18764 57.20766 57.22768
      [2361] 57.24770 57.26771 57.28773 57.30775 57.32777 57.34778 57.36780 57.38782
      [2369] 57.40784 57.42785 57.44787 57.46789 57.48791 57.50792 57.52794 57.54796
      [2377] 57.56798 57.58800 57.60801 57.62803 57.64805 57.66807 57.68808 57.70810
      [2385] 57.72812 57.74814 57.76815 57.78817 57.80819 57.82821 57.84822 57.86824
      [2393] 57.88826 57.90828 57.92829 57.94831 57.96833 57.98835 58.00836 58.02838
      [2401] 58.04840 58.06842 58.08844 58.10845 58.12847 58.14849 58.16851 58.18852
      [2409] 58.20854 58.22856 58.24858 58.26859 58.28861 58.30863 58.32865 58.34866
      [2417] 58.36868 58.38870 58.40872 58.42873 58.44875 58.46877 58.48879 58.50880
      [2425] 58.52882 58.54884 58.56886 58.58888 58.60889 58.62891 58.64893 58.66895
      [2433] 58.68896 58.70898 58.72900 58.74902 58.76903 58.78905 58.80907 58.82909
      [2441] 58.84910 58.86912 58.88914 58.90916 58.92917 58.94919 58.96921 58.98923
      [2449] 59.00924 59.02926 59.04928 59.06930 59.08932 59.10933 59.12935 59.14937
      [2457] 59.16939 59.18940 59.20942 59.22944 59.24946 59.26947 59.28949 59.30951
      [2465] 59.32953 59.34954 59.36956 59.38958 59.40960 59.42961 59.44963 59.46965
      [2473] 59.48967 59.50968 59.52970 59.54972 59.56974 59.58976 59.60977 59.62979
      [2481] 59.64981 59.66983 59.68984 59.70986 59.72988 59.74990 59.76991 59.78993
      [2489] 59.80995 59.82997 59.84998 59.87000 59.89002 59.91004 59.93005 59.95007
      [2497] 59.97009 59.99011 60.01012 60.03014 60.05016 60.07018 60.09020 60.11021
      [2505] 60.13023 60.15025 60.17027 60.19028 60.21030 60.23032 60.25034 60.27035
      [2513] 60.29037 60.31039 60.33041 60.35042 60.37044 60.39046 60.41048 60.43049
      [2521] 60.45051 60.47053 60.49055 60.51056 60.53058 60.55060 60.57062 60.59064
      [2529] 60.61065 60.63067 60.65069 60.67071 60.69072 60.71074 60.73076 60.75078
      [2537] 60.77079 60.79081 60.81083 60.83085 60.85086 60.87088 60.89090 60.91092
      [2545] 60.93093 60.95095 60.97097 60.99099 61.01100 61.03102 61.05104 61.07106
      [2553] 61.09108 61.11109 61.13111 61.15113 61.17115 61.19116 61.21118 61.23120
      [2561] 61.25122 61.27123 61.29125 61.31127 61.33129 61.35130 61.37132 61.39134
      [2569] 61.41136 61.43137 61.45139 61.47141 61.49143 61.51144 61.53146 61.55148
      [2577] 61.57150 61.59152 61.61153 61.63155 61.65157 61.67159 61.69160 61.71162
      [2585] 61.73164 61.75166 61.77167 61.79169 61.81171 61.83173 61.85174 61.87176
      [2593] 61.89178 61.91180 61.93181 61.95183 61.97185 61.99187 62.01188 62.03190
      [2601] 62.05192 62.07194 62.09196 62.11197 62.13199 62.15201 62.17203 62.19204
      [2609] 62.21206 62.23208 62.25210 62.27211 62.29213 62.31215 62.33217 62.35218
      [2617] 62.37220 62.39222 62.41224 62.43225 62.45227 62.47229 62.49231 62.51232
      [2625] 62.53234 62.55236 62.57238 62.59240 62.61241 62.63243 62.65245 62.67247
      [2633] 62.69248 62.71250 62.73252 62.75254 62.77255 62.79257 62.81259 62.83261
      [2641] 62.85262 62.87264 62.89266 62.91268 62.93269 62.95271 62.97273 62.99275
      [2649] 63.01276 63.03278 63.05280 63.07282 63.09284 63.11285 63.13287 63.15289
      [2657] 63.17291 63.19292 63.21294 63.23296 63.25298 63.27299 63.29301 63.31303
      [2665] 63.33305 63.35306 63.37308 63.39310 63.41312 63.43313 63.45315 63.47317
      [2673] 63.49319 63.51320 63.53322 63.55324 63.57326 63.59328 63.61329 63.63331
      [2681] 63.65333 63.67335 63.69336 63.71338 63.73340 63.75342 63.77343 63.79345
      [2689] 63.81347 63.83349 63.85350 63.87352 63.89354 63.91356 63.93357 63.95359
      [2697] 63.97361 63.99363 64.01364 64.03366 64.05368 64.07370 64.09372 64.11373
      [2705] 64.13375 64.15377 64.17379 64.19380 64.21382 64.23384 64.25386 64.27387
      [2713] 64.29389 64.31391 64.33393 64.35394 64.37396 64.39398 64.41400 64.43401
      [2721] 64.45403 64.47405 64.49407 64.51408 64.53410 64.55412 64.57414 64.59416
      [2729] 64.61417 64.63419 64.65421 64.67423 64.69424 64.71426 64.73428 64.75430
      [2737] 64.77431 64.79433 64.81435 64.83437 64.85438 64.87440 64.89442 64.91444
      [2745] 64.93445 64.95447 64.97449 64.99451 65.01452 65.03454 65.05456 65.07458
      [2753] 65.09460 65.11461 65.13463 65.15465 65.17467 65.19468 65.21470 65.23472
      [2761] 65.25474 65.27475 65.29477 65.31479 65.33481 65.35482 65.37484 65.39486
      [2769] 65.41488 65.43489 65.45491 65.47493 65.49495 65.51496 65.53498 65.55500
      [2777] 65.57502 65.59504 65.61505 65.63507 65.65509 65.67511 65.69512 65.71514
      [2785] 65.73516 65.75518 65.77519 65.79521 65.81523 65.83525 65.85526 65.87528
      [2793] 65.89530 65.91532 65.93533 65.95535 65.97537 65.99539 66.01540 66.03542
      [2801] 66.05544 66.07546 66.09548 66.11549 66.13551 66.15553 66.17555 66.19556
      [2809] 66.21558 66.23560 66.25562 66.27563 66.29565 66.31567 66.33569 66.35570
      [2817] 66.37572 66.39574 66.41576 66.43577 66.45579 66.47581 66.49583 66.51584
      [2825] 66.53586 66.55588 66.57590 66.59592 66.61593 66.63595 66.65597 66.67599
      [2833] 66.69600 66.71602 66.73604 66.75606 66.77607 66.79609 66.81611 66.83613
      [2841] 66.85614 66.87616 66.89618 66.91620 66.93621 66.95623 66.97625 66.99627
      [2849] 67.01628 67.03630 67.05632 67.07634 67.09636 67.11637 67.13639 67.15641
      [2857] 67.17643 67.19644 67.21646 67.23648 67.25650 67.27651 67.29653 67.31655
      [2865] 67.33657 67.35658 67.37660 67.39662 67.41664 67.43665 67.45667 67.47669
      [2873] 67.49671 67.51672 67.53674 67.55676 67.57678 67.59680 67.61681 67.63683
      [2881] 67.65685 67.67687 67.69688 67.71690 67.73692 67.75694 67.77695 67.79697
      [2889] 67.81699 67.83701 67.85702 67.87704 67.89706 67.91708 67.93709 67.95711
      [2897] 67.97713 67.99715 68.01716 68.03718 68.05720 68.07722 68.09724 68.11725
      [2905] 68.13727 68.15729 68.17731 68.19732 68.21734 68.23736 68.25738 68.27739
      [2913] 68.29741 68.31743 68.33745 68.35746 68.37748 68.39750 68.41752 68.43753
      [2921] 68.45755 68.47757 68.49759 68.51760 68.53762 68.55764 68.57766 68.59768
      [2929] 68.61769 68.63771 68.65773 68.67775 68.69776 68.71778 68.73780 68.75782
      [2937] 68.77783 68.79785 68.81787 68.83789 68.85790 68.87792 68.89794 68.91796
      [2945] 68.93797 68.95799 68.97801 68.99803 69.01804 69.03806 69.05808 69.07810
      [2953] 69.09812 69.11813 69.13815 69.15817 69.17819 69.19820 69.21822 69.23824
      [2961] 69.25826 69.27827 69.29829 69.31831 69.33833 69.35834 69.37836 69.39838
      [2969] 69.41840 69.43841 69.45843 69.47845 69.49847 69.51848 69.53850 69.55852
      [2977] 69.57854 69.59856 69.61857 69.63859 69.65861 69.67863 69.69864 69.71866
      [2985] 69.73868 69.75870 69.77871 69.79873 69.81875
      
      $y
         [1]     0.000000    12.967742     6.935484   201.903226   205.870968
         [6]    50.838710   181.806452   178.774194    60.741935   161.709677
        [11]    20.677419   132.645161   232.612903   147.580645   255.548387
        [16]   121.516129   154.483871    15.451613   146.419355    40.387097
        [21]   258.354839   104.322581   211.290323   284.258065   181.225806
        [26]   145.193548   191.161290   330.129032   212.096774   195.064516
        [31]   131.032258     0.000000   238.050000   276.100000   221.150000
        [36]   252.200000   192.250000   248.300000   178.350000   209.400000
        [41]   210.450000   132.500000   144.550000   266.600000    80.650000
        [46]   187.700000   172.750000   234.800000    98.850000   136.900000
        [51]   222.950000     0.000000   436.996503   205.993007   362.989510
        [56]   269.986014   289.982517   311.979021   296.975524   184.972028
        [61]    87.968531   326.965035   259.961538   299.958042   299.954545
        [66]    74.951049   217.947552   221.944056   293.940559   149.937063
        [71]   172.933566    47.930070   318.926573   101.923077   290.919580
        [76]   328.916084   196.912587   249.909091   331.905594   259.902098
        [81]   264.898601   334.895105   196.891608   315.888112   273.884615
        [86]   221.881119   146.877622   413.874126   222.870629   243.867133
        [91]   478.863636   222.860140   389.856643   156.853147   136.849650
        [96]   294.846154   217.842657   362.839161   191.835664   321.832168
       [101]   255.828671   190.825175   242.821678   250.818182   221.814685
       [106]   193.811189   240.807692   143.804196   146.800699   369.797203
       [111]   382.793706   245.790210   210.786713   291.783217   294.779720
       [116]   343.776224   267.772727   418.769231   211.765734   239.762238
       [121]   376.758741   203.755245   404.751748   282.748252   108.744755
       [126]   256.741259   151.737762   355.734266   281.730769   288.727273
       [131]   193.723776   282.720280   422.716783   312.713287   220.709790
       [136]   289.706294   128.702797   299.699301   282.695804   364.692308
       [141]   338.688811   300.685315   324.681818   383.678322   354.674825
       [146]   395.671329   275.667832   310.664336   231.660839   258.657343
       [151]   416.653846   344.650350   430.646853   412.643357   374.639860
       [156]   428.636364   359.632867   438.629371   366.625874   321.622378
       [161]   267.618881   417.615385   462.611888   241.608392   240.604895
       [166]   502.601399   280.597902   495.594406   280.590909   378.587413
       [171]   329.583916   460.580420   492.576923   566.573427   533.569930
       [176]   794.566434   767.562937   904.559441  1014.555944  1086.552448
       [181]  1013.548951  1106.545455   897.541958  1028.538462   789.534965
       [186]   769.531469   865.527972   832.524476   839.520979   731.517483
       [191]   794.513986   598.510490   629.506993   332.503497   392.500000
       [196]   414.496503   321.493007   382.489510   222.486014   295.482517
       [201]   207.479021   320.475524   377.472028   380.468531   362.465035
       [206]   175.461538   375.458042   480.454545   287.451049   137.447552
       [211]   288.444056   210.440559   164.437063   215.433566   301.430070
       [216]   262.426573   312.423077   256.419580   348.416084   289.412587
       [221]   268.409091   265.405594   323.402098   244.398601   111.395105
       [226]   283.391608   324.388112   137.384615   272.381119   143.377622
       [231]   205.374126   197.370629   190.367133   191.363636   428.360140
       [236]    52.356643   178.353147   299.349650   223.346154   333.342657
       [241]   340.339161   252.335664   257.332168   176.328671   193.325175
       [246]   124.321678   290.318182   323.314685    84.311189   221.307692
       [251]    76.304196   250.300699   216.297203   298.293706   294.290210
       [256]   231.286713   291.283217   301.279720   364.276224   200.272727
       [261]   228.269231   162.265734   149.262238   207.258741   285.255245
       [266]   170.251748   100.248252   211.244755   300.241259   192.237762
       [271]   237.234266   323.230769   186.227273   113.223776   267.220280
       [276]   201.216783   441.213287    85.209790   208.206294   208.202797
       [281]   134.199301   154.195804   204.192308   188.188811   207.185315
       [286]   243.181818   199.178322   238.174825    43.171329   240.167832
       [291]   127.164336   197.160839   223.157343   210.153846   251.150350
       [296]   103.146853   210.143357   242.139860   379.136364   109.132867
       [301]   248.129371   265.125874   267.122378   215.118881   312.115385
       [306]   445.111888   365.108392   625.104895   568.101399   617.097902
       [311]   644.094406   591.090909   462.087413   526.083916   371.080420
       [316]   164.076923   226.073427   169.069930   260.066434   245.062937
       [321]   144.059441   255.055944   285.052448   207.048951   168.045455
       [326]   140.041958   126.038462   325.034965   190.031469   101.027972
       [331]    65.024476   233.020979   221.017483   235.013986   156.010490
       [336]    66.006993    34.003497     0.000000   200.875000    79.750000
       [341]   156.625000   203.500000   195.375000   102.250000   136.125000
       [346]    53.000000   137.875000   245.750000   105.625000   113.500000
       [351]   194.375000   212.250000   145.125000   268.000000   227.875000
       [356]   254.750000   202.625000   164.500000   156.375000   255.250000
       [361]   255.125000   201.000000   121.875000   252.750000   183.625000
       [366]   226.500000   223.375000   290.250000   344.125000   107.000000
       [371]   262.875000   259.750000   248.625000   480.500000   420.375000
       [376]   557.250000   840.125000   859.000000   939.875000   800.750000
       [381]   656.625000   574.500000   427.375000   319.250000   253.125000
       [386]   211.000000   214.875000   252.750000   199.625000   176.500000
       [391]   144.375000    76.250000    51.125000   155.000000   237.875000
       [396]   167.750000   137.625000   122.500000   177.375000   204.250000
       [401]   157.125000   126.000000    25.875000   296.750000   145.625000
       [406]   156.500000   128.375000   153.250000   168.125000   209.000000
       [411]   257.875000   234.750000   338.625000   174.500000   205.375000
       [416]   176.250000   241.125000     0.000000   128.749370   256.498741
       [421]   167.248111   241.997481    48.746851   281.496222   230.245592
       [426]   193.994962   306.744332   269.493703   175.243073   352.992443
       [431]   133.741814   332.491184   193.240554   274.989924   233.739295
       [436]   273.488665   177.238035   272.987406   366.736776   492.486146
       [441]   341.235516   517.984887   689.734257   803.483627   842.232997
       [446]   994.982368  1024.731738   971.481108  1121.230479   816.979849
       [451]   881.729219   696.478589   494.227960   369.977330   234.726700
       [456]   309.476071   310.225441    97.974811   326.724181   276.473552
       [461]   237.222922    69.972292   224.721662   207.471033   286.220403
       [466]   169.969773   117.719144   168.468514    63.217884   234.967254
       [471]   204.716625   253.465995   216.215365   202.964736   214.714106
       [476]   110.463476    63.212846   116.962217   129.711587   357.460957
       [481]   228.210327   376.959698   268.709068   132.458438   256.207809
       [486]   422.957179   339.706549   321.455919   321.205290   272.954660
       [491]   228.704030   477.453401   409.202771   188.952141   154.701511
       [496]   280.450882   265.200252   287.949622   317.698992   308.448363
       [501]   266.197733   332.947103   320.696474   265.445844   273.195214
       [506]   194.944584   198.693955   285.443325   183.192695   214.942065
       [511]   108.691436   205.440806   140.190176    25.939547   124.688917
       [516]   215.438287    32.187657   150.937028   189.686398   224.435768
       [521]   168.185139   327.934509    36.683879   160.433249   155.182620
       [526]   241.931990   168.681360   279.430730   117.180101   218.929471
       [531]   181.678841   188.428212   430.177582   318.926952   586.676322
       [536]   838.425693  1428.175063  2046.924433  2890.673804  4062.423174
       [541]  5307.172544  6879.921914  7497.671285  6255.420655  4519.170025
       [546]  3361.919395  2096.668766   982.418136   882.167506   955.916877
       [551]   760.666247   712.415617   588.164987   447.914358   560.663728
       [556]   284.413098   249.162469   327.911839   221.661209   215.410579
       [561]   351.159950   238.909320   371.658690   241.408060    82.157431
       [566]   328.906801   320.656171   244.405542    85.154912   308.904282
       [571]   275.653652   219.403023   163.152393   279.901763   276.651134
       [576]   325.400504   407.149874   354.899244   414.648615   403.397985
       [581]   328.147355   443.896725   471.646096   437.395466   723.144836
       [586]   770.894207   745.643577   905.392947  1068.142317  1247.891688
       [591]  1494.641058  1807.390428  2135.139798  2675.889169  3200.638539
       [596]  3623.387909  4340.137280  4621.886650  4724.636020  4389.385390
       [601]  3885.134761  3002.884131  2426.633501  2056.382872  1534.132242
       [606]  1246.881612   905.630982   867.380353   874.129723   556.879093
       [611]   601.628463   611.377834   557.127204   685.876574   404.625945
       [616]   439.375315   458.124685   479.874055   578.623426   629.372796
       [621]   509.122166   494.871537   492.620907   400.370277   584.119647
       [626]   628.869018   534.618388   806.367758   613.117128   702.866499
       [631]  1043.615869  1065.365239  1131.114610  1140.863980  1136.613350
       [636]  1081.362720   885.112091   837.861461   784.610831   557.360202
       [641]   602.109572   510.858942   647.608312   474.357683   433.107053
       [646]   553.856423   655.605793   531.355164   458.104534   674.853904
       [651]   594.603275   726.352645   854.102015   739.851385   763.600756
       [656]   707.350126   630.099496   658.848866   456.598237   581.347607
       [661]   518.096977   670.846348   635.595718   416.345088   608.094458
       [666]   599.843829   686.593199   703.342569   732.091940   985.841310
       [671]  1109.590680  1268.340050  1652.089421  1704.838791  1988.588161
       [676]  2282.337531  2669.086902  2777.836272  2890.585642  3074.335013
       [681]  2907.084383  2693.833753  2465.583123  2271.332494  1941.081864
       [686]  2035.831234  1856.580605  1790.329975  1751.079345  1840.828715
       [691]  2079.578086  2134.327456  2177.076826  2161.826196  2305.575567
       [696]  2726.324937  2866.074307  3091.823678  3138.573048  3108.322418
       [701]  2702.071788  2512.821159  1973.570529  1704.319899  1486.069270
       [706]  1210.818640  1036.568010  1057.317380   911.066751   902.816121
       [711]   858.565491   886.314861   860.064232   745.813602   783.562972
       [716]   893.312343   788.061713   922.811083   986.560453  1048.309824
       [721]  1153.059194  1247.808564  1354.557935  1430.307305  1435.056675
       [726]  1538.806045  1516.555416  1450.304786  1317.054156  1244.803526
       [731]  1029.552897   879.302267   977.051637   906.801008   601.550378
       [736]   635.299748   635.049118   515.798489   395.547859   596.297229
       [741]   250.046599   352.795970   216.545340   161.294710   207.044081
       [746]   246.793451   167.542821   325.292191   181.041562   154.790932
       [751]   188.540302   262.289673   230.039043   270.788413   146.537783
       [756]   144.287154   248.036524   225.785894   230.535264   315.284635
       [761]   288.034005   359.783375   280.532746   388.282116   541.031486
       [766]   372.780856   387.530227   617.279597   472.028967   435.778338
       [771]   319.527708   404.277078   378.026448   475.775819   380.525189
       [776]   527.274559   595.023929   665.773300   612.522670   888.272040
       [781]   951.021411  1084.770781  1382.520151  1601.269521  1952.018892
       [786]  1824.768262  2064.517632  2169.267003  2074.016373  1938.765743
       [791]  1816.515113  1548.264484  1585.013854  1186.763224  1289.512594
       [796]  1141.261965  1140.011335  1058.760705  1170.510076  1100.259446
       [801]   949.008816  1034.758186   783.507557   885.256927   946.006297
       [806]   961.755668  1059.505038   994.254408  1033.003778   886.753149
       [811]   981.502519   937.251889  1097.001259  1011.750630  1156.500000
       [816]  1253.249370  1358.998741  1740.748111  1888.497481  2217.246851
       [821]  2695.996222  3253.745592  4347.494962  5305.244332  6647.993703
       [826]  8403.743073 11046.492443 14189.241814 19101.991184 25773.740554
       [831] 32070.489924 32191.239295 25579.988665 20175.738035 17232.487406
       [836] 12220.236776  6723.986146  3670.735516  2372.484887  1900.234257
       [841]  1548.983627  1405.732997  1261.482368  1192.231738  1015.981108
       [846]  1160.730479  1090.479849  1136.229219  1186.978589  1088.727960
       [851]  1269.477330  1311.226700  1221.976071  1375.725441  1299.474811
       [856]  1234.224181  1343.973552  1490.722922  1491.472292  1621.221662
       [861]  1859.971033  2101.720403  2422.469773  2904.219144  3287.968514
       [866]  3662.717884  4078.467254  4466.216625  4598.965995  4501.715365
       [871]  5034.464736  5363.214106  5517.963476  5461.712846  5287.462217
       [876]  5417.211587  5625.960957  5635.710327  5699.459698  5985.209068
       [881]  6382.958438  6647.707809  7467.457179  7715.206549  8439.955919
       [886]  9285.705290 10311.454660 10810.204030 11126.953401 11582.702771
       [891] 11798.452141 12490.201511 12843.950882 13338.700252 13324.449622
       [896] 13777.198992 13391.948363 13097.697733 12027.447103 11259.196474
       [901]  9778.945844  8460.695214  7132.444584  5830.193955  4678.943325
       [906]  4034.692695  3222.442065  2734.191436  2271.940806  1942.690176
       [911]  1787.439547  1737.188917  1758.938287  1908.687657  1727.437028
       [916]  1740.186398  1818.935768  1699.685139  1818.434509  1820.183879
       [921]  1925.933249  1751.682620  1656.431990  1882.181360  1655.930730
       [926]  1477.680101  1522.429471  1238.178841  1013.928212   946.677582
       [931]   660.426952   643.176322   664.925693   590.675063   638.424433
       [936]   623.173804   421.923174   441.672544   598.421914   636.171285
       [941]   573.920655   638.670025   716.419395   705.168766   834.918136
       [946]  1048.667506  1014.416877  1211.166247  1560.915617  1990.664987
       [951]  2090.414358  2460.163728  2706.913098  2853.662469  2641.411839
       [956]  2361.161209  2349.910579  1870.659950  1571.409320  1630.158690
       [961]  1343.908060  1567.657431  1524.406801  1745.156171  2341.905542
       [966]  2988.654912  3851.404282  4677.153652  5075.903023  5371.652393
       [971]  5394.401763  4928.151134  4363.900504  3851.649874  3236.399244
       [976]  2613.148615  2337.897985  2096.647355  2001.396725  1898.146096
       [981]  2004.895466  2159.644836  2396.394207  2454.143577  2872.892947
       [986]  3254.642317  3907.391688  4431.141058  4811.890428  5413.639798
       [991]  5801.389169  5837.138539  5636.887909  5564.637280  5070.386650
       [996]  4571.136020  3968.885390  3561.634761  3002.384131  2512.133501
      [1001]  2057.882872  1922.632242  1837.381612  1600.130982  1424.880353
      [1006]  1535.629723  1662.379093  1791.128463  1806.877834  2078.627204
      [1011]  2297.376574  2596.125945  2836.875315  2940.624685  3093.374055
      [1016]  3341.123426  3292.872796  3211.622166  3018.371537  3026.120907
      [1021]  2863.870277  3007.619647  2637.369018  2411.118388  2331.867758
      [1026]  2111.617128  2012.366499  1881.115869  1837.865239  1549.614610
      [1031]  1435.363980  1678.113350  1636.862720  1663.612091  1775.361461
      [1036]  1963.110831  1910.860202  2094.609572  2357.358942  2563.108312
      [1041]  2921.857683  2770.607053  3001.356423  2971.105793  2912.855164
      [1046]  2617.604534  2552.353904  2428.103275  2280.852645  2154.602015
      [1051]  1994.351385  2078.100756  1978.850126  2199.599496  2066.348866
      [1056]  2304.098237  2576.847607  2932.596977  3494.346348  3786.095718
      [1061]  4606.845088  5760.594458  6857.343829  7987.093199  8864.842569
      [1066]  9390.591940  9388.341310  9212.090680  8293.840050  7321.589421
      [1071]  6256.338791  5407.088161  4354.837531  3359.586902  2942.336272
      [1076]  2230.085642  2002.835013  1929.584383  1656.333753  1381.083123
      [1081]  1269.832494  1091.581864  1039.331234   915.080605   864.829975
      [1086]   752.579345   771.328715   737.078086   669.827456   811.576826
      [1091]   785.326196   794.075567   833.824937  1088.574307   940.323678
      [1096]   885.073048   854.822418   838.571788   959.321159   877.070529
      [1101]   952.819899   808.569270   619.318640   615.068010   673.817380
      [1106]   550.566751   692.316121   703.065491   415.814861   425.564232
      [1111]   460.313602   594.062972   408.812343   552.561713   463.311083
      [1116]   493.060453   528.809824   526.559194   392.308564   435.057935
      [1121]   258.807305   378.556675   475.306045   431.055416   465.804786
      [1126]   456.554156   454.303526   502.052897   684.802267   848.551637
      [1131]   642.301008   663.050378   789.799748   645.549118   646.298489
      [1136]   559.047859   571.797229   555.546599   560.295970   501.045340
      [1141]   427.794710   359.544081   237.293451   565.042821   515.792191
      [1146]   395.541562   402.290932   388.040302   314.789673   476.539043
      [1151]   570.288413   488.037783   685.787154   630.536524   737.285894
      [1156]   695.035264   774.784635   647.534005   665.283375   545.032746
      [1161]   565.782116   501.531486   421.280856   481.030227   320.779597
      [1166]   354.528967   374.278338   232.027708   306.777078   356.526448
      [1171]   352.275819   325.025189   214.774559   201.523929   339.273300
      [1176]   289.022670   344.772040   364.521411   293.270781   365.020151
      [1181]   437.769521   674.518892   543.268262   602.017632   629.767003
      [1186]   683.516373   681.265743   568.015113   655.764484   585.513854
      [1191]   533.263224   419.012594   253.761965   313.511335   273.260705
      [1196]   157.010076   121.759446    71.508816   138.258186   116.007557
      [1201]    73.756927    97.506297   150.255668    65.005038   125.754408
      [1206]    96.503778   116.253149    67.002519    18.751889    65.501259
      [1211]   200.250630     0.000000   159.327014    48.654028   101.981043
      [1216]   106.308057   201.635071   168.962085   104.289100   141.616114
      [1221]   187.943128   215.270142   107.597156   236.924171   236.251185
      [1226]   229.578199   363.905213   241.232227   375.559242   288.886256
      [1231]   349.213270   404.540284   417.867299   511.194313   570.521327
      [1236]   490.848341   581.175355   741.502370   848.829384  1073.156398
      [1241]  1090.483412  1201.810427  1141.137441  1232.464455  1478.791469
      [1246]  1430.118483  1442.445498  1708.772512  1544.099526  1629.426540
      [1251]  1792.753555  1782.080569  1731.407583  1825.734597  1780.061611
      [1256]  1878.388626  1953.715640  2062.042654  2196.369668  2376.696682
      [1261]  2330.023697  2553.350711  2870.677725  2879.004739  2977.331754
      [1266]  3148.658768  2995.985782  3005.312796  3023.639810  3216.966825
      [1271]  3088.293839  3238.620853  3064.947867  3216.274882  3292.601896
      [1276]  3428.928910  3592.255924  3786.582938  3901.909953  4187.236967
      [1281]  4228.563981  4401.890995  4195.218009  4260.545024  4005.872038
      [1286]  3749.199052  3528.526066  3407.853081  3120.180095  2993.507109
      [1291]  2638.834123  2371.161137  2235.488152  2053.815166  1762.142180
      [1296]  1697.469194  1662.796209  1452.123223  1563.450237  1445.777251
      [1301]  1489.104265  1376.431280  1340.758294  1249.085308  1308.412322
      [1306]  1308.739336  1103.066351  1232.393365  1081.720379  1142.047393
      [1311]  1096.374408  1075.701422  1070.028436  1214.355450  1110.682464
      [1316]  1267.009479  1276.336493  1390.663507  1399.990521  1637.317536
      [1321]  1732.644550  1905.971564  2357.298578  2528.625592  2838.952607
      [1326]  3218.279621  3035.606635  2816.933649  2756.260664  2840.587678
      [1331]  2789.914692  2606.241706  2528.568720  2386.895735  2295.222749
      [1336]  2305.549763  2167.876777  2069.203791  1958.530806  1828.857820
      [1341]  1820.184834  1522.511848  1544.838863  1344.165877  1289.492891
      [1346]  1174.819905  1088.146919   947.473934   901.800948   858.127962
      [1351]   826.454976   784.781991   700.109005   475.436019   528.763033
      [1356]   659.090047   550.417062   627.744076   592.071090   528.398104
      [1361]   710.725118   843.052133   779.379147   828.706161   955.033175
      [1366]   963.360190  1091.687204  1063.014218  1306.341232  1290.668246
      [1371]  1363.995261  1370.322275  1350.649289  1290.976303  1216.303318
      [1376]  1181.630332   959.957346   787.284360   804.611374   740.938389
      [1381]   652.265403   527.592417   378.919431   346.246445   343.573460
      [1386]   335.900474   171.227488   201.554502   159.881517   233.208531
      [1391]   165.535545   129.862559   165.189573    97.516588   129.843602
      [1396]   160.170616   185.497630    86.824645   125.151659   199.478673
      [1401]   207.805687    69.132701   178.459716   259.786730   281.113744
      [1406]   162.440758   135.767773   126.094787   251.421801   136.748815
      [1411]   183.075829   112.402844   149.729858    70.056872    45.383886
      [1416]    73.710900   100.037915   127.364929    66.691943   162.018957
      [1421]    64.345972    99.672986     0.000000    78.752988   103.505976
      [1426]   210.258964   161.011952    40.764940    97.517928    89.270916
      [1431]   120.023904   129.776892   279.529880   177.282869   241.035857
      [1436]   307.788845   376.541833   214.294821   308.047809   392.800797
      [1441]   415.553785   493.306773   507.059761   515.812749   363.565737
      [1446]   599.318725   544.071713   555.824701   565.577689   653.330677
      [1451]   754.083665   815.836653   781.589641   934.342629  1016.095618
      [1456]  1041.848606  1234.601594  1267.354582  1366.107570  1319.860558
      [1461]  1276.613546  1481.366534  1405.119522  1450.872510  1591.625498
      [1466]  1597.378486  1620.131474  1703.884462  2020.637450  2271.390438
      [1471]  2523.143426  2924.896414  3014.649402  2274.402390  1856.155378
      [1476]  1585.908367  1624.661355  1469.414343  1246.167331   785.920319
      [1481]   587.673307   441.426295   634.179283   427.932271   460.685259
      [1486]   300.438247   413.191235   304.944223   316.697211   353.450199
      [1491]   363.203187   404.956175   282.709163   281.462151   279.215139
      [1496]   159.968127   329.721116   213.474104   186.227092   249.980080
      [1501]    88.733068   207.486056   171.239044   117.992032   284.745020
      [1506]   425.498008   273.250996   431.003984   608.756972   483.509960
      [1511]   637.262948   874.015936  1076.768924  1252.521912   965.274900
      [1516]   931.027888   791.780876   974.533865   837.286853   902.039841
      [1521]   722.792829   692.545817   632.298805   606.051793   605.804781
      [1526]   675.557769   628.310757   507.063745   554.816733   577.569721
      [1531]   548.322709   473.075697   543.828685   450.581673   415.334661
      [1536]   468.087649   345.840637   444.593625   481.346614   457.099602
      [1541]   384.852590   576.605578   618.358566   639.111554   575.864542
      [1546]   568.617530   555.370518   401.123506   536.876494   424.629482
      [1551]   375.382470   299.135458   265.888446   177.641434   299.394422
      [1556]   114.147410   280.900398   180.653386   164.406375    97.159363
      [1561]   133.912351   184.665339   110.418327   225.171315   167.924303
      [1566]    96.677291    90.430279   159.183267   111.936255   263.689243
      [1571]   119.442231   153.195219   178.948207   205.701195   126.454183
      [1576]   186.207171   190.960159   239.713147   239.466135   273.219124
      [1581]   364.972112   461.725100   316.478088   450.231076   349.984064
      [1586]   427.737052   549.490040   587.243028   594.996016   646.749004
      [1591]   618.501992   763.254980   682.007968   684.760956   683.513944
      [1596]   689.266932   689.019920   748.772908   852.525896   893.278884
      [1601]   830.031873  1007.784861  1025.537849  1044.290837  1309.043825
      [1606]  1415.796813  1330.549801  1567.302789  1746.055777  1595.808765
      [1611]  1796.561753  1498.314741  1659.067729  1825.820717  1758.573705
      [1616]  1779.326693  1882.079681  1821.832669  1936.585657  2171.338645
      [1621]  2121.091633  1960.844622  1808.597610  1556.350598  1400.103586
      [1626]  1357.856574  1238.609562  1141.362550   975.115538   876.868526
      [1631]   719.621514   614.374502   623.127490   581.880478   602.633466
      [1636]   641.386454   581.139442   641.892430   521.645418   493.398406
      [1641]   585.151394   607.904382   632.657371   602.410359   660.163347
      [1646]   725.916335   562.669323   614.422311   665.175299   595.928287
      [1651]   658.681275   635.434263   634.187251   595.940239   584.693227
      [1656]   723.446215   694.199203   756.952191   858.705179   865.458167
      [1661]   826.211155   681.964143   732.717131   544.470120   568.223108
      [1666]   509.976096   442.729084   350.482072   188.235060   159.988048
      [1671]   309.741036   115.494024   129.247012     0.000000    98.666667
      [1676]    24.333333   112.000000   101.666667   105.333333    44.000000
      [1681]    83.666667     7.333333    32.000000   186.666667   124.333333
      [1686]   176.000000    71.666667   175.333333    91.000000    63.666667
      [1691]   127.333333    65.000000    15.666667    54.333333     0.000000
      [1696]   116.620482   134.240964    60.861446    55.481928   151.102410
      [1701]   133.722892   257.343373   255.963855   218.584337   188.204819
      [1706]   291.825301   288.445783   320.066265   423.686747   342.307229
      [1711]   396.927711   496.548193   686.168675   711.789157   771.409639
      [1716]   992.030120  1051.650602  1175.271084  1213.891566  1337.512048
      [1721]  1290.132530  1368.753012  1316.373494  1385.993976  1266.614458
      [1726]  1304.234940  1228.855422  1246.475904  1135.096386  1205.716867
      [1731]  1228.337349  1372.957831  1151.578313  1284.198795  1310.819277
      [1736]  1315.439759  1351.060241  1291.680723  1439.301205  1211.921687
      [1741]  1221.542169  1358.162651  1085.783133  1184.403614  1150.024096
      [1746]  1043.644578   967.265060   808.885542   847.506024   850.126506
      [1751]   699.746988   706.367470   552.987952   568.608434   525.228916
      [1756]   412.849398   330.469880   455.090361   273.710843   283.331325
      [1761]   226.951807   255.572289   171.192771   244.813253   146.433735
      [1766]   213.054217   233.674699   149.295181   165.915663   150.536145
      [1771]   187.156627   154.777108   241.397590   333.018072   280.638554
      [1776]   279.259036   269.879518   343.500000   376.120482   271.740964
      [1781]   477.361446   394.981928   459.602410   543.222892   626.843373
      [1786]   723.463855   793.084337   891.704819   888.325301   752.945783
      [1791]   582.566265   767.186747   716.807229   699.427711   728.048193
      [1796]   656.668675   697.289157   441.909639   556.530120   506.150602
      [1801]   425.771084   460.391566   343.012048   331.632530   341.253012
      [1806]   245.873494   304.493976   257.114458    92.734940    38.355422
      [1811]   171.975904   175.596386   137.216867   159.837349   225.457831
      [1816]   107.078313   134.698795    79.319277   217.939759   114.560241
      [1821]    37.180723   102.801205   194.421687   178.042169   140.662651
      [1826]    64.283133   158.903614   181.524096   158.144578   185.765060
      [1831]   149.385542   255.006024   228.626506   249.246988   290.867470
      [1836]   264.487952   442.108434   385.728916   428.349398   525.969880
      [1841]   514.590361   546.210843   600.831325   613.451807   681.072289
      [1846]   736.692771   839.313253   882.933735   906.554217   884.174699
      [1851]   947.795181   903.415663   876.036145   936.656627   873.277108
      [1856]   877.897590   901.518072   788.138554   804.759036   695.379518
      [1861]   665.000000   692.620482   624.240964   616.861446   559.481928
      [1866]   568.102410   595.722892   700.343373   673.963855   763.584337
      [1871]   665.204819   718.825301   720.445783   880.066265   703.686747
      [1876]   649.307229   675.927711   498.548193   491.168675   353.789157
      [1881]   506.409639   449.030120   338.650602   346.271084   272.891566
      [1886]   285.512048    81.132530   206.753012    43.373494   160.993976
      [1891]   110.614458   114.234940   153.855422   235.475904   239.096386
      [1896]   228.716867   264.337349   245.957831   316.578313   314.198795
      [1901]   173.819277   312.439759   314.060241   357.680723   398.301205
      [1906]   294.921687   267.542169   404.162651   400.783133   534.403614
      [1911]   475.024096   637.644578   569.265060   513.885542   462.506024
      [1916]   479.126506   521.746988   558.367470   650.987952   779.608434
      [1921]   808.228916   850.849398   876.469880  1032.090361   930.710843
      [1926]  1040.331325   977.951807   893.572289   741.192771   838.813253
      [1931]   730.433735   727.054217   651.674699   506.295181   536.915663
      [1936]   538.536145   476.156627   560.777108   500.397590   379.018072
      [1941]   517.638554   605.259036   587.879518   545.500000   504.120482
      [1946]   590.740964   595.361446   544.981928   631.602410   493.222892
      [1951]   512.843373   686.463855   795.084337   707.704819   729.325301
      [1956]   804.945783   872.566265   975.186747   932.807229  1031.427711
      [1961]  1005.048193  1042.668675  1132.289157  1118.909639  1285.530120
      [1966]  1255.150602  1282.771084  1307.391566  1361.012048  1413.632530
      [1971]  1427.253012  1314.873494  1336.493976  1319.114458  1287.734940
      [1976]  1189.355422  1077.975904  1173.596386  1113.216867  1078.837349
      [1981]   921.457831   892.078313   775.698795   798.319277   856.939759
      [1986]   909.560241   792.180723   834.801205   790.421687   949.042169
      [1991]   966.662651  1084.283133  1071.903614  1082.524096  1082.144578
      [1996]  1393.765060  1355.385542  1611.006024  1822.626506  1770.246988
      [2001]  2237.867470  2539.487952  2940.108434  3596.728916  3838.349398
      [2006]  3723.969880  3134.590361  2478.210843  2188.831325  2121.451807
      [2011]  2194.072289  2152.692771  1845.313253  1492.933735  1160.554217
      [2016]   923.174699   696.795181   760.415663   594.036145   602.656627
      [2021]   618.277108   562.897590   628.518072   656.138554   670.759036
      [2026]   746.379518   825.000000   829.620482   799.240964   831.861446
      [2031]   811.481928   735.102410   731.722892   702.343373   713.963855
      [2036]   580.584337   612.204819   434.825301   596.445783   507.066265
      [2041]   545.686747   398.307229   390.927711   380.548193   365.168675
      [2046]   397.789157   320.409639   416.030120   384.650602   395.271084
      [2051]   432.891566   395.512048   369.132530   339.753012   416.373494
      [2056]   397.993976   436.614458   387.234940   510.855422   555.475904
      [2061]   422.096386   469.716867   500.337349   663.957831   627.578313
      [2066]   569.198795   797.819277   801.439759   719.060241   808.680723
      [2071]   820.301205   814.921687   930.542169  1121.162651  1025.783133
      [2076]  1211.403614  1220.024096  1403.644578  1392.265060  1534.885542
      [2081]  1447.506024  1406.126506  1578.746988  1460.367470  1462.987952
      [2086]  1304.608434  1323.228916  1455.849398  1433.469880  1338.090361
      [2091]  1489.710843  1348.331325  1512.951807  1433.572289  1721.192771
      [2096]  1804.813253  2018.433735  2079.054217  2289.674699  2357.295181
      [2101]  2233.915663  2465.536145  2282.156627  2153.777108  2072.397590
      [2106]  1754.018072  1786.638554  1745.259036  1634.879518  1435.500000
      [2111]  1386.120482  1227.740964  1209.361446   997.981928   811.602410
      [2116]   839.222892   860.843373   696.463855   719.084337   665.704819
      [2121]   547.325301   658.945783   563.566265   621.186747   577.807229
      [2126]   575.427711   476.048193   589.668675   562.289157   536.909639
      [2131]   610.530120   524.150602   465.771084   636.391566   621.012048
      [2136]   676.632530   660.253012   690.873494   563.493976   711.114458
      [2141]   780.734940   764.355422   778.975904   830.596386   679.216867
      [2146]   742.837349   664.457831   666.078313   726.698795   713.319277
      [2151]   683.939759   692.560241   734.180723   643.801205   647.421687
      [2156]   792.042169   625.662651   741.283133   710.903614   653.524096
      [2161]   714.144578   716.765060   595.385542   692.006024   623.626506
      [2166]   635.246988   618.867470   671.487952   570.108434   508.728916
      [2171]   596.349398   433.969880   511.590361   551.210843   521.831325
      [2176]   498.451807   357.072289   507.692771   473.313253   397.933735
      [2181]   203.554217   356.174699   248.795181   298.415663   247.036145
      [2186]   277.656627   182.277108   246.897590   161.518072   259.138554
      [2191]   284.759036   136.379518     0.000000   166.263158   134.526316
      [2196]   237.789474   157.052632   179.315789   195.578947   240.842105
      [2201]   222.105263    96.368421   113.631579   146.894737   279.157895
      [2206]   261.421053   195.684211   125.947368   235.210526   255.473684
      [2211]   300.736842   259.000000   280.263158   423.526316   304.789474
      [2216]   330.052632   403.315789   349.578947   376.842105   242.105263
      [2221]   334.368421   457.631579   444.894737   483.157895   362.421053
      [2226]   466.684211   404.947368   519.210526   517.473684   475.736842
      [2231]   465.000000   470.263158   568.526316   490.789474   624.052632
      [2236]   651.315789   637.578947   787.842105   955.105263   999.368421
      [2241]  1187.631579  1091.894737  1169.157895  1009.421053   798.684211
      [2246]   777.947368   706.210526   892.473684   732.736842   739.000000
      [2251]   638.263158   570.526316   516.789474   402.052632   391.315789
      [2256]   400.578947   477.842105   348.105263   317.368421   390.631579
      [2261]   316.894737   389.157895   489.421053   527.684211   490.947368
      [2266]   531.210526   424.473684   338.736842   293.000000   373.263158
      [2271]   240.526316   319.789474   279.052632   271.315789   275.578947
      [2276]   173.842105   173.105263    98.368421    80.631579   184.894737
      [2281]   252.157895   168.421053   121.684211   106.947368   178.210526
      [2286]   127.473684    95.736842     0.000000   108.927326   156.854651
      [2291]   107.781977   137.709302   172.636628   183.563953   282.491279
      [2296]   267.418605   224.345930   257.273256   241.200581   210.127907
      [2301]   315.055233   434.982558   380.909884   296.837209   444.764535
      [2306]   581.691860   525.619186   506.546512   538.473837   641.401163
      [2311]   791.328488   855.255814   719.183140   967.110465   844.037791
      [2316]   915.965116   867.892442   949.819767   889.747093   950.674419
      [2321]   932.601744   930.529070   817.456395   844.383721   957.311047
      [2326]   861.238372   771.165698   839.093023   767.020349   875.947674
      [2331]   993.875000   813.802326   803.729651   821.656977   788.584302
      [2336]   747.511628   793.438953   815.366279   789.293605   800.220930
      [2341]   609.148256   623.075581   715.002907   525.930233   608.857558
      [2346]   548.784884   559.712209   573.639535   514.566860   570.494186
      [2351]   499.421512   568.348837   535.276163   444.203488   572.130814
      [2356]   516.058140   355.985465   464.912791   376.840116   449.767442
      [2361]   516.694767   501.622093   475.549419   526.476744   436.404070
      [2366]   437.331395   463.258721   496.186047   418.113372   425.040698
      [2371]   375.968023   494.895349   508.822674   498.750000   337.677326
      [2376]   415.604651   384.531977   247.459302   448.386628   330.313953
      [2381]   228.241279   165.168605   287.095930   190.023256   293.950581
      [2386]   245.877907   255.805233   127.732558   150.659884   259.587209
      [2391]   149.514535   246.441860   179.369186   120.296512   244.223837
      [2396]   265.151163   129.078488   227.005814   183.933140   197.860465
      [2401]   217.787791   159.715116   150.642442   185.569767   132.497093
      [2406]   207.424419   165.351744   225.279070    88.206395   118.133721
      [2411]   169.061047    81.988372    55.915698    88.843023   137.770349
      [2416]   160.697674   148.625000   104.552326   182.479651   154.406977
      [2421]    85.334302   176.261628   107.188953   198.116279   112.043605
      [2426]   169.970930   142.898256   199.825581   151.752907   202.680233
      [2431]   144.607558   263.534884   239.462209   276.389535   258.316860
      [2436]   286.244186   280.171512   367.098837   397.026163   333.953488
      [2441]   374.880814   394.808140   320.735465   456.662791   371.590116
      [2446]   414.517442   517.444767   538.372093   586.299419   546.226744
      [2451]   568.154070   509.081395   497.008721   528.936047   680.863372
      [2456]   511.790698   606.718023   532.645349   587.572674   541.500000
      [2461]   491.427326   429.354651   447.281977   499.209302   345.136628
      [2466]   467.063953   414.991279   472.918605   447.845930   451.773256
      [2471]   387.700581   381.627907   324.555233   391.482558   504.409884
      [2476]   395.337209   572.264535   387.191860   411.119186   440.046512
      [2481]   423.973837   680.901163   515.828488   662.755814   776.683140
      [2486]   860.610465   859.537791   916.465116  1059.392442  1169.319767
      [2491]  1197.247093  1288.174419  1527.101744  1847.029070  1926.956395
      [2496]  2001.883721  1997.811047  1591.738372  1373.665698  1301.593023
      [2501]  1294.520349  1172.447674  1214.375000  1225.302326  1086.229651
      [2506]  1088.156977   770.084302   545.011628   545.938953   495.866279
      [2511]   431.793605   497.720930   390.648256   550.575581   504.502907
      [2516]   509.430233   377.357558   439.284884   498.212209   427.139535
      [2521]   470.066860   449.994186   354.921512   415.848837   467.776163
      [2526]   538.703488   436.630814   289.558140   562.485465   425.412791
      [2531]   505.340116   606.267442   543.194767   540.122093   631.049419
      [2536]   547.976744   535.904070   633.831395   543.758721   583.686047
      [2541]   523.613372   501.540698   630.468023   548.395349   564.322674
      [2546]   564.250000   591.177326   565.104651   460.031977   523.959302
      [2551]   521.886628   538.813953   621.741279   682.668605   629.595930
      [2556]   748.523256   770.450581   869.377907   875.305233   881.232558
      [2561]   995.159884   989.087209   915.014535   970.941860   931.869186
      [2566]   870.796512   981.723837  1030.651163  1026.578488   901.505814
      [2571]   844.433140   751.360465   724.287791   752.215116   663.142442
      [2576]   571.069767   634.997093   601.924419   524.851744   564.779070
      [2581]   489.706395   549.633721   478.561047   437.488372   400.415698
      [2586]   386.343023   389.270349   398.197674   350.125000   441.052326
      [2591]   308.979651   419.906977   403.834302   357.761628   418.688953
      [2596]   427.616279   490.543605   463.470930   447.398256   466.325581
      [2601]   514.252907   492.180233   610.107558   586.034884   480.962209
      [2606]   588.889535   687.816860   598.744186   533.671512   490.598837
      [2611]   465.526163   495.453488   531.380814   645.308140   486.235465
      [2616]   510.162791   616.090116   488.017442   614.944767   582.872093
      [2621]   559.799419   484.726744   464.654070   498.581395   641.508721
      [2626]   435.436047   486.363372   582.290698   544.218023   485.145349
      [2631]   530.072674   554.000000   604.927326   498.854651   503.781977
      [2636]   460.709302   480.636628   550.563953   522.491279   562.418605
      [2641]   593.345930   522.273256   561.200581   495.127907   580.055233
      [2646]   625.982558   484.909884   535.837209   563.764535   540.691860
      [2651]   558.619186   442.546512   494.473837   302.401163   432.328488
      [2656]   382.255814   434.183140   390.110465   435.037791   306.965116
      [2661]   374.892442   483.819767   385.747093   303.674419   298.601744
      [2666]   308.529070   327.456395   209.383721   237.311047   253.238372
      [2671]   333.165698   181.093023   213.020349   276.947674   212.875000
      [2676]   216.802326   283.729651   312.656977   257.584302   200.511628
      [2681]   170.438953   160.366279   200.293605   265.220930   299.148256
      [2686]   258.075581   358.002907   391.930233   344.857558   385.784884
      [2691]   276.712209   384.639535   459.566860   435.494186   381.421512
      [2696]   559.348837   564.276163   574.203488   571.130814   518.058140
      [2701]   487.985465   517.912791   526.840116   350.767442   508.694767
      [2706]   367.622093   466.549419   457.476744   363.404070   425.331395
      [2711]   399.258721   235.186047   296.113372   367.040698   365.968023
      [2716]   287.895349   370.822674   261.750000   278.677326   222.604651
      [2721]   302.531977   275.459302   314.386628   358.313953   292.241279
      [2726]   365.168605   335.095930   246.023256   345.950581   306.877907
      [2731]   333.805233   359.732558   595.659884   587.587209   513.514535
      [2736]   542.441860   520.369186   640.296512   550.223837   600.151163
      [2741]   676.078488   681.005814   703.933140   710.860465   725.787791
      [2746]   789.715116   769.642442   789.569767   856.497093   633.424419
      [2751]   732.351744   815.279070   755.206395   769.133721   698.061047
      [2756]   644.988372   631.915698   653.843023   756.770349   587.697674
      [2761]   571.625000   585.552326   616.479651   639.406977   574.334302
      [2766]   508.261628   657.188953   602.116279   488.043605   551.970930
      [2771]   594.898256   708.825581   512.752907   601.680233   609.607558
      [2776]   601.534884   489.462209   665.389535   648.316860   677.244186
      [2781]   573.171512   601.098837   600.026163   683.953488   602.880814
      [2786]   624.808140   481.735465   564.662791   546.590116   553.517442
      [2791]   518.444767   505.372093   553.299419   407.226744   479.154070
      [2796]   420.081395   400.008721   528.936047   409.863372   383.790698
      [2801]   431.718023   352.645349   479.572674   419.500000   475.427326
      [2806]   417.354651   428.281977   392.209302   451.136628   533.063953
      [2811]   518.991279   447.918605   468.845930   437.773256   398.700581
      [2816]   479.627907   400.555233   326.482558   355.409884   354.337209
      [2821]   283.264535   281.191860   291.119186   324.046512   358.973837
      [2826]   206.901163   319.828488   261.755814   144.683140   189.610465
      [2831]   191.537791   153.465116   184.392442   102.319767   195.247093
      [2836]   196.174419   152.101744   150.029070    73.956395   147.883721
      [2841]   169.811047   104.738372   139.665698    81.593023   192.520349
      [2846]   246.447674   199.375000   127.302326   159.229651   188.156977
      [2851]   211.084302   198.011628   327.938953   227.866279   273.793605
      [2856]   310.720930   314.648256   245.575581   252.502907   331.430233
      [2861]   336.357558   296.284884   343.212209   378.139535   440.066860
      [2866]   517.994186   440.921512   582.848837   476.776163   569.703488
      [2871]   591.630814   547.558140   678.485465   753.412791   824.340116
      [2876]   766.267442   819.194767   895.122093  1002.049419  1002.976744
      [2881]  1093.904070  1215.831395  1375.758721  1371.686047  1549.613372
      [2886]  1526.540698  1350.468023  1147.395349  1185.322674  1115.250000
      [2891]  1050.177326  1139.104651  1213.031977  1201.959302  1213.886628
      [2896]  1234.813953  1188.741279  1131.668605  1200.595930  1181.523256
      [2901]  1386.450581  1351.377907  1488.305233  1465.232558  1477.159884
      [2906]  1529.087209  1421.014535  1341.941860  1303.869186  1322.796512
      [2911]  1406.723837  1498.651163  1589.578488  1418.505814  1436.433140
      [2916]  1287.360465  1065.287791  1015.215116   910.142442   867.069767
      [2921]   868.997093   826.924419   734.851744   573.779070   673.706395
      [2926]   590.633721   497.561047   461.488372   496.415698   349.343023
      [2931]   504.270349   444.197674   457.125000   361.052326   458.979651
      [2936]   341.906977   312.834302   317.761628   387.688953   487.616279
      [2941]   536.543605   282.470930   436.398256   444.325581   417.252907
      [2946]   341.180233   365.107558   450.034884   348.962209   362.889535
      [2951]   342.816860   320.744186   311.671512   339.598837   328.526163
      [2956]   259.453488   278.380814   215.308140   153.235465   204.162791
      [2961]   152.090116   193.017442   163.944767    94.872093    99.799419
      [2966]    49.726744    89.654070   152.581395   123.508721   141.436047
      [2971]   120.363372    51.290698    12.218023   133.145349    56.072674
      [2976]     0.000000    85.692308    78.384615    47.076923    30.769231
      [2981]   162.461538   100.153846   160.846154    17.538462    43.230769
      [2986]    63.923077    38.615385    81.307692     0.000000
      
      attr(,"method")
      [1] "rubberband"

