% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install.R
\name{install_models}
\alias{install_models}
\title{Install allometric models from the models repository}
\usage{
install_models(redownload = FALSE, ignore_cache = FALSE, verbose = TRUE)
}
\arguments{
\item{redownload}{If \code{TRUE}, models are re-downloaded from the remote
repository.}

\item{ignore_cache}{If \code{TRUE}, models are re-installed regardless of their
installation timestamp. Otherwise, only newly modified model files are reran.
This is primarily for development purposes.}

\item{verbose}{If \code{TRUE}, print verbose messages as models are installed.}
}
\value{
No return value, installs models into the package directory.
}
\description{
Allometric models are stored in a remote repository located on GitHub located
\href{https://github.com/allometric/models}{here}. The user must install
these models themselves using this function. This function clones the models
repository within the allometric package directory and constructs a local
dataframe containing the models. This dataframe is stored in the global
environment variable \code{allometric_models} upon completion of the function.
Refer to \code{allometric::allometric_models} for further information.
}
