% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split.R
\name{cleanse.split_df}
\alias{cleanse.split_df}
\title{Cleansing the dataset for classification modeling}
\usage{
\method{cleanse}{split_df}(.data, add_character = FALSE, uniq_thres = 0.9, missing = FALSE, ...)
}
\arguments{
\item{.data}{an object of class "split_df", usually, a result of a call to split_df().}

\item{add_character}{logical. Decide whether to include text variables in the
compare of categorical data. The default value is FALSE, which also not includes character variables.}

\item{uniq_thres}{numeric. Set a threshold to removing variables when the ratio of unique values(number of unique values / number of observation) is greater than the set value.}

\item{missing}{logical. Set whether to removing variables including missing value}

\item{...}{further arguments passed to or from other methods.}
}
\value{
An object of class "split_df".
}
\description{
Diagnosis of similarity between datasets splitted by train set and set included in the "split_df" class. and cleansing the "split_df" class
}
\details{
Remove the detected variables from the diagnosis using the compare_diag() function.
}
\examples{
library(dplyr)

# Credit Card Default Data
head(ISLR::Default)

# Generate data for the example
sb <- ISLR::Default \%>\%
  split_by(default)

sb \%>\%
  cleanse

}
