% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amapro.R
\name{am.init}
\alias{am.init}
\title{Map Initialization}
\usage{
am.init(..., width = NULL, height = NULL)
}
\arguments{
\item{...}{attributes of map, see \href{https://lbs.amap.com/api/jsapi-v2/documentation#map}{here}.\cr
Additional attribute \emph{loca}(boolean) is to add a Loca.Container to the map.}

\item{width, height}{A valid CSS unit (like \code{'100\%'})}
}
\value{
A widget to plot, or to store and expand with more features
}
\description{
First command to build a map
}
\details{
Command \emph{am.init} creates a widget with \code{\link[htmlwidgets]{createWidget}}, then adds features to it.\cr
On first use, \emph{am.init} prompts for AMap API key. There is a temporary \emph{demo} mode when key is unavailable.
}
\examples{
if (interactive()) {
  ctr <- c(22.430151, 37.073011)
  tu <- paste0('http://server.arcgisonline.com/ArcGIS/rest/services/World_Imagery/',
                   'MapServer/tile/[z]/[y]/[x]')
  am.init( center= ctr, zoom= 10, pitch= 60, viewMode= '3D') |>
  am.control(ctype= 'ControlBar', position= 'RT') |>
  am.item('TileLayer', tileUrl= tu) |>
  am.item('Marker', position= ctr,
      icon= 'https://upload.wikimedia.org/wikipedia/commons/9/9d/Ancient_Greek_helmet.png'
  ) |>
  am.cmd('set', 'InfoWindow', name='iwin', content='This is Sparta') |>
  am.cmd('open', 'iwin', 'm$jmap', ctr)   # m$jmap is the map name in JavaScript
}

}
