% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amber.case-reports.R
\name{amber.case_report_forms}
\alias{amber.case_report_forms}
\title{Get the case report forms}
\usage{
amber.case_report_forms(
  amber,
  study = NULL,
  form = NULL,
  revision = NULL,
  query = list(),
  skip = 0,
  limit = 100,
  df = TRUE
)
}
\arguments{
\item{amber}{An Amber object}

\item{study}{Study identifier (name or id), optional.}

\item{form}{Form identifier (name or id), optional.}

\item{revision}{Revision number, optional, default is NULL (means that the
case report form uses the latest form revision).}

\item{query}{The search query}

\item{skip}{Number of items to skip}

\item{limit}{Max number of items}

\item{df}{Return a data.frame (default is TRUE)}
}
\value{
A data.frame (or a named list of raw results when 'df' is FALSE)
}
\description{
Get the case reports of one or several form(s).
}
\examples{
\dontrun{
a <- amber.login("https://amber-demo.obiba.org")
amber.case_report_forms(a, form="61e69a22fea2df2f3108b508", skip=0, limit=10)
amber.case_report_forms(a, form="Adult trauma")
amber.case_report_forms(a, study="Trauma Registry", query = list(revision = 1))
amber.case_report_forms(a, query = list(revision = 1))
amber.logout(a)
}
}
\seealso{
Other studies functions: 
\code{\link{amber.campaign}()},
\code{\link{amber.campaigns}()},
\code{\link{amber.case_report_export}()},
\code{\link{amber.case_report_form}()},
\code{\link{amber.case_reports}()},
\code{\link{amber.form}()},
\code{\link{amber.form_revision}()},
\code{\link{amber.form_revisions}()},
\code{\link{amber.forms}()},
\code{\link{amber.interview_design}()},
\code{\link{amber.interview_designs}()},
\code{\link{amber.interview_export}()},
\code{\link{amber.interviews}()},
\code{\link{amber.participant}()},
\code{\link{amber.participants}()},
\code{\link{amber.studies}()},
\code{\link{amber.study}()}
}
\concept{studies functions}
