% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/el2sm.R
\name{el2sm}
\alias{el2sm}
\title{Edgelist to sociomatrix}
\usage{
el2sm(el,directed=TRUE,nadiag=all(el[,1]!=el[,2]))
}
\arguments{
\item{el}{a matrix in which each row contains the indices of an edge and possibly the weight for the edge}

\item{directed}{if FALSE, then a relation is placed in both entry ij and ji of the sociomatrix, for each edge ij (or ji)}

\item{nadiag}{put NAs on the diagonal}
}
\value{
a sociomatrix
}
\description{
Construction of a sociomatrix from an edgelist
}
\examples{
Y<-matrix(rpois(10*10,.5),10,10) ; diag(Y)<-NA
E<-sm2el(Y)
el2sm(E) - Y
}
\author{
Peter Hoff
}

