% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ZA.AMMI.R
\name{ZA.AMMI}
\alias{ZA.AMMI}
\title{Absolute Value of the Relative Contribution of IPCs to the Interaction}
\usage{
ZA.AMMI(model, n, alpha = 0.05, ssi.method = c("farshadfar", "rao"),
  a = 1)
}
\arguments{
\item{model}{The AMMI model (An object of class \code{AMMI} generated by
\code{\link[agricolae]{AMMI}}).}

\item{n}{The number of principal components to be considered for computation.
The default value is the number of significant IPCs.}

\item{alpha}{Type I error probability (Significance level) to be considered
to identify the number of significant IPCs.}

\item{ssi.method}{The method for the computation of simultaneous selection
index. Either \code{"farshadfar"} or \code{"rao"} (See
\code{\link[ammistability]{SSI}}).}

\item{a}{The ratio of the weights given to the stability components for
computation of SSI when \code{method = "rao"} (See
\code{\link[ammistability]{SSI}}).}
}
\value{
A data frame with the following columns:  \item{Za}{The Za values.}
  \item{SSI}{The computed values of simultaneous selection index for yield
  and stability.} \item{rZa}{The ranks of Za values.} \item{rY}{The ranks of
  the mean yield of genotypes.} \item{means}{The mean yield of the
  genotypes.}

  The names of the genotypes are indicated as the row names of the data
  frame.
}
\description{
\code{ZA.AMMI} computes the Absolute Value of the Relative Contribution of
IPCs to the Interaction (Za) (Zali, 2012) considering all significant
interaction principal components (IPCs) in the AMMI model. Using Za, the
Simultaneous Selection Index for Yield and Stability (SSI) is also calculated
according to the argument \code{ssi.method}.
}
\details{
The Absolute Value of the Relative Contribution of IPCs to the Interaction
(\ifelse{html}{\out{<i>Za</i>}}{\eqn{Za}}) is computed as follows:

\ifelse{html}{\out{<p style="text-align: center;"><em>Za =
&sum;<sup>N'</sup><sub style="line-height: 1.8; margin-left:
-3ex;">n=1</sub>|&theta;<sub>n</sub>&gamma;<sub>in</sub>|</em></p>}}{\deqn{Za
= \sum_{i=1}^{N'}\left | \theta_{n}\gamma_{in} \right |}}

Where, \ifelse{html}{\out{<i>N'</i>}}{\eqn{N'}} is the number of significant
IPCAs (number of IPC that were retained in the AMMI model via F tests);
\ifelse{html}{\out{<i>&gamma;<sub>in<sub></i>}}{\eqn{\gamma_{in}}} is the
eigenvector value for \ifelse{html}{\out{<i>i</i>}}{\eqn{i}}th genotype; and
\ifelse{html}{\out{<i>&theta;<sub>n</sub></i>}}{\eqn{\theta_{n}}} is the
percentage sum of squares explained by the
\ifelse{html}{\out{<i>n</i>}}{\eqn{n}}th principal component interaction
effect..
}
\examples{
library(agricolae)
data(plrv)

# AMMI model
model <- with(plrv, AMMI(Locality, Genotype, Rep, Yield, console = FALSE))

# ANOVA
model$ANOVA

# IPC F test
model$analysis

# Mean yield and IPC scores
model$biplot

# G*E matrix (deviations from mean)
array(model$genXenv, dim(model$genXenv), dimnames(model$genXenv))

# With default n (N') and default ssi.method (farshadfar)
ZA.AMMI(model)

# With n = 4 and default ssi.method (farshadfar)
ZA.AMMI(model, n = 4)

# With default n (N') and ssi.method = "rao"
ZA.AMMI(model, ssi.method = "rao")

# Changing the ratio of weights for Rao's SSI
ZA.AMMI(model, ssi.method = "rao", a = 0.43)

}
\references{
\insertRef{zali_evaluation_2012}{ammistability}
}
\seealso{
\code{\link[agricolae]{AMMI}}, \code{\link[ammistability]{SSI}}
}
