% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hr_to_sf.R
\name{hr_to_sf}
\alias{hr_to_sf}
\alias{hr_to_sf.tbl_df}
\title{Convert home ranges to \code{sfc}}
\usage{
hr_to_sf(x, ...)

\method{hr_to_sf}{tbl_df}(x, col, ...)
}
\arguments{
\item{x}{A \code{tibble} with a \verb{list column} with individual home ranges.}

\item{...}{Additional columns that should be transferred to the new \code{tibble}.}

\item{col}{The column where the home}
}
\value{
A \code{data.frame} with a simple feature column (from the \code{sf}) package.
}
\description{
Convert a list column with many home-range estimates to a \code{tibble} with a geometry column (as used by the \code{sf}-package).
}
\examples{

data("amt_fisher")
hr <- amt_fisher \%>\% nest(data = -id) \%>\%
  mutate(hr = map(data, hr_mcp), n = map_int(data, nrow)) \%>\%
  hr_to_sf(hr, id, n)

hr <- amt_fisher \%>\% nest(data = -id) \%>\%
  mutate(hr = map(data, hr_kde), n = map_int(data, nrow)) \%>\%
  hr_to_sf(hr, id, n)


}
