% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_of_day.R
\name{time_of_day}
\alias{time_of_day}
\alias{time_of_day.track_xyt}
\alias{time_of_day.steps_xyt}
\title{Time of the day when a fix was taken}
\usage{
time_of_day(x, ...)

\method{time_of_day}{track_xyt}(x, solar.dep = 6, include.crepuscule = FALSE, ...)

\method{time_of_day}{steps_xyt}(x, solar.dep = 6, include.crepuscule = FALSE, where = "end", ...)
}
\arguments{
\item{x}{\verb{[track_xyt,steps_xyt]}\cr A track or steps.}

\item{...}{Further arguments, none implemented.}

\item{solar.dep}{\verb{[numeric(1,n)=6]}\cr The angle of the sun below the horizon in degrees. Passed to \code{maptools::crepuscule}.}

\item{include.crepuscule}{\verb{[logical(1)=TRUE]}\cr Should dawn and dusk be included.}

\item{where}{\verb{[character(1)="end"]\{"start", "end", "both"\}} For \code{steps}, should the start, end or both time points be used?}
}
\value{
A \code{tibble} with an additional column \code{tod_} that contains the time of the day for each relocation.
}
\description{
A convenience wrapper around \code{maptools::sunriset} and \code{maptools::crepuscule} to extract if a fix was taken during day or night (optionally also include dawn and dusk).
}
\examples{
data(deer)
deer \%>\% time_of_day()
deer \%>\% steps_by_burst \%>\% time_of_day()
deer \%>\% steps_by_burst \%>\% time_of_day(where = "start")
deer \%>\% steps_by_burst \%>\% time_of_day(where = "end")
deer \%>\% steps_by_burst \%>\% time_of_day(where = "both")

}
