% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MC0_2.R
\name{MC_Gauss}
\alias{MC_Gauss}
\title{MC estimate for the remainder}
\usage{
MC_Gauss(compBdg, problem, delta = 0.1, type = "M",
  trmvrnorm = trmvrnorm_rej_cpp, typeReturn = 0, verb = 0,
  params = NULL)
}
\arguments{
\item{compBdg}{total computational budget in seconds.}

\item{problem}{list defining the problem with mandatory fields: \itemize{
\item muEq = mean vector of \eqn{X^{q}};
\item sigmaEq = covariance matrix of \eqn{X^q};
\item threshold = threshold;
\item muEmq = mean vector of \eqn{X^{-q}};
\item wwCondQ = ``weights'' for \eqn{X^{-q} | X^q} [ the vector \eqn{\Sigma^{-q,q}(\Sigma^q)^{-1}}];
\item sigmaCondQChol = Cholesky factorization of the conditional covariance matrix \eqn{\Sigma^{-q | q}}.
}}

\item{delta}{total proportion of budget assigned to initial estimate (default 0.1), the actual proportion used might be smaller.}

\item{type}{type of excursion: "m", for minimum below threshold or "M", for maximum above threshold.}

\item{trmvrnorm}{function to generate truncated multivariate normal samples, it must have the following signature trmvrnorm(n,mu,sigma,upper,lower,verb), where \itemize{
       \item \code{n}: number of simulations;
       \item \code{mu}: mean vector of the Normal variable of dimension \eqn{d};
       \item \code{sigma}: covariance matrix of dimension \eqn{d x d};
       \item \code{upper}: vector of upper limits of length \code{d};
       \item \code{lower}: vector of lower limits of length \code{d};
       \item \code{verb}: the level of verbosity 3 basic, 4 extended.
}
It must return a matrix \eqn{d x n} of realizations. If not specified, the rejection sampler \code{\link{trmvrnorm_rej_cpp}} is used.}

\item{typeReturn}{integer: 0 (only the estimate) or 1 (heavy return with variance of the estimate, parameters of the estimator and computational times).}

\item{verb}{the level of verbosity, also sets the verbosity of trmvrnorm (to verb-1).}

\item{params}{system dependent parameters (if NULL they are estimated).}
}
\value{
A list containing the estimated probability of excursion, see \code{typeReturn} for details.
}
\description{
Standard Monte Carlo estimate for \eqn{P(max X^{-q} >threshold | max X^{q}\le threshold)} or \eqn{P(min X^{-q} <threshold | min X^{q}\ge threshold)} where X is a normal vector. It is used for the bias correction in \code{\link{ProbaMax}} and \code{\link{ProbaMin}}.
}
\references{
Azzimonti, D. and Ginsbourger, D. (2016). Estimating orthant probabilities of high dimensional Gaussian vectors with an application to set estimation. Preprint at \href{https://hal.archives-ouvertes.fr/hal-01289126}{hal-01289126}

Azzimonti, D. (2016). Contributions to Bayesian set estimation relying on random field priors. PhD thesis, University of Bern.

Genz, A. (1992). Numerical computation of multivariate normal probabilities. Journal of Computational and Graphical Statistics, 1(2):141--149.
}
