% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{mvrnormArma}
\alias{mvrnormArma}
\title{Sample from multivariate normal distribution with C++}
\usage{
mvrnormArma(n, mu, sigma, chol)
}
\arguments{
\item{n}{number of simulations.}

\item{mu}{mean vector.}

\item{sigma}{covariance matrix or Cholesky decomposition of the matrix (see chol).}

\item{chol}{integer, if 0 sigma is a covariance matrix, otherwise it is the Cholesky decomposition of the matrix.}
}
\value{
A matrix of size \eqn{d x n} containing the samples.
}
\description{
Simulates realizations from a multivariate normal with mean mu and covariance matrix sigma.
}
\examples{
# Simulate 1000 realizations from a multivariate normal vector
mu <- rep(0,200)
Sigma <- diag(rep(1,200))
realizations<-mvrnormArma(n=1000,mu = mu,sigma=Sigma, chol=0)
empMean<-rowMeans(realizations)
empCov<-cov(t(realizations))
# check if the sample mean is close to the actual mean
maxErrorOnMean<-max(abs(mu-empMean))
# check if we can estimate correctly the covariance matrix
maxErrorOnVar<-max(abs(rep(1,200)-diag(empCov)))
maxErrorOnCov<-max(abs(empCov[lower.tri(empCov)]))
\dontrun{
plot(density(realizations[2,]))
}
}
