% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimizeEq.R
\name{selectActiveDims}
\alias{selectActiveDims}
\title{Select active dimensions for small dimensional estimate}
\usage{
selectActiveDims(q = NULL, E, threshold, mu, Sigma, pn = NULL, method = 1,
  verb = 0, pmvnorm_usr = pmvnorm)
}
\arguments{
\item{q}{either the fixed number of active dimensions or the range where the number of active dimensions is chosen with \code{selectQdims}. If \code{NULL} the function \code{\link{selectQdims}} is called.}

\item{E}{discretization design for the field.}

\item{threshold}{threshold.}

\item{mu}{mean vector.}

\item{Sigma}{covariance matrix.}

\item{pn}{coverage probability function based on \code{threshold}, \code{mu} and \code{Sigma}. If \code{NULL} it is computed.}

\item{method}{integer chosen between \itemize{
\item 0  selects by taking equally spaced indexes in mu;
\item 1  samples from pn;
\item 2  samples from pn*(1-pn);
\item 3  samples from pn adjusting for the distance (tries to explore all modes);
\item 4  samples from pn*(1-pn) adjusting for the distance (tries to explore all modes);
\item 5  samples with uniform probabilities.
}}

\item{verb}{level of verbosity: 0 returns nothing, 1 returns minimal info}

\item{pmvnorm_usr}{function to compute core probability on active dimensions. Inputs: \itemize{
\item \code{lower:} the vector of lower limits of length \code{d}.
\item \code{upper:} the vector of upper limits of length \code{d}.
\item \code{mean:} the mean vector of length \code{d}.
\item \code{sigma:} the covariance matrix of dimension \code{d}.
}
returns a the probability value with attribute "error", the absolute error. Default is the function \code{\link[mvtnorm]{pmvnorm}} from the package \code{mvtnorm}.}
}
\value{
A vector of integers denoting the chosen active dimensions of the vector mu.
}
\description{
The function \code{selectActiveDims} selects the active dimensions for the computation of \eqn{p_q} with an heuristic method.
}
\references{
Azzimonti, D. and Ginsbourger, D. (2017). Estimating orthant probabilities of high dimensional Gaussian vectors with an application to set estimation. Journal of Computational and Graphical Statistics. Preprint at \href{https://hal.archives-ouvertes.fr/hal-01289126}{hal-01289126}

Azzimonti, D. (2016). Contributions to Bayesian set estimation relying on random field priors. PhD thesis, University of Bern.

Chevalier, C. (2013). Fast uncertainty reduction strategies relying on Gaussian process models. PhD thesis, University of Bern.

Genz, A. (1992). Numerical computation of multivariate normal probabilities. Journal of Computational and Graphical Statistics, 1(2):141--149.
}
