% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core-functions-meta-pipelines.R
\name{loadMetaPipeline}
\alias{loadMetaPipeline}
\title{Load a meta-pipeline}
\usage{
loadMetaPipeline(path)
}
\arguments{
\item{path}{the path at which the .Rds file containing the pipeline is located}
}
\value{
An \code{MetaAnalysisPipeline} object
}
\description{
Load a meta-pipeline
}
\details{
This function loads a meta-pipeline from a file system, and returns the meta-pipeline object, which can be assigned
to an object in the environment.

Note - When a meta-pipeline is loaded, the existing registry is overwritten with the registry saved with the
meta-pipeline
}
\examples{
\dontrun{
 loadMetaPipeline(path = "./metaPipeline.RDS")
}
}
\seealso{
Other Package core functions: \code{\link{BaseAnalysisPipeline-class}},
  \code{\link{MetaAnalysisPipeline-class}},
  \code{\link{assessEngineSetUp}},
  \code{\link{checkSchemaMatch}},
  \code{\link{createPipelineInstance}},
  \code{\link{exportAsMetaPipeline}},
  \code{\link{generateOutput}},
  \code{\link{genericPipelineException}},
  \code{\link{getInput}}, \code{\link{getLoggerDetails}},
  \code{\link{getOutputById}},
  \code{\link{getPipelinePrototype}},
  \code{\link{getPipeline}}, \code{\link{getRegistry}},
  \code{\link{initDfBasedOnType}},
  \code{\link{initialize,BaseAnalysisPipeline-method}},
  \code{\link{loadPipeline}},
  \code{\link{loadPredefinedFunctionRegistry}},
  \code{\link{loadRegistry}}, \code{\link{prepExecution}},
  \code{\link{registerFunction}},
  \code{\link{savePipeline}}, \code{\link{saveRegistry}},
  \code{\link{setInput}}, \code{\link{setLoggerDetails}},
  \code{\link{updateObject}},
  \code{\link{visualizePipeline}}
}
\concept{Package core functions}
