% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colsum.R
\name{colsum}
\alias{colsum}
\title{Give Row sums of a Matrix-like Object, Based on a Grouping Variable}
\usage{
colsum(M, group = colnames(M), reord = FALSE, na_rm = FALSE,
  big = TRUE, ...)
}
\arguments{
\item{M}{a matrix, data frame or vector of numeric data. Missing values are allowed. A numeric vector will be treated as a column vector.}

\item{group}{a vector or factor giving the grouping, with one element per row of M. Default: rownames of M.}

\item{reord}{if TRUE, then the result will be in order of sort(unique(group)), if FALSE (the default), it will be in the order that groups were encountered.}

\item{na_rm}{logical (TRUE or FALSE). Should NA (including NaN) values be discarded?}

\item{big}{is your object big and integer overflow is likely? If TRUE, then M is multiplied by 1.0 to ensure values are of type double (perhaps taking more RAM).}

\item{...}{other arguments to be passed to or from methods.}
}
\value{
A matrix-like object containing the sums by group. There will be one row per unique value of group.
}
\description{
Compute Row sums across columns of a numeric matrix-like object for each level of a grouping variable.
}
\details{
This function is a wrapper for base function \code{rowsum} and is its "column" version.
}
\examples{

A <- matrix(1:8, ncol = 4)
colnames(A) <- c("A", "B", "A", "B")
colsum(A)

}
\seealso{
\code{\link[base]{rowsum}}
}
\author{
Albert Dorador
}
