% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/MembershipFunction.R
\docType{class}
\name{MembershipFunction-class}
\alias{MembershipFunction}
\alias{MembershipFunction-class}
\title{MembershipFunction S4 class}
\description{
Represent a generic virtual S4 MembershipFunction class, for fuzzy further
redefinition. The actual subclases available are GaussianMF,
NormalizedGaussianMF and BellMF.
}
\section{Slots}{

\describe{
\item{\code{parameters}}{named numeric vector with parameters of Membership Function.}

\item{\code{nParameters}}{integer with the number of parameters for validity check.}

\item{\code{name}}{character The description of the membership function.}

\item{\code{expression}}{expression object just to display purposes.}
}}
\note{
validity: nParameters == length(parameters) and parameters != NA and
names(parameters)!="".
}
\section{Functions}{

MembershipFunction S4 class includes the following functions:
\describe{
 \item{show/print}{generic output of the object.}
 \item{"[", "[<-"}{getter and setter of the parameters values.}
 \item{evaluateMF}{return membership value at x.}
 \item{derivateMF}{return the derivate membership at x.}
}
}
\author{
Cristobal Fresno \email{cfresno@bdmg.com.ar}, Andrea S. Llera
 \email{ALlera@leloir.org.ar} and Elmer A. Fernandez
 \email{efernandez@bdmg.com.ar}
}
\seealso{
\code{\link{BellMF-class}}, \code{\link{GaussianMF-class}} or
 \code{\link{NormalizedGaussianMF-class}}

Other Membership Functions: \code{\link{BellMF}},
  \code{\link{BellMF-class}}; \code{\link{GaussianMF}},
  \code{\link{GaussianMF-class}};
  \code{\link{NormalizedGaussianMF}},
  \code{\link{NormalizedGaussianMF-class}};
  \code{\link{[,MembershipFunction-method}},
  \code{\link{[<-,MembershipFunction-method}},
  \code{\link{extract-methods}},
  \code{\link{extract-methods}}; \code{\link{derivateMF}},
  \code{\link{derivateMF}}, \code{\link{derivateMF}},
  \code{\link{derivateMF}}, \code{\link{derivateMF}},
  \code{\link{derivateMF,BellMF-method}},
  \code{\link{derivateMF,GaussianMF-method}},
  \code{\link{derivateMF,MembershipFunction-method}},
  \code{\link{derivateMF,NormalizedGaussianMF-method}},
  \code{\link{derivateMF-methods}};
  \code{\link{evaluateMF}}, \code{\link{evaluateMF}},
  \code{\link{evaluateMF}}, \code{\link{evaluateMF}},
  \code{\link{evaluateMF}},
  \code{\link{evaluateMF,BellMF-method}},
  \code{\link{evaluateMF,GaussianMF-method}},
  \code{\link{evaluateMF,MembershipFunction-method}},
  \code{\link{evaluateMF,NormalizedGaussianMF-method}},
  \code{\link{evaluateMF-methods}};
  \code{\link{print,MembershipFunction-method}};
  \code{\link{show,MembershipFunction-method}}
}

