% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mesh_plot.R
\name{mesh_plot}
\alias{mesh_plot}
\alias{[plot3d]}
\alias{[as.mesh3d]}
\alias{[persp3d]}
\alias{[dot3d]}
\alias{[wire3d]}
\alias{[shade3d]}
\alias{mesh_plot.mesh3d}
\alias{mesh_plot.BasicRaster}
\alias{mesh_plot.sc}
\alias{mesh_plot.default}
\alias{mesh_plot.triangulation}
\title{Plot a mesh surface in 2D}
\usage{
mesh_plot(
  x,
  col = NULL,
  add = FALSE,
  zlim = NULL,
  ...,
  coords = NULL,
  crs = NULL
)

\method{mesh_plot}{mesh3d}(
  x,
  col = NULL,
  add = FALSE,
  zlim = NULL,
  ...,
  coords = NULL,
  crs = NULL
)

\method{mesh_plot}{BasicRaster}(
  x,
  col = NULL,
  add = FALSE,
  zlim = NULL,
  ...,
  coords = NULL,
  crs = NULL
)

\method{mesh_plot}{sc}(
  x,
  col = NULL,
  add = FALSE,
  zlim = NULL,
  ...,
  coords = NULL,
  crs = NULL
)

\method{mesh_plot}{default}(
  x,
  col = NULL,
  add = FALSE,
  zlim = NULL,
  ...,
  coords = NULL,
  crs = NULL
)

\method{mesh_plot}{triangulation}(
  x,
  col = NULL,
  add = FALSE,
  zlim = NULL,
  ...,
  coords = NULL,
  crs = NULL
)
}
\arguments{
\item{x}{object to convert to mesh and plot}

\item{col}{colours to use, defaults to that used by \code{\link[graphics:image]{graphics::image()}}}

\item{add}{add to existing plot or start a new one}

\item{zlim}{absolute range of data to use for colour scaling (if \code{NULL} the
data range is used)}

\item{...}{passed through to \code{base::plot}}

\item{coords}{optional input raster of coordinates of each cell, see details}

\item{crs}{target map projection}
}
\value{
nothing, used for the side-effect of creating or adding to a plot
}
\description{
Draw a 2D interpretation of a mesh object, or a mesh-alike object.
This is very fast and can be used to created \emph{approximately} continuously
varying surface plots.
}
\details{
The input is treated as a mesh and plotted in vectorized form using
'grid'.

The mesh may be reprojected prior to plotting using the 'crs' argument to
define the target map projection in 'PROJ string' format. (There is no
"reproject" function for quadmesh, this is performed directly on the x-y
coordinates of the 'quadmesh' output). The 'col' argument are mapped to the
inputdata as in \code{\link[graphics:image]{graphics::image()}}, and applied relative to 'zlim' if
also supplied.

The \code{coords} argument only applies to a raster object. The \code{crs} argument
only applies to a spatial object that has a crs projection metadata string
understood by anglr (works, but still work in progress). There is a
change from the previous \code{quadmesh::mesh_plot()} function that requires
both crs and coords to be named. In quadmesh, crs was the second argument
to the \code{mesh_plot()} function and so in usage was normally not named.

If \code{coords} is supplied, it is currently assumed to be a 2-layer
\code{RasterBrick} with longitude and latitude as the \emph{cell values}. These are
used to geographically locate the resulting mesh, and will be transformed to
the \code{crs} if that is supplied. This is modelled on the approach to
curvilinear grid data used in the \code{angstroms} package. There the function
\code{angstroms::romsmap()} and `angstroms::romscoords()`` are used to separate
the complicated grid geometry from the grid data itself.
}
