% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generators.R
\name{ImageGenerator}
\alias{ImageGenerator}
\title{Tensorflow data generator that resizes images.}
\usage{
ImageGenerator(
  files,
  resize_height = NULL,
  resize_width = NULL,
  standardize = FALSE,
  batch = 1
)
}
\arguments{
\item{files}{a vector of file names}

\item{resize_height}{the height the cropped image will be resized to. If NULL returns original size images.}

\item{resize_width}{the width the cropped image will be resized to. If NULL returns original size images..}

\item{standardize}{standardize the image to the range 0 to 1, TRUE or FALSE.}

\item{batch}{the batch size for the image generator.}
}
\value{
A Tensorflow image data generator.
}
\description{
Creates an image data generator that resizes images if requested.
}
\examples{
\dontrun{
dataset <- ImageGenerator(images, standardize = FALSE, batch = batch)
}
}
