% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build.R
\name{sqlite.index}
\alias{sqlite.index}
\title{Generate search index of annovarR database table in sqlite}
\usage{
sqlite.index(sqlite.connect.params = list(dbname = "", table.name = ""),
  index = "", cols = c(), verbose = FALSE, ...)
}
\arguments{
\item{sqlite.connect.params}{Connect to sqlite database params [dbname, table.name]}

\item{index}{Index name in sqlite}

\item{cols}{Colnames needed to be index}

\item{verbose}{Ligical indicating wheather show the log message}

\item{...}{Other parameters be used in dbSendQuery}
}
\description{
Generate search index of annovarR database table in sqlite
}
\examples{
test.sqlite <- sprintf('\%s/snp.test.sqlite', tempdir())
test.dat <- system.file('extdata', 'demo/sqlite.dat.txt', package = 'annovarR')
x <- sqlite.build(filename = test.dat, list(dbname = test.sqlite, 
table.name = 'snp_test'))
x <- sqlite.index(list(dbname = test.sqlite, table.name = 'snp_test'), 
index = 'index4', cols = c('V1', 'V2'))
test.sqlite <- normalizePath(test.sqlite, '/')
file.remove(test.sqlite)
}
