% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_frequency.R
\name{time_frequency}
\alias{time_frequency}
\alias{time_trend}
\title{Generate a time series frequency from a periodicity}
\usage{
time_frequency(data, period = "auto", message = TRUE)

time_trend(data, period = "auto", message = TRUE)
}
\arguments{
\item{data}{A \code{tibble} with a date or datetime index.}

\item{period}{Either "auto", a time-based definition (e.g. "2 weeks"),
or a numeric number of observations per frequency (e.g. 10).
See \code{\link[tibbletime:collapse_by]{tibbletime::collapse_by()}} for period notation.}

\item{message}{A boolean. If \code{message = TRUE}, the frequency used is output
along with the units in the scale of the data.}
}
\value{
Returns a scalar numeric value indicating the number of observations in the frequency or trend span.
}
\description{
Generate a time series frequency from a periodicity
}
\details{
A frequency is loosely defined as the number of observations that comprise a cycle
in a data set. The trend is loosely defined as time span that can
be aggregated across to visualize the central tendency of the data.
It's often easiest to think of frequency and trend in terms of the time-based units
that the data is already in. \strong{This is what \code{time_frequency()} and \code{time_trend()}
enable: using time-based periods to define the frequency or trend.}

\strong{Frequency}:

As an example, a weekly cycle is often 5-days (for working
days) or 7-days (for calendar days). Rather than specify a frequency of 5 or 7,
the user can specify \code{period = "1 week"}, and
time_frequency()` will detect the scale of the time series and return 5 or 7
based on the actual data.

The \code{period} argument has three basic options for returning a frequency.
Options include:
\itemize{
\item \code{"auto"}: A target frequency is determined using a pre-defined template (see \code{template} below).
\item \verb{time-based duration}: (e.g. "1 week" or "2 quarters" per cycle)
\item \verb{numeric number of observations}: (e.g. 5 for 5 observations per cycle)
}

The \code{template} argument is only used when \code{period = "auto"}. The template is a tibble
of three features: \code{time_scale}, \code{frequency}, and \code{trend}. The algorithm will inspect
the scale of the time series and select the best frequency that matches the scale and
number of observations per target frequency. A frequency is then chosen on be the
best match. The predefined template is stored in a function \code{time_scale_template()}.
However, the user can come up with his or her own template changing the values
for frequency in the data frame and saving it to \code{anomalize_options$time_scale_template}.

\strong{Trend}:

As an example, the trend of daily data is often best aggregated by evaluating
the moving average over a quarter or a month span. Rather than specify the number
of days in a quarter or month, the user can specify "1 quarter" or "1 month",
and the \code{time_trend()} function will return the correct number of observations
per trend cycle. In addition, there is an option, \code{period = "auto"}, to
auto-detect an appropriate trend span depending on the data. The \code{template}
is used to define the appropriate trend span.
}
\examples{

library(dplyr)

data(tidyverse_cran_downloads)

#### FREQUENCY DETECTION ####

# period = "auto"
tidyverse_cran_downloads \%>\%
    filter(package == "tidyquant") \%>\%
    ungroup() \%>\%
    time_frequency(period = "auto")

time_scale_template()

# period = "1 month"
tidyverse_cran_downloads \%>\%
    filter(package == "tidyquant") \%>\%
    ungroup() \%>\%
    time_frequency(period = "1 month")

#### TREND DETECTION ####

tidyverse_cran_downloads \%>\%
    filter(package == "tidyquant") \%>\%
    ungroup() \%>\%
    time_trend(period = "auto")
}
