% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anscombise.R
\name{anscombise}
\alias{anscombise}
\title{Create new versions of Anscombe's quartet}
\usage{
anscombise(x, which = 1)
}
\arguments{
\item{x}{A numeric matrix or data frame.  Each column contains observations
on a different variable.  Missing observations are not allowed.}

\item{which}{An integer in \{1, 2, 3, 4\}.  Which of Anscombe's dataset to
use.  Obviously, this makes very little difference.}
}
\value{
An object of class \code{c("anscombe", class(x))}. A dataset with the
same format as \code{x}.  The returned dataset has the following summary
statistics in common with Anscombe's quartet.
\itemize{
\item The sample means of each variable.
\item The sample variances of each variable.
\item The sample correlation matrix.
\item The estimated regression coefficients from least squares linear
regressions of each variable on each other variable.
The target and new summary statistics are returned as attributes
\code{old_stats} and \code{new_stats} and the chosen Anscombe's quartet dataset as
an attribute \code{old_data}.
}
}
\description{
Modifies a dataset \code{x} so that it shares sample summary statistics with
\link[datasets:anscombe]{Anscombe's quartet}.
}
\details{
The input dataset \code{x} is modified by shifting, scaling and rotating
it so that its sample mean and covariance matrix match those of the
Anscombe quartet.
}
\examples{
# Old faithful to new faithful
new_faithful <- anscombise(datasets::faithful, which = 4)
plot(new_faithful)
# Then check that the sample summary statistics are the same
plot(new_faithful, input = TRUE)

# Map of Italy
got_maps <- requireNamespace("maps", quietly = TRUE)
if (got_maps) {
  italy <- mapdata("Italy")
  new_italy <- anscombise(italy, which = 4)
  plot(new_italy)
}
}
\seealso{
\code{\link{mimic}} to modify a dataset to share sample summary statistics
with another dataset.
}
