% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_stats.R
\name{set_stats}
\alias{set_stats}
\title{Create a list of summary statistics}
\usage{
set_stats(d = 2, means = 0, variances = 1, correlation = diag(2))
}
\arguments{
\item{d}{An integer that is no smaller than 2.}

\item{means}{A numeric vector of sample means.}

\item{variances}{A numeric vector of positive sample variances.}

\item{correlation}{A numeric correlation matrix.  None of the off-diagonal
entries in \code{correlation} are allowed to be equal to 1 in absolute value.}
}
\value{
A list containing the following components.
\itemize{
\item \code{means} a \code{d}-vector of sample means.
\item \code{variances} a \code{d}-vector sample variances.
\item \code{correlation} a \code{d} by \code{d} correlation matrix.
}
}
\description{
Creates a list of summary statistics to pass to \code{\link{mimic}}.
}
\details{
The vectors \code{means} and \code{variances} are recycled using
\code{\link[=rep]{rep_len}} to have length \code{d}.
}
\examples{
# Uncorrelated with zero means and unit variances
set_stats()
# Sample correlation = 0.9
set_stats(correlation = matrix(c(1, 0.9, 0.9, 1), 2, 2))
}
