/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.REngine;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.rosuda.REngine.REngine;
import org.rosuda.REngine.UniqueID;

public class REngineRegistry {
    private static Map engines = Collections.synchronizedMap(new HashMap());
    private static Map identifiers = Collections.synchronizedMap(new HashMap());

    public static REngine getEngine(UniqueID uniqueID) throws IOException {
        if (!engines.containsKey(uniqueID)) {
            throw new IOException("no engine for the specified identifier");
        }
        return (REngine)engines.get(uniqueID);
    }

    public static UniqueID getId(REngine rEngine) {
        if (identifiers.containsKey(rEngine)) {
            return (UniqueID)identifiers.get(rEngine);
        }
        UniqueID uniqueID = new UniqueID();
        REngineRegistry.add(rEngine, uniqueID);
        return uniqueID;
    }

    public static void add(REngine rEngine, UniqueID uniqueID) {
        engines.put(uniqueID, rEngine);
        identifiers.put(rEngine, uniqueID);
    }

    public static void remove(UniqueID uniqueID) {
        if (engines.containsKey(uniqueID)) {
            REngine rEngine = (REngine)engines.get(uniqueID);
            engines.remove(uniqueID);
            identifiers.remove(rEngine);
        }
    }

    public static void remove(REngine rEngine) {
        if (identifiers.containsKey(rEngine)) {
            UniqueID uniqueID = (UniqueID)identifiers.get(rEngine);
            identifiers.remove(rEngine);
            engines.remove(uniqueID);
        }
    }
}

