% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scenarioBuilder.R
\name{scenario-builder}
\alias{scenario-builder}
\alias{scenarioBuilder}
\alias{readScenarioBuilder}
\alias{updateScenarioBuilder}
\title{Read, create & update scenario builder}
\usage{
scenarioBuilder(
  n_scenario,
  n_mc = NULL,
  areas = NULL,
  areas_rand = NULL,
  opts = antaresRead::simOptions()
)

readScenarioBuilder(
  ruleset = "Default Ruleset",
  as_matrix = TRUE,
  opts = antaresRead::simOptions()
)

updateScenarioBuilder(
  ldata,
  ruleset = "Default Ruleset",
  series = NULL,
  opts = antaresRead::simOptions()
)
}
\arguments{
\item{n_scenario}{Number of scenario.}

\item{n_mc}{Number of Monte-Carlo years.}

\item{areas}{Areas to use in scenario builder, if \code{NULL} (default), areas in Antares study are used.}

\item{areas_rand}{Areas for which to use \code{"rand"}.}

\item{opts}{List of simulation parameters returned by the function
\code{antaresRead::setSimulationPath}}

\item{ruleset}{Ruleset to read.}

\item{as_matrix}{If \code{TRUE} (default) return a matrix, else a list.}

\item{ldata}{A \code{matrix} obtained with \code{scenarioBuilder}, 
or a named list of matrices obtained with \code{scenarioBuilder}, names must be 
'l', 'h', 'w', 's' or 't', depending on the series to update.}

\item{series}{Name(s) of the serie(s) to update if \code{ldata} is a single \code{matrix}.}
}
\value{
\code{scenarioBuilder} : a \code{matrix}

\code{readScenarioBuilder} : a \code{list} of \code{matrix} or \code{list}
}
\description{
Read, create & update scenario builder
}
\examples{
\dontrun{

library(antaresRead)
library(antaresEditObject)

# simulation path
setSimulationPath(
  path = "pat/to/simulation",
  simulation = "input"
)

# Create a scenario builder matrix
sbuilder <- scenarioBuilder(
  n_scenario = 51,
  n_mc = 2040,
  areas_rand = c("fr", "be")
)
sbuilder[, 1:6]
dim(sbuilder)


# Read previous scenario builder
# in a matrix format
prev_sb <- readScenarioBuilder()


# Update scenario builder

# for load serie
updateScenarioBuilder(ldata = sbuilder, series = "load")

# equivalent as
updateScenarioBuilder(ldata = list(l = sbuilder))


# update several series

# same input
sbuilder
updateScenarioBuilder(
  ldata = sbuilder, 
  series = c("load", "hydro", "solar")
)

# different input
updateScenarioBuilder(ldata = list(
  l = load_sb,
  h = hydro_sb,
  s = solar_sb
))

}
}
