% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_layout.R
\name{plot.mapLayout}
\alias{plot.mapLayout}
\title{Plot method for map layout}
\usage{
\method{plot}{mapLayout}(x, colAreas = x$coords$color, dataAreas = 1,
  opacityArea = 1, areaMaxSize = 30, areaMaxHeight = 50,
  areaChartType = c("auto", "bar", "pie", "polar-area", "polar-radius"),
  labelArea = NULL, labelMinSize = 8, labelMaxSize = 8,
  colLinks = "#CCCCCC", sizeLinks = 3, opacityLinks = 1, dirLinks = 0,
  links = TRUE, areas = TRUE, tilesURL = defaultTilesURL(),
  preprocess = function(map) {     map }, width = NULL, height = NULL,
  ...)
}
\arguments{
\item{x}{Object created with function \code{\link{mapLayout}}}

\item{colAreas}{Vector of colors for areas. By default, the colors used in the Antares
software are used.}

\item{dataAreas}{A numeric vector or a numeric matrix that is passed to function
\code{link[addMinicharts]}. A single vector will produce circles with
different radius. A matrix will produce bar charts or pie charts or 
polar charts, depending on the value of \code{areaChartType}}

\item{opacityArea}{Opacity of areas. It has to be a numeric vector with values
between 0 and 1.}

\item{areaMaxSize}{Maximal width in pixels of the symbols that represent 
areas on the map.}

\item{areaMaxHeight}{Maximal height of bars. Used only if a barchart representation is used.}

\item{areaChartType}{Type of chart to use to represent areas.}

\item{labelArea}{Character vector containing labels to display inside areas.}

\item{labelMinSize}{minimal height of labels.}

\item{labelMaxSize}{maximal height of labels.}

\item{colLinks}{Vector of colors for links.}

\item{sizeLinks}{Line width of the links, in pixels.}

\item{opacityLinks}{Opacity of the links. It has to be a numeric vector with values
between 0 and 1.}

\item{dirLinks}{Single value or vector indicating the direction of the link. Possible values
are 0, -1 and 1. If it equals 0, then links are repsented by a simple line. 
If it is equal to 1 or -1 it is represented by a line with an arrow pointing
respectively the destination and the origin of the link.}

\item{links}{Should links be drawn on the map ?}

\item{areas}{Should areas be drawn on the map ?}

\item{tilesURL}{URL template used to get map tiles. The followign site 
provides some URLs;
\url{https://leaflet-extras.github.io/leaflet-providers/preview/}}

\item{preprocess}{A function that takes as argument a map and that returns a
modified version of this map. This parameter can be used to add extra
information on a map.}

\item{width}{Width of the graph expressed in pixels or in percentage of 
the parent element. For instance "500px" and "100\%" are valid values.}

\item{height}{Height of the graph expressed in pixels or in percentage of 
the parent element. For instance "500px" and "100\%" are valid values.}

\item{...}{Currently unused.}
}
\value{
The function generates an \code{htmlwidget} of class \code{leaflet}. It can
  be stored in a variable and modified with package 
  \code{\link[leaflet]{leaflet}}
}
\description{
This method can be used to visualize the network of an antares study.
It generates an interactive map with a visual representaiton of a
map layout created with function \code{\link{mapLayout}}.
}
\examples{
\dontrun{
# Read the coordinates of the areas in the Antares interface, then convert it
# in a map layout.
layout <- readLayout()
ml <- mapLayout(layout)

# Save the result for future use
save(ml, file = "ml.rda")

# Plot the network on an interactive map
plot(ml)

# change style
plot(ml, colAreas = gray(0.5), colLinks = "orange")

# Use polar area charts to represent multiple values for each area.
nareas <- nrow(ml$coords)
fakeData <- matrix(runif(nareas * 3), ncol = 3)
plot(ml, sizeAreas = fakeData)

# Store the result in a variable to change it with functions from leaflet 
# package
library(leaflet)

center <- c(mean(ml$coords$x), mean(ml$coords$y))

p <- plot(ml)
p \%>\% 
  addCircleMarker(center[1], center[2], color = "red", 
                  popup = "I'm the center !")
}

}
