% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{tsPlot}
\alias{tsPlot}
\alias{plot.antaresData}
\alias{plot.simOptions}
\alias{plot.list}
\title{plot time series contained in an antaresData object}
\usage{
tsPlot(x, refStudy = NULL, table = NULL, variable = NULL,
  elements = NULL, variable2Axe = NULL, mcYear = "average",
  type = c("ts", "barplot", "monotone", "density", "cdf", "heatmap"),
  dateRange = NULL, typeConfInt = FALSE, confInt = 0,
  minValue = NULL, maxValue = NULL, aggregate = c("none", "mean",
  "sum", "mean by areas", "sum by areas"), compare = NULL,
  compareOpts = list(), interactive = getInteractivity(),
  colors = NULL, main = NULL, ylab = NULL, legend = TRUE,
  legendItemsPerRow = 5, colorScaleOpts = colorScaleOptions(20),
  width = NULL, height = NULL, xyCompare = c("union", "intersect"),
  h5requestFiltering = list(), highlight = FALSE, stepPlot = FALSE,
  drawPoints = FALSE, secondAxis = FALSE, timeSteph5 = "hourly",
  mcYearh5 = NULL, tablesh5 = c("areas", "links"), language = "en",
  hidden = NULL, ...)

\method{plot}{antaresData}(x, refStudy = NULL, table = NULL,
  variable = NULL, elements = NULL, variable2Axe = NULL,
  mcYear = "average", type = c("ts", "barplot", "monotone", "density",
  "cdf", "heatmap"), dateRange = NULL, typeConfInt = FALSE,
  confInt = 0, minValue = NULL, maxValue = NULL,
  aggregate = c("none", "mean", "sum", "mean by areas", "sum by areas"),
  compare = NULL, compareOpts = list(),
  interactive = getInteractivity(), colors = NULL, main = NULL,
  ylab = NULL, legend = TRUE, legendItemsPerRow = 5,
  colorScaleOpts = colorScaleOptions(20), width = NULL,
  height = NULL, xyCompare = c("union", "intersect"),
  h5requestFiltering = list(), highlight = FALSE, stepPlot = FALSE,
  drawPoints = FALSE, secondAxis = FALSE, timeSteph5 = "hourly",
  mcYearh5 = NULL, tablesh5 = c("areas", "links"), language = "en",
  hidden = NULL, ...)

\method{plot}{simOptions}(x, refStudy = NULL, table = NULL,
  variable = NULL, elements = NULL, variable2Axe = NULL,
  mcYear = "average", type = c("ts", "barplot", "monotone", "density",
  "cdf", "heatmap"), dateRange = NULL, typeConfInt = FALSE,
  confInt = 0, minValue = NULL, maxValue = NULL,
  aggregate = c("none", "mean", "sum", "mean by areas", "sum by areas"),
  compare = NULL, compareOpts = list(),
  interactive = getInteractivity(), colors = NULL, main = NULL,
  ylab = NULL, legend = TRUE, legendItemsPerRow = 5,
  colorScaleOpts = colorScaleOptions(20), width = NULL,
  height = NULL, xyCompare = c("union", "intersect"),
  h5requestFiltering = list(), highlight = FALSE, stepPlot = FALSE,
  drawPoints = FALSE, secondAxis = FALSE, timeSteph5 = "hourly",
  mcYearh5 = NULL, tablesh5 = c("areas", "links"), language = "en",
  hidden = NULL, ...)

\method{plot}{list}(x, refStudy = NULL, table = NULL,
  variable = NULL, elements = NULL, variable2Axe = NULL,
  mcYear = "average", type = c("ts", "barplot", "monotone", "density",
  "cdf", "heatmap"), dateRange = NULL, typeConfInt = FALSE,
  confInt = 0, minValue = NULL, maxValue = NULL,
  aggregate = c("none", "mean", "sum", "mean by areas", "sum by areas"),
  compare = NULL, compareOpts = list(),
  interactive = getInteractivity(), colors = NULL, main = NULL,
  ylab = NULL, legend = TRUE, legendItemsPerRow = 5,
  colorScaleOpts = colorScaleOptions(20), width = NULL,
  height = NULL, xyCompare = c("union", "intersect"),
  h5requestFiltering = list(), highlight = FALSE, stepPlot = FALSE,
  drawPoints = FALSE, secondAxis = FALSE, timeSteph5 = "hourly",
  mcYearh5 = NULL, tablesh5 = c("areas", "links"), language = "en",
  hidden = NULL, ...)
}
\arguments{
\item{x}{Object of class \code{antaresData}. Alternatively, it can be a list of 
\code{antaresData} objects. In this case, one chart is created for each
object. Can also be opts object from h5 file or list of opts object from h5 file.}

\item{refStudy}{An object of class \code{antaresData} created with function 
\code{\link[antaresRead]{readAntares}} containing data for areas and or
districts. Can also contains an opts who refer to a h5 file.}

\item{table}{Name of the table to display when \code{x} is an \code{antaresDataList}
object.}

\item{variable}{Name of the variable to plot. If this argument is missing, then the 
function starts a shiny gadget that let the user choose the variable to
represent. When the user clicks on the "Done" button", the graphic is
returned by the function.}

\item{elements}{Vector of "element" names indicating for which elements of 'x' should the
variable be plotted. For instance if the input data contains areas, then
this parameter should be a vector of area names. If data contains clusters
data, this parameter has to be the concatenation of the area name and the
cluster name, separated by \code{" > "}. This is to prevent confusion 
when two clusters from different areas have the same name.}

\item{variable2Axe}{\code{character}, variables on second axis.}

\item{mcYear}{If \code{x}, contains multiple Monte-Carlo scenarios, this parameter 
determine which scenario is displayed. Must be an integer representing the
index of the scenario or the word "average". In this case data are 
averaged.}

\item{type}{Type of plot to draw. "ts" creates a time series plot, "barplot" creates
a barplot with one bar per element representing the average value of the
variable for this element. "monotone" draws the monotone curve of the 
variable for each element.}

\item{dateRange}{A vector of two dates. Only data points between these two dates are 
displayed. If NULL, then all data is displayed.}

\item{typeConfInt}{\code{logical}. If multiple Monte Carlo scenarios are present in 
the input data, see all curves (FALSE, Default), or mean and confidence interval (TRUE)}

\item{confInt}{Number between 0 and 1 indicating the size of the confidence interval to 
display. If it equals to 0, then confidence interval is not computed nor
displayed. Used only when multiple Monte Carlo scenarios are present in 
the input data.}

\item{minValue}{Only used if parameter \code{type} is "density" or "cdf". If this parameter
is set, all values that are less than \code{minValue} are removed from the 
graphic. This is useful to deal with variables containing a few extreme
values (generally cost and price variables). If \code{minValue} is unset,
all values are displayed.}

\item{maxValue}{Only used if parameter \code{type} is "density" or "cdf". If this parameter 
is set, all values not in [-minValue, maxValue] are removed from the graphic.
This is useful to deal with variables containing a few extreme values
(generally cost and price variables). If \code{maxValue} is 0 or unset, all
values are displayed.}

\item{aggregate}{When multiple elements are selected, should the data be aggregated. If
"none", each element is represented separetly. If "mean" values are
averaged and if "sum" they are added. You can also compute mean ans sum by areas.}

\item{compare}{An optional character vector containing names of parameters. When it is set,
two charts are outputed with their own input controls. Alternatively, it can
be a named list with names corresponding to parameter names and values being
list with the initial values of the given parameter for each chart. See details
 if you are drawing a map.}

\item{compareOpts}{List of options that indicates the number of charts to create and their 
position. Check out the documentation of 
\code{\link[manipulateWidget]{compareOptions}} to see available options.}

\item{interactive}{LogicalValue. If \code{TRUE}, then a shiny gadget is launched that lets
the user interactively choose the areas or districts to display.}

\item{colors}{Vector of colors}

\item{main}{Title of the graph.}

\item{ylab}{Label of the Y axis.}

\item{legend}{Logical value indicating if a legend should be drawn. This argument is 
usefull when one wants to create a shared legend with
\code{\link{prodStackLegend}}}

\item{legendItemsPerRow}{Number of elements to put in each row of the legend.}

\item{colorScaleOpts}{A list of parameters that control the creation of color scales. It is used
only for heatmaps. See \code{\link{colorScaleOptions}}() for available
parameters.}

\item{width}{Width of the graph expressed in pixels or in percentage of 
the parent element. For instance "500px" and "100\%" are valid values.}

\item{height}{Height of the graph expressed in pixels or in percentage of 
the parent element. For instance "500px" and "100\%" are valid values.}

\item{xyCompare}{Use when you compare studies, can be "union" or "intersect". If union, all
of mcYears in one of studies will be selectable. If intersect, only mcYears in all
studies will be selectable.}

\item{h5requestFiltering}{Contains arguments used by default for h5 request,
typically h5requestFiltering = list(mcYears = 2)}

\item{highlight}{highlight curve when mouse over}

\item{stepPlot}{\code{boolean}, step style for curves.}

\item{drawPoints}{\code{boolean}, add points on graph}

\item{secondAxis}{add second axis to graph}

\item{timeSteph5}{\code{character} timeStep to read in h5 file. Only for Non interactive mode.}

\item{mcYearh5}{\code{numeric} mcYear to read for h5. Only for Non interactive mode.}

\item{tablesh5}{\code{character} tables for h5 ("areas" "links", "clusters" or "disticts"). Only for Non interactive mode.}

\item{language}{\code{character} language use for label. Defaut to 'en'. Can be 'fr'.}

\item{hidden}{\code{logical} Names of input to hide. Defaut to NULL}

\item{...}{Other arguments for \code{\link{manipulateWidget}}}
}
\value{
The function returns an object of class "htmlwidget". It is generated by
package \code{highcharter} if time step is annual or by \code{dygraphs} for 
any other time step.It can be directly displayed in the viewer or be stored
in a variable for later use.
}
\description{
This function generates an interactive plot of an antares time series.
}
\details{
If the input data contains several Monte-Carlo scenarios, the function will
display the evolution of the average value. Moreover it will represent a
95% confidence interval.

If the input data has a annual time step, the function creates a barplot
instead of a line chart.

compare argument can take following values :
\itemize{
   \item "mcYear"
   \item "main"
   \item "variable"
   \item "type"
   \item "typeConfInt"
   \item "confInt"
   \item "elements"
   \item "aggregate"
   \item "legend"
   \item "highlight"
   \item "stepPlot"
   \item "drawPoints"
   \item "secondAxis"
 }
}
\examples{
\dontrun{
setSimulationPath(path = path1)
mydata <- readAntares(areas = "all", timeStep = "hourly")
plot(x = mydata)

# Plot only a few areas
plot(x = mydata[area \%in\% c("area1", "area2", "area3")])

# If data contains detailed results, then the function adds a confidence
# interval
dataDetailed <- readAntares(areas = "all", timeStep = "hourly", mcYears = 1:2)
plot(x = dataDetailed)

# If the time step is annual, the function creates a barplot instead of a
# linechart
dataAnnual <- readAntares(areas = "all", timeStep = "annual")
plot(x = dataAnnual)

# Compare two simulaitons
# Compare the results of two simulations
setSimulationPath(path1)
mydata1 <- readAntares(areas = "all", timeStep = "daily")
setSimulationPath(path2)
mydata2 <- readAntares(areas = "all", timeStep = "daily")

plot(x = list(mydata1, mydata2))

# When you compare studies, you have 2 ways to defind inputs, union or intersect.
# for example, if you chose union and you have mcYears 1 and 2 in the first study
# and mcYears 2 and 3 in the second, mcYear input will be worth c(1, 2, 3)
# In same initial condition (study 1 -> 1,2 ans study 2 -> 2, 3) if you choose intersect,
# mcYear input will be wort 2.
# You must specify union or intersect with xyCompare argument (default union).
plot(x = list(mydata1[area \%in\% c("a", "b")],
 mydata1[area \%in\% c("b", "c")]), xyCompare = "union")
plot(x = list(mydata1[area \%in\% c("a", "b")],
 mydata1[area \%in\% c("b", "c")]), xyCompare = "intersect")

# Compare data in a single simulation
# Compare two periods for the same simulation
plot(x = mydata1, compare = "dateRange")

# Compare two Monte-Carlo scenarios
detailedData <- readAntares(areas = "all", mcYears = "all")
plot(x = detailedData, .compare = "mcYear")

# Use h5 for dynamic request / exploration in a study
# Set path of simulaiton
setSimulationPath(path = path1)

# Convert your study in h5 format
writeAntaresH5(path = mynewpath)

# Redefine sim path with h5 file
opts <- setSimulationPath(path = mynewpath)
plot(x = opts)

# Compare elements in a single study
plot(x = opts, .compare = "mcYear")
# Compare 2 studies
plot(x = list(opts, opts2))

# Compare 2 studies with argument refStudy 
plot(x = opts, refStudy = opts2)
plot(x = opts, refStudy = opts2, type = "ts", interactive = FALSE, mcYearh5 = 2)
plot(x = opts, refStudy = opts2, type = "ts", dateRange = DR, h5requestFiltering = list(
mcYears = mcYears = mcYearToTest))


}




}
