% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_layout.R
\name{plot.mapLayout}
\alias{plot.mapLayout}
\title{Plot method for map layout}
\usage{
\method{plot}{mapLayout}(x, colAreas = x$coords$color, dataAreas = 1,
  opacityArea = 1, areaMaxSize = 50, areaMaxHeight = 50,
  areaChartType = c("auto", "bar", "pie", "polar-area", "polar-radius"),
  popupArea = x$coords$area, labelArea = NULL, colLinks = "#CCCCCC",
  sizeLinks = 3, opacityLinks = 1, dirLinks = 0,
  popupLink = x$links$link, links = TRUE, areas = TRUE, addTiles = TRUE,
  background = "white", polygons = NULL, polygonOptions = list(stroke =
  TRUE, color = "#bbb", weight = 0.5, opacity = 1, fillOpacity = 0.2, options =
  list(clickable = FALSE)), width = NULL, height = NULL, ...)
}
\arguments{
\item{x}{Object created with function \code{\link{mapLayout}}}

\item{colAreas}{Vector of colors for areas. By default, the colors used in the Antares
software are used.}

\item{dataAreas}{A numeric vector or a numeric matrix that is passed to function
\code{link[addMinicharts]}. A single vector will produce circles with
different radius. A matrix will produce bar charts or pie charts or 
polar charts, depending on the value of \code{areaChartType}}

\item{opacityArea}{Opacity of areas. It has to be a numeric vector with values
between 0 and 1.}

\item{areaMaxSize}{Maximal width in pixels of the symbols that represent 
areas on the map.}

\item{areaMaxHeight}{Maximal height of bars. Used only if a barchart representation is used.}

\item{areaChartType}{Type of chart to use to represent areas.}

\item{popupArea}{Character vector containing the html to display when the user clicks on an
area.}

\item{labelArea}{Character vector containing labels to display inside areas.}

\item{colLinks}{Vector of colors for links.}

\item{sizeLinks}{Line width of the links, in pixels.}

\item{opacityLinks}{Opacity of the links. It has to be a numeric vector with values
between 0 and 1.}

\item{dirLinks}{Single value or vector indicating the direction of the link. Possible values
are 0, -1 and 1. If it equals 0, then links are repsented by a simple line. 
If it is equal to 1 or -1 it is represented by a line with an arrow pointing
respectively the destination and the origin of the link.}

\item{popupLink}{Character vector containing the html to display when the user clicks on a 
link.}

\item{links}{Should links be drawn on the map ?}

\item{areas}{Should areas be drawn on the map ?}

\item{addTiles}{Should a base map be downloaded on the internet and displayed ?}

\item{background}{background-color of the map. Not implemented yet.}

\item{polygons}{An object of class \code{SpatialPolygonsDataFrame} created by package 
\code{sp} or related packages. These polygons will be displayed above the 
base map (if any) and under the layer containing areas and links. It can
be useful to create maps that do not require an internet connection to be
correctly displayed or to display custom geographic area boundaries.}

\item{polygonOptions}{A list of options that are accepted by function 
\code{\link[leaflet]{addPolygons}}. When parameter \code{polygons} is 
provided, these options control how they are drawn on the map (color, 
opacity, etc.).}

\item{width}{Width of the graph expressed in pixels or in percentage of 
the parent element. For instance "500px" and "100\%" are valid values.}

\item{height}{Height of the graph expressed in pixels or in percentage of 
the parent element. For instance "500px" and "100\%" are valid values.}

\item{...}{Currently unused.}
}
\value{
The function generates an \code{htmlwidget} of class \code{leaflet}. It can
  be stored in a variable and modified with package 
  \code{\link[leaflet]{leaflet}}
}
\description{
This method can be used to visualize the network of an antares study.
It generates an interactive map with a visual representaiton of a
map layout created with function \code{\link{mapLayout}}.
}
\examples{
\dontrun{
# Read the coordinates of the areas in the Antares interface, then convert it
# in a map layout.
layout <- readLayout()
ml <- mapLayout(layout)

# Save the result for future use
save(ml, file = "ml.rda")

# Plot the network on an interactive map
plot(ml)

# change style
plot(ml, colAreas = gray(0.5), colLinks = "orange")

# Use polar area charts to represent multiple values for each area.
nareas <- nrow(ml$coords)
fakeData <- matrix(runif(nareas * 3), ncol = 3)
plot(ml, sizeAreas = fakeData)

# Store the result in a variable to change it with functions from leaflet 
# package
library(leaflet)

center <- c(mean(ml$coords$x), mean(ml$coords$y))

p <- plot(ml)
p \%>\% 
  addCircleMarker(center[1], center[2], color = "red", 
                  popup = "I'm the center !")
}

}
